/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.google.common.collect.ImmutableList;
import com.troblecodings.core.I18Wrapper;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.guilib.ecs.ContainerBase;
import com.troblecodings.guilib.ecs.DrawUtil;
import com.troblecodings.guilib.ecs.GuiBase;
import com.troblecodings.guilib.ecs.GuiElements;
import com.troblecodings.guilib.ecs.GuiInfo;
import com.troblecodings.guilib.ecs.entitys.UIBox;
import com.troblecodings.guilib.ecs.entitys.UIComponent;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import com.troblecodings.guilib.ecs.entitys.UITextInput;
import com.troblecodings.guilib.ecs.entitys.input.UIClickable;
import com.troblecodings.guilib.ecs.entitys.input.UIDrag;
import com.troblecodings.guilib.ecs.entitys.input.UIScroll;
import com.troblecodings.guilib.ecs.entitys.render.UIBorder;
import com.troblecodings.guilib.ecs.entitys.render.UIButton;
import com.troblecodings.guilib.ecs.entitys.render.UIColor;
import com.troblecodings.guilib.ecs.entitys.render.UILabel;
import com.troblecodings.guilib.ecs.entitys.render.UILines;
import com.troblecodings.guilib.ecs.entitys.render.UIScissor;
import com.troblecodings.guilib.ecs.entitys.render.UITexture;
import com.troblecodings.guilib.ecs.entitys.render.UIToolTip;
import com.troblecodings.guilib.ecs.entitys.transform.UIScale;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.config.ConfigHandler;
import com.troblecodings.signals.core.JsonEnumHolder;
import com.troblecodings.signals.core.ModeIdentifier;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.core.SubsidiaryEntry;
import com.troblecodings.signals.core.SubsidiaryHolder;
import com.troblecodings.signals.core.SubsidiaryState;
import com.troblecodings.signals.core.TrainNumber;
import com.troblecodings.signals.enums.EnumGuiMode;
import com.troblecodings.signals.enums.EnumPathUsage;
import com.troblecodings.signals.enums.LinkType;
import com.troblecodings.signals.enums.ShowTypes;
import com.troblecodings.signals.enums.SignalBoxNetwork;
import com.troblecodings.signals.guis.ContainerSignalBox;
import com.troblecodings.signals.guis.SidePanel;
import com.troblecodings.signals.guis.UIMenu;
import com.troblecodings.signals.guis.UISignalBoxTile;
import com.troblecodings.signals.handler.ClientNameHandler;
import com.troblecodings.signals.signalbox.MainSignalIdentifier;
import com.troblecodings.signals.signalbox.ModeSet;
import com.troblecodings.signals.signalbox.Path;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.SignalBoxNode;
import com.troblecodings.signals.signalbox.SignalBoxUtil;
import com.troblecodings.signals.signalbox.entrys.PathEntryType;
import com.troblecodings.signals.signalbox.entrys.PathOptionEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GuiSignalBox
extends GuiBase {
    public static final int SELECTION_COLOR = 687931136;
    public static final int BACKGROUND_COLOR = ConfigHandler.signalboxBackgroundColor;
    public static final int GRID_COLOR = -10790053;
    public static final int EDIT_COLOR = 1342219007;
    public static final int OUTPUT_COLOR = 0xFFFF00;
    private static final float[] ALL_LINES = GuiSignalBox.getLines();
    private static final int TILE_WIDTH = 10;
    private static final int TILE_COUNT = 100;
    private final UIEntity lowerEntity = new UIEntity();
    protected final ContainerSignalBox container;
    private UISignalBoxTile lastTile = null;
    private UIEntity mainButton;
    private final GuiInfo info;
    private final Map<Point, SignalBoxNode> changedModes = new HashMap<Point, SignalBoxNode>();
    private UIEntity splitter = new UIEntity();
    private boolean allPacketsRecived = false;
    protected final Map<Point, UISignalBoxTile> allTiles = new HashMap<Point, UISignalBoxTile>();
    private SidePanel helpPage;
    private final Map<BlockPos, SubsidiaryHolder> enabledSubsidiaries = new HashMap<BlockPos, SubsidiaryHolder>();
    private final Map<Point, UIColor> colors = new HashMap<Point, UIColor>();
    private int lastValue = 0;

    private static float[] getLines() {
        float[] lines = new float[808];
        float step = 0.01f;
        for (int i = 0; i <= 100; ++i) {
            float pos;
            int offset = i * 4;
            lines[offset] = pos = (float)i * 0.01f;
            lines[offset + 1] = 0.0f;
            lines[offset + 2] = pos;
            lines[offset + 3] = 1.0f;
            int offset2 = (i + 100 + 1) * 4;
            lines[offset2] = 0.0f;
            lines[offset2 + 1] = pos;
            lines[offset2 + 2] = 1.0f;
            lines[offset2 + 3] = pos;
        }
        return lines;
    }

    public GuiSignalBox(GuiInfo info) {
        super(info);
        this.container = (ContainerSignalBox)info.base;
        this.container.setConsumer(this::update);
        this.container.setColorUpdater(this::applyColorChanges);
        this.container.setSignalUpdater(this::updateSignals);
        this.container.setConuterUpdater(this::updateCounter);
        this.container.setTrainNumberUpdater(this::updateTrainNumber);
        info.player.field_71070_bA = this.container;
        this.info = info;
    }

    public void update(String errorString) {
        this.resetTileSelection();
        UIToolTip tooltip = new UIToolTip(errorString, true);
        this.lowerEntity.add(tooltip);
        new Thread(() -> {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.lowerEntity.remove(tooltip);
        }).start();
    }

    public void updateSignals(List<Point> updated) {
        updated.forEach(point -> {
            UISignalBoxTile tile = this.allTiles.get(point);
            tile.setGreenSignals(this.container.greenSignals.getOrDefault(point, new ArrayList()));
            tile.getNode().forEach(mode -> {
                if (mode.mode.equals((Object)EnumGuiMode.HP) || mode.mode.equals((Object)EnumGuiMode.VP) || mode.mode.equals((Object)EnumGuiMode.RS)) {
                    tile.updateModeSet((ModeSet)mode);
                }
            });
        });
    }

    private void updateTrainNumber(List<Point> points) {
        points.forEach(point -> {
            UISignalBoxTile tile = this.allTiles.get(point);
            tile.updateTrainNumber();
        });
        this.lowerEntity.update();
    }

    protected void resetTileSelection() {
        this.colors.values().forEach(color -> color.getParent().remove((UIComponent)color));
        this.colors.clear();
        this.lastTile = null;
    }

    private void selectLink(UIEntity parent, SignalBoxNode node, PathOptionEntry option, Set<Map.Entry<BlockPos, LinkType>> entrySet, LinkType type, PathEntryType<BlockPos> entryType, EnumGuiMode mode, Rotation rotation) {
        this.selectLink(parent, node, option, entrySet, type, entryType, mode, rotation, "");
    }

    private void selectLink(UIEntity parent, SignalBoxNode node, PathOptionEntry option, Set<Map.Entry<BlockPos, LinkType>> entrySet, LinkType type, PathEntryType<BlockPos> entryType, EnumGuiMode mode, Rotation rotation, String suffix) {
        ArrayList positions = new ArrayList();
        positions.addAll(entrySet.stream().filter(e -> ((LinkType)e.getValue()).equals(type)).map(e -> (BlockPos)e.getKey()).collect(Collectors.toList()));
        if (positions.size() > 0) {
            DrawUtil.DisableIntegerable<String> blockPos = new DrawUtil.DisableIntegerable<String>(DrawUtil.SizeIntegerables.of("prop." + type.name() + suffix, positions.size(), id -> {
                BlockPos pos = (BlockPos)positions.get(id);
                if (pos == null) {
                    return "Disabled";
                }
                return GuiSignalBox.getSignalInfo(pos, type);
            }));
            UIEntity blockSelect = GuiElements.createEnumElement(blockPos, id -> {
                BlockPos setPos;
                BlockPos blockPos = setPos = id >= 0 ? (BlockPos)positions.get(id) : null;
                if (setPos == null) {
                    if (!option.getEntry(entryType).isPresent()) {
                        return;
                    }
                    option.removeEntry(entryType);
                    this.removeEntryFromServer(node, mode, rotation, entryType);
                } else {
                    Optional pathEntry = option.getEntry(entryType);
                    if (pathEntry.isPresent() && ((BlockPos)pathEntry.get()).equals((Object)setPos)) {
                        return;
                    }
                    option.setEntry(entryType, setPos);
                    this.sendPosEntryToServer(setPos, node, mode, rotation, entryType);
                }
            }, option.getEntry(entryType).map(entry -> positions.indexOf(entry)).orElse(-1));
            parent.add(blockSelect);
        }
    }

    public static String getSignalInfo(BlockPos signalPos, LinkType type) {
        Minecraft mc = Minecraft.func_71410_x();
        String customName = ClientNameHandler.getClientName(new StateInfo((World)mc.field_71441_e, signalPos));
        Object[] objectArray = new Object[4];
        objectArray[0] = customName == null ? (type.equals(LinkType.SIGNAL) ? "" : I18Wrapper.format("type." + type.name(), new Object[0])) : customName;
        objectArray[1] = signalPos.func_177958_n();
        objectArray[2] = signalPos.func_177956_o();
        objectArray[3] = signalPos.func_177952_p();
        return String.format("%s (x=%d, y=%d. z=%d)", objectArray);
    }

    private void setupModeSettings(UIEntity parent, EnumGuiMode mode, Rotation rotation, SignalBoxNode node, PathOptionEntry option) {
        String modeName = I18Wrapper.format("property." + mode.name(), new Object[0]);
        String rotationName = I18Wrapper.format("property." + rotation.name() + ".rotation", new Object[0]);
        UIEntity entity = new UIEntity();
        entity.setInheritWidth(true);
        entity.setHeight(20.0);
        entity.add(new UIColor(BACKGROUND_COLOR));
        entity.add(new UIScale(1.1f, 1.1f, 1.0f));
        UILabel modeLabel = new UILabel(modeName + " - " + rotationName);
        modeLabel.setCenterX(false);
        entity.add(modeLabel);
        parent.add(entity);
        Set<Map.Entry<BlockPos, LinkType>> entrySet = this.container.getPositionForTypes().entrySet();
        ModeSet modeSet = new ModeSet(mode, rotation);
        switch (mode) {
            case CORNER: 
            case STRAIGHT: {
                EnumPathUsage path = option.getEntry(PathEntryType.PATHUSAGE).orElse(EnumPathUsage.FREE);
                UIEntity stateEntity = new UIEntity();
                stateEntity.setInheritWidth(true);
                stateEntity.setHeight(15.0);
                String pathUsageName = I18Wrapper.format("property.status", new Object[0]) + ": ";
                String pathUsage = I18Wrapper.format("property." + (Object)((Object)path), new Object[0]);
                stateEntity.add(new UILabel(pathUsageName + pathUsage));
                parent.add(stateEntity);
                if (path.equals((Object)EnumPathUsage.BLOCKED)) {
                    UIEntity layout = new UIEntity();
                    layout.add(new UIBox(UIBox.HBOX, 2));
                    layout.setHeight(20.0);
                    layout.setInheritWidth(true);
                    UIEntity inputEntity = new UIEntity();
                    inputEntity.setInheritHeight(true);
                    inputEntity.setWidth(250.0);
                    UITextInput input = new UITextInput("");
                    inputEntity.add(input);
                    inputEntity.add(new UIToolTip(I18Wrapper.format("sb.trainnumber.change", new Object[0])));
                    layout.add(inputEntity);
                    UIEntity save = GuiElements.createButton(I18Wrapper.format("btn.save", new Object[0]), e -> {
                        this.sendTrainNumber(node.getPoint(), input.getText());
                        input.setText("");
                    });
                    save.add(new UIToolTip(I18Wrapper.format("sb.trainnumber.save", new Object[0])));
                    layout.add(save);
                    UIEntity uIEntity = GuiElements.createButton("x", e -> this.deleteTrainNumber(node.getPoint()));
                    uIEntity.add(new UIToolTip(I18Wrapper.format("sb.trainnumber.remove", new Object[0])));
                    layout.add(uIEntity);
                    parent.add(layout);
                }
                DrawUtil.SizeIntegerables<Integer> size = new DrawUtil.SizeIntegerables<Integer>("speed", 15, i -> i);
                UIEntity speedSelection = GuiElements.createEnumElement(size, id -> {
                    int speed = id > 0 ? id : 127;
                    Optional<Integer> opt = option.getEntry(PathEntryType.SPEED);
                    if (speed == 127 && opt.isPresent()) {
                        this.removeEntryFromServer(node, mode, rotation, PathEntryType.SPEED);
                        option.removeEntry(PathEntryType.SPEED);
                    } else if (opt.isPresent() && opt.get() != speed || !opt.isPresent() && speed != 127) {
                        this.sendIntEntryToServer(speed, node, mode, rotation, PathEntryType.SPEED);
                        option.setEntry(PathEntryType.SPEED, speed);
                    }
                }, option.getEntry(PathEntryType.SPEED).filter(n -> n < 16).orElse(127));
                parent.add(speedSelection);
                this.selectLink(parent, node, option, entrySet, LinkType.OUTPUT, PathEntryType.OUTPUT, mode, rotation);
                if (option.getEntry(PathEntryType.OUTPUT).isPresent()) {
                    AtomicBoolean canBeManuelChanged = new AtomicBoolean(true);
                    for (Map.Entry entry : node.getModes().entrySet()) {
                        Optional<EnumPathUsage> usage = ((PathOptionEntry)entry.getValue()).getEntry(PathEntryType.PATHUSAGE);
                        if (!usage.isPresent() || usage.get().equals((Object)EnumPathUsage.FREE)) continue;
                        canBeManuelChanged.set(false);
                        break;
                    }
                    UILabel currentStatus = new UILabel(I18Wrapper.format("info.usage.status", new Object[0]) + " : " + I18Wrapper.format("info.usage.status.free", new Object[0]));
                    currentStatus.setTextColor(new UIEntity().getBasicTextColor());
                    UIEntity uIEntity = new UIEntity();
                    uIEntity.setInheritWidth(true);
                    uIEntity.setHeight(20.0);
                    uIEntity.add(new UIScale(1.1f, 1.1f, 1.0f));
                    uIEntity.add(currentStatus);
                    UIEntity manuelButton = GuiElements.createButton(I18Wrapper.format("info.usage.manuel", new Object[0]), e1 -> {
                        Optional<EnumPathUsage> usage = option.getEntry(PathEntryType.PATHUSAGE);
                        UIEntity info = new UIEntity();
                        info.setInherits(true);
                        info.add(new UIBox(UIBox.VBOX, 5));
                        info.add(new UIColor(BACKGROUND_COLOR));
                        info.add(new UIClickable(_u -> this.pop(), 1));
                        info.add(statusEntity);
                        UIEntity textureEntity = new UIEntity();
                        textureEntity.setHeight(40.0);
                        textureEntity.setWidth(40.0);
                        textureEntity.setX(120.0);
                        textureEntity.add(new UIToolTip(I18Wrapper.format("info.usage.rs.desc", new Object[0])));
                        if (canBeManuelChanged.get()) {
                            if (node.containsManuellOutput(modeSet)) {
                                textureEntity.add(new UITexture(SidePanel.REDSTONE_ON));
                            } else {
                                textureEntity.add(new UITexture(SidePanel.REDSTONE_OFF));
                            }
                        } else if (usage.isPresent() && !usage.get().equals((Object)EnumPathUsage.FREE)) {
                            textureEntity.add(new UITexture(SidePanel.REDSTONE_ON_BLOCKED));
                        } else {
                            textureEntity.add(new UITexture(SidePanel.REDSTONE_OFF_BLOCKED));
                        }
                        info.add(textureEntity);
                        UILabel outputStatus = new UILabel(usage.isPresent() && !usage.get().equals((Object)EnumPathUsage.FREE) || node.containsManuellOutput(modeSet) ? I18Wrapper.format("info.usage.rs.true", new Object[0]) : I18Wrapper.format("info.usage.rs.false", new Object[0]));
                        outputStatus.setCenterY(false);
                        outputStatus.setTextColor(new UIEntity().getBasicTextColor());
                        UIEntity outputEntity = new UIEntity();
                        outputEntity.setInheritWidth(true);
                        outputEntity.setHeight(20.0);
                        outputEntity.add(outputStatus);
                        info.add(outputEntity);
                        if (canBeManuelChanged.get()) {
                            info.add(GuiElements.createButton(I18Wrapper.format("info.usage.change", new Object[0]), i -> {
                                boolean turnOff = node.containsManuellOutput(modeSet);
                                textureEntity.clear();
                                textureEntity.add(new UIToolTip(I18Wrapper.format("info.usage.rs.desc", new Object[0])));
                                if (turnOff) {
                                    this.changeRedstoneOutput(node.getPoint(), modeSet, false);
                                    outputStatus.setText(I18Wrapper.format("info.usage.rs.false", new Object[0]));
                                    textureEntity.add(new UITexture(SidePanel.REDSTONE_OFF));
                                } else {
                                    this.changeRedstoneOutput(node.getPoint(), modeSet, true);
                                    outputStatus.setText(I18Wrapper.format("info.usage.rs.true", new Object[0]));
                                    textureEntity.add(new UITexture(SidePanel.REDSTONE_ON));
                                }
                            }));
                        }
                        UIEntity screen = GuiElements.createScreen(e -> e.add(info));
                        this.push(screen);
                    });
                    manuelButton.add(new UIToolTip(I18Wrapper.format("info.usage.manuel.desc", new Object[0])));
                    parent.add(manuelButton);
                }
                this.selectLink(parent, node, option, entrySet, LinkType.INPUT, PathEntryType.BLOCKING, mode, rotation, ".blocking");
                this.selectLink(parent, node, option, entrySet, LinkType.INPUT, PathEntryType.RESETING, mode, rotation, ".resetting");
                UIEntity zs2Entity = GuiElements.createEnumElement(JsonEnumHolder.ZS32, e -> {
                    if (e == 0) {
                        this.removeEntryFromServer(node, mode, rotation, PathEntryType.ZS2);
                        option.removeEntry(PathEntryType.ZS2);
                    } else {
                        this.sendZS2Entry((byte)e, node, mode, rotation, PathEntryType.ZS2);
                        option.setEntry(PathEntryType.ZS2, (byte)e);
                    }
                }, option.getEntry(PathEntryType.ZS2).orElse((byte)0).byteValue());
                parent.add(zs2Entity);
                parent.add(GuiElements.createButton(I18Wrapper.format("button.reset", new Object[0]), e -> {
                    this.reset();
                    this.initializeFieldUsage(this.mainButton);
                    this.resetPathwayOnServer(node);
                }));
                break;
            }
            case VP: {
                this.selectLink(parent, node, option, entrySet, LinkType.SIGNAL, PathEntryType.SIGNAL, mode, rotation);
                Optional<Boolean> opt = option.getEntry(PathEntryType.SIGNAL_REPEATER);
                parent.add(GuiElements.createBoolElement(DrawUtil.BoolIntegerables.of("signal_repeater"), e -> {
                    boolean state = e == 1;
                    this.sendSignalRepeater(node.getPoint(), modeSet, state);
                    option.setEntry(PathEntryType.SIGNAL_REPEATER, state);
                }, opt.isPresent() && opt.get() != false ? 1 : 0));
                break;
            }
            case HP: {
                parent.add(GuiElements.createBoolElement(DrawUtil.BoolIntegerables.of("auto_pathway"), e -> {
                    this.setAutoPoint(node.getPoint(), (byte)e);
                    node.setAutoPoint(e == 1);
                }, node.isAutoPoint() ? 1 : 0));
            }
            case RS: {
                if (option.containsEntry(PathEntryType.SIGNAL)) {
                    parent.add(GuiElements.createButton(I18Wrapper.format("btn.subsidiary", new Object[0]), e -> {
                        UIBox hbox = new UIBox(UIBox.VBOX, 1);
                        UIEntity list = new UIEntity();
                        list.setInherits(true);
                        list.add(hbox);
                        list.add(GuiElements.createButton(I18Wrapper.format("btn.return", new Object[0]), a -> this.pop()));
                        BlockPos pos = option.getEntry(PathEntryType.SIGNAL).get();
                        List<SubsidiaryState> subsidiaries = this.container.possibleSubsidiaries.getOrDefault(pos, SubsidiaryState.ALL_STATES);
                        subsidiaries.forEach(state -> {
                            int defaultValue = this.container.grid.getSubsidiaryState(node.getPoint(), modeSet, (SubsidiaryState)state) ? 0 : 1;
                            list.add(GuiElements.createEnumElement(new DrawUtil.SizeIntegerables<String>(state.getName(), 2, i -> i == 1 ? "false" : "true"), a -> {
                                SubsidiaryEntry entry = new SubsidiaryEntry((SubsidiaryState)state, a == 0);
                                this.sendSubsidiaryRequest(entry, node.getPoint(), modeSet);
                                this.container.grid.setClientState(node.getPoint(), modeSet, entry);
                                BlockPos signalPos = option.getEntry(PathEntryType.SIGNAL).orElse(null);
                                if (signalPos != null) {
                                    if (entry.state) {
                                        this.enabledSubsidiaries.put(signalPos, new SubsidiaryHolder(entry, node.getPoint(), modeSet));
                                    } else {
                                        this.enabledSubsidiaries.remove(signalPos);
                                    }
                                }
                                this.pop();
                                this.helpPage.helpUsageMode(this.enabledSubsidiaries, null, this.container.grid.getNodes(), this.container.possibleSubsidiaries);
                                MainSignalIdentifier identifier = new MainSignalIdentifier(new ModeIdentifier(node.getPoint(), modeSet), pos, MainSignalIdentifier.SignalState.combine(state.getSubsidiaryShowType()));
                                List greenSignals = this.container.greenSignals.computeIfAbsent(identifier.getPoint(), _u -> new ArrayList());
                                if (entry.state) {
                                    if (greenSignals.contains(identifier)) {
                                        greenSignals.remove(identifier);
                                    }
                                    greenSignals.add(identifier);
                                } else {
                                    greenSignals.remove(identifier);
                                }
                                this.updateSignals((List<Point>)ImmutableList.of((Object)node.getPoint()));
                                if (state.isCountable() && entry.state) {
                                    this.container.grid.countOne();
                                    this.updateCounter();
                                    this.sendCurrentCounterToServer();
                                }
                            }, defaultValue));
                        });
                        UIEntity screen = GuiElements.createScreen(selection -> {
                            selection.add(list);
                            selection.add(GuiElements.createPageSelect(hbox));
                        });
                        this.push(screen);
                    }));
                }
                this.selectLink(parent, node, option, entrySet, LinkType.SIGNAL, PathEntryType.SIGNAL, mode, rotation);
                break;
            }
            case BUE: {
                parent.add(GuiElements.createEnumElement(new DrawUtil.SizeIntegerables<String>("delay", 60, get -> String.valueOf(get)), i -> {
                    option.setEntry(PathEntryType.DELAY, i);
                    this.sendIntEntryToServer(i, node, mode, rotation, PathEntryType.DELAY);
                }, option.getEntry(PathEntryType.DELAY).orElse(0)));
                break;
            }
            case OUT_CONNECTION: {
                List validInConnections;
                this.selectLink(parent, node, option, entrySet, LinkType.SIGNALBOX, PathEntryType.SIGNALBOX, mode, rotation);
                Optional<BlockPos> boxPos = option.getEntry(PathEntryType.SIGNALBOX);
                if (!boxPos.isPresent() || (validInConnections = (List)this.container.validInConnections.getOrDefault(boxPos.get(), new ArrayList())).isEmpty()) break;
                DrawUtil.DisableIntegerable<String> integerable = new DrawUtil.DisableIntegerable<String>(DrawUtil.SizeIntegerables.of("inconnection", validInConnections.size(), id -> {
                    Point point = (Point)validInConnections.get(id);
                    if (point == null) {
                        return "Disabled";
                    }
                    return point.toShortString();
                }));
                parent.add(GuiElements.createEnumElement(integerable, e -> {
                    Point point;
                    Point point2 = point = e >= 0 ? (Point)validInConnections.get(e) : null;
                    if (point == null) {
                        option.removeEntry(PathEntryType.POINT);
                        this.removeEntryFromServer(node, mode, rotation, PathEntryType.POINT);
                    } else {
                        option.setEntry(PathEntryType.POINT, point);
                        this.sendPointEntry(point, node, mode, rotation, PathEntryType.POINT);
                    }
                }, option.getEntry(PathEntryType.POINT).map(point -> validInConnections.indexOf(point)).orElse(-1)));
                break;
            }
            case IN_CONNECTION: {
                List<Point> validEnds = this.container.grid.getValidEnds();
                if (validEnds.isEmpty()) break;
                DrawUtil.DisableIntegerable<String> integerable = new DrawUtil.DisableIntegerable<String>(DrawUtil.SizeIntegerables.of("inconnection", validEnds.size(), id -> {
                    Point point = (Point)validEnds.get(id);
                    if (point == null) {
                        return "Disabled";
                    }
                    return point.toShortString();
                }));
                parent.add(GuiElements.createEnumElement(integerable, e -> {
                    Point point;
                    Point point2 = point = e >= 0 ? (Point)validEnds.get(e) : null;
                    if (point == null) {
                        option.removeEntry(PathEntryType.POINT);
                        this.removeEntryFromServer(node, mode, rotation, PathEntryType.POINT);
                    } else {
                        option.setEntry(PathEntryType.POINT, point);
                        this.sendPointEntry(point, node, mode, rotation, PathEntryType.POINT);
                    }
                }, option.getEntry(PathEntryType.POINT).map(point -> validEnds.indexOf(point)).orElse(-1)));
                break;
            }
        }
    }

    private void disableSubsidiary(BlockPos pos, SubsidiaryHolder holder) {
        SubsidiaryEntry entry = new SubsidiaryEntry(holder.entry.enumValue, false);
        this.sendSubsidiaryRequest(entry, holder.point, holder.modeSet);
        this.container.grid.setClientState(holder.point, holder.modeSet, entry);
        this.enabledSubsidiaries.remove(pos);
        this.helpPage.helpUsageMode(this.enabledSubsidiaries, null, this.container.grid.getNodes(), this.container.possibleSubsidiaries);
        this.resetTileSelection();
        MainSignalIdentifier identifier = new MainSignalIdentifier(new ModeIdentifier(holder.point, holder.modeSet), pos, MainSignalIdentifier.SignalState.combine(entry.enumValue.getSubsidiaryShowType()));
        List greenSignals = this.container.greenSignals.computeIfAbsent(identifier.getPoint(), _u -> new ArrayList());
        greenSignals.remove(identifier);
        this.updateSignals((List<Point>)ImmutableList.of((Object)holder.point));
    }

    private void tileEdit(UIEntity tile, UIMenu menu, UISignalBoxTile sbt) {
        tile.add(new UIClickable(e -> {
            if (!this.splitter.isHovered()) {
                return;
            }
            EnumGuiMode mode = EnumGuiMode.values()[menu.getSelection()];
            Rotation rotation = Rotation.values()[menu.getRotation()];
            ModeSet modeSet = new ModeSet(mode, rotation);
            SignalBoxNode node = sbt.getNode();
            if (sbt.has(modeSet)) {
                sbt.remove(modeSet);
            } else {
                sbt.add(modeSet);
            }
            this.changedModes.put(sbt.getPoint(), node);
        }));
    }

    private void tileNormal(UIEntity tile, UISignalBoxTile currentTile) {
        tile.add(new UIClickable(c -> {
            if (this.lastTile == null) {
                if (currentTile.isValidStart()) {
                    this.lastTile = currentTile;
                    UIColor previous = this.colors.get(currentTile.getPoint());
                    if (previous != null) {
                        previous.getParent().remove(previous);
                    }
                    UIColor newColor = new UIColor(687931136);
                    c.add(newColor);
                    this.colors.put(currentTile.getPoint(), newColor);
                }
            } else {
                if (this.lastTile == currentTile) {
                    this.resetTileSelection();
                    return;
                }
                if (currentTile.isValidEnd()) {
                    this.sendPWRequest(currentTile.getNode());
                    this.resetTileSelection();
                    return;
                }
            }
        }));
        tile.add(new UIClickable(e -> this.openNodeShortcuts(currentTile.getNode(), (UIEntity)e), 1));
    }

    private void resetSelection(UIEntity entity) {
        UIEntity parent = entity.getParent();
        parent.findRecursive(UIClickable.class).forEach(click -> click.setVisible(true));
        parent.findRecursive(UIButton.class).forEach(btn -> btn.setEnabled(true));
        entity.findRecursive(UIButton.class).forEach(btn -> btn.setEnabled(false));
        entity.findRecursive(UIClickable.class).forEach(click -> click.setVisible(false));
    }

    private void openNodeShortcuts(SignalBoxNode node, UIEntity entity) {
        if (node.isEmpty()) {
            return;
        }
        UIColor previous = this.colors.get(node.getPoint());
        if (previous != null && previous.getColor() == 1342219007) {
            this.helpPage.helpUsageMode(this.enabledSubsidiaries, null, this.container.grid.getNodes(), this.container.possibleSubsidiaries);
            this.helpPage.setShowHelpPage(false);
            this.resetTileSelection();
            return;
        }
        this.resetTileSelection();
        UIColor newColor = new UIColor(1342219007);
        entity.add(newColor);
        this.colors.put(node.getPoint(), newColor);
        this.helpPage.helpUsageMode(this.enabledSubsidiaries, node, this.container.grid.getNodes(), this.container.possibleSubsidiaries);
        this.helpPage.setShowHelpPage(true);
    }

    protected void initializePageTileConfig(SignalBoxNode node) {
        if (node.isEmpty()) {
            return;
        }
        this.reset();
        UIEntity list = new UIEntity();
        list.setInheritHeight(true);
        list.setInheritWidth(true);
        UIBox box = new UIBox(UIBox.VBOX, 1);
        list.add(box);
        this.lowerEntity.add(new UIBox(UIBox.VBOX, 3));
        this.lowerEntity.add(list);
        UIEntity input = new UIEntity();
        input.setInheritWidth(true);
        UITextInput namingInput = new UITextInput(node.getCustomText());
        input.add(namingInput);
        input.setHeight(20.0);
        list.add(input);
        namingInput.setOnTextUpdate(str -> {
            node.setCustomText((String)str);
            this.sendName(node.getPoint(), (String)str);
        });
        node.forEach(modeSet -> this.setupModeSettings(list, modeSet.mode, modeSet.rotation, node, node.getOption((ModeSet)modeSet).get()));
        this.lowerEntity.add(GuiElements.createPageSelect(box));
        this.lowerEntity.add(new UIClickable(e -> this.initializeFieldUsage(this.mainButton), 1));
    }

    private void initializePageSettings(UIEntity entity) {
        this.initializePageSettings(entity, this.container.getPositionForTypes());
    }

    private void initializePageSettings(UIEntity entity, Map<BlockPos, LinkType> types) {
        this.reset();
        this.lowerEntity.add(new UIBox(UIBox.VBOX, 2));
        this.lowerEntity.setInheritHeight(true);
        this.lowerEntity.setInheritWidth(true);
        DrawUtil.EnumIntegerable<ShowTypes> sorting = new DrawUtil.EnumIntegerable<ShowTypes>(ShowTypes.class);
        this.lowerEntity.add(GuiElements.createEnumElement(sorting, i -> {
            this.lastValue = i;
            if (i == -1) {
                return;
            }
            ShowTypes option = ShowTypes.values()[i];
            switch (option) {
                case ALL: {
                    this.initializePageSettings(entity);
                    break;
                }
                case INPUT: {
                    this.initializePageSettings(entity, this.container.getPositionForTypes().entrySet().stream().filter(entry -> ((LinkType)entry.getValue()).equals(LinkType.INPUT)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
                    break;
                }
                case OUTPUT: {
                    this.initializePageSettings(entity, this.container.getPositionForTypes().entrySet().stream().filter(entry -> ((LinkType)entry.getValue()).equals(LinkType.OUTPUT)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
                    break;
                }
                case SIGNAL: {
                    this.initializePageSettings(entity, this.container.getPositionForTypes().entrySet().stream().filter(entry -> ((LinkType)entry.getValue()).equals(LinkType.SIGNAL)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
                    break;
                }
                case SIGNALBOX: {
                    this.initializePageSettings(entity, this.container.getPositionForTypes().entrySet().stream().filter(entry -> ((LinkType)entry.getValue()).equals(LinkType.SIGNALBOX)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
                    break;
                }
            }
        }, this.lastValue));
        UIEntity inputEntity = new UIEntity();
        inputEntity.setInheritWidth(true);
        inputEntity.setHeight(20.0);
        UITextInput input = new UITextInput("");
        inputEntity.add(input);
        this.lowerEntity.add(inputEntity);
        UIEntity list = new UIEntity();
        UIBox uibox = new UIBox(UIBox.VBOX, 2);
        list.add(uibox);
        HashMap nameToUIEntity = new HashMap();
        list.add(uibox);
        list.setInherits(true);
        types.forEach((p, t) -> {
            String name = GuiSignalBox.getSignalInfo(p, t);
            UIEntity layout = new UIEntity();
            layout.setHeight(20.0);
            layout.setInheritWidth(true);
            layout.add(new UIBox(UIBox.HBOX, 2));
            int id = t.ordinal();
            UIEntity icon = new UIEntity();
            UITexture texture = t.equals(LinkType.SIGNALBOX) ? new UITexture(new ResourceLocation("opensignals", "textures/blocks/signalbox.png")) : new UITexture(UISignalBoxTile.ICON, 0.2 * (double)id, 0.5, 0.2 * (double)id + 0.2, 1.0);
            icon.add(texture);
            icon.setHeight(20.0);
            icon.setWidth(20.0);
            icon.add(new UIToolTip(I18Wrapper.format("type." + t.name(), new Object[0])));
            layout.add(icon);
            layout.add(GuiElements.createButton(name));
            layout.add(GuiElements.createButton("x", 20, e -> {
                this.removeBlockPos((BlockPos)p);
                list.remove(layout);
            }));
            list.add(layout);
            nameToUIEntity.put(name.toLowerCase(), layout);
        });
        this.lowerEntity.add(list);
        this.lowerEntity.add(GuiElements.createPageSelect(uibox));
        this.resetSelection(entity);
        input.setOnTextUpdate(string -> nameToUIEntity.forEach((name, e) -> {
            if (!name.contains(string.toLowerCase())) {
                list.remove((UIEntity)e);
            } else {
                list.add((UIEntity)e);
            }
        }));
    }

    private void initializeFieldUsage(UIEntity entity) {
        this.reset();
        this.sendModeChanges();
        this.initializeFieldTemplate(this::tileNormal, false);
        this.resetSelection(entity);
        this.helpPage.helpUsageMode(this.enabledSubsidiaries, null, this.container.grid.getNodes(), this.container.possibleSubsidiaries);
    }

    private void initializeFieldEdit(UIEntity entity) {
        UIEntity screen = GuiElements.createScreen(selectionEntity -> {
            UIBox hbox = new UIBox(UIBox.VBOX, 3);
            selectionEntity.add(hbox);
            UIEntity question = new UIEntity();
            UILabel label = new UILabel(I18Wrapper.format("sb.editmode", new Object[0]));
            label.setTextColor(-1);
            question.setScaleX(1.1f);
            question.setScaleY(1.1f);
            question.add(label);
            question.setInherits(true);
            UILabel info = new UILabel(I18Wrapper.format("sb.allreset", new Object[0]));
            info.setTextColor(-1);
            UIEntity infoEntity = new UIEntity();
            infoEntity.add(info);
            infoEntity.setInherits(true);
            selectionEntity.add(question);
            selectionEntity.add(infoEntity);
            UIEntity buttons = new UIEntity();
            UIEntity buttonYes = GuiElements.createButton(I18Wrapper.format("btn.yes", new Object[0]), e -> {
                this.pop();
                this.reset();
                UIMenu menu = new UIMenu();
                menu.setVisible(false);
                this.initializeFieldTemplate((fieldEntity, name) -> this.tileEdit((UIEntity)fieldEntity, menu, (UISignalBoxTile)name), true);
                this.lowerEntity.add(menu);
                menu.setConsumer((selection, rotation) -> this.helpPage.updateNextNode((int)selection, (int)rotation));
                this.resetSelection(entity);
                this.resetAllPathways();
                this.helpPage.updateNextNode(menu.getSelection(), menu.getRotation());
                this.lastTile = null;
            });
            UIEntity buttonNo = GuiElements.createButton(I18Wrapper.format("btn.no", new Object[0]), e -> this.pop());
            buttons.setInherits(true);
            UIBox vbox = new UIBox(UIBox.HBOX, 1);
            buttons.add(vbox);
            buttons.add(buttonYes);
            buttons.add(buttonNo);
            selectionEntity.add(buttons);
        });
        this.push(screen);
    }

    private void initializeFieldTemplate(BiConsumer<UIEntity, UISignalBoxTile> consumer, boolean showLines) {
        this.splitter.clear();
        UIEntity plane = new UIEntity();
        plane.clearChildren();
        plane.setWidth(1000.0);
        plane.setHeight(1000.0);
        this.splitter.add(new UIScroll(s -> {
            float newScale = (float)((double)plane.getScaleX() + s * (double)0.001f);
            if (newScale <= 0.0f) {
                return;
            }
            plane.setScaleX(newScale);
            plane.setScaleY(newScale);
            plane.update();
        }));
        this.splitter.add(new UIDrag((x, y) -> {
            plane.setX(plane.getX() + x);
            plane.setY(plane.getY() + y);
            plane.update();
        }, 2));
        if (showLines) {
            UILines allLines = new UILines(ALL_LINES, 0.5f);
            allLines.setColor(-10790053);
            plane.add(allLines);
        }
        UIBox vbox = new UIBox(UIBox.VBOX, 0);
        vbox.setPageable(false);
        plane.add(vbox);
        this.allTiles.clear();
        for (int x2 = 0; x2 < 100; ++x2) {
            UIEntity row = new UIEntity();
            UIBox hbox = new UIBox(UIBox.HBOX, 0);
            hbox.setPageable(false);
            row.add(hbox);
            row.setHeight(10.0);
            row.setWidth(10.0);
            for (int y2 = 0; y2 < 100; ++y2) {
                UIEntity tile = new UIEntity();
                tile.setHeight(10.0);
                tile.setWidth(10.0);
                Point name = new Point(y2, x2);
                SignalBoxNode node = this.container.grid.getNode(name);
                if (node == null) {
                    node = new SignalBoxNode(name);
                }
                UISignalBoxTile sbt = new UISignalBoxTile(node);
                if (!node.isEmpty()) {
                    this.allTiles.put(name, sbt);
                }
                tile.add(sbt);
                sbt.setGreenSignals(this.container.greenSignals.getOrDefault(name, new ArrayList()));
                if (!node.getCustomText().isEmpty()) {
                    UIEntity inputEntity = new UIEntity();
                    inputEntity.add(new UIScale(0.7f, 0.7f, 0.7f));
                    UILabel label = new UILabel(node.getCustomText());
                    label.setTextColor(-1);
                    inputEntity.add(label);
                    inputEntity.setX(5.0);
                    tile.add(inputEntity);
                }
                consumer.accept(tile, sbt);
                row.add(tile);
                sbt.updateTrainNumber();
            }
            plane.add(row);
        }
        this.splitter.add(new UIColor(BACKGROUND_COLOR));
        this.splitter.add(new UIScissor());
        this.splitter.add(new UIBorder(-16777216, 4.0f));
        this.splitter.add(plane);
        this.splitter.setInherits(true);
        this.lowerEntity.add(new UIBox(UIBox.HBOX, 2));
        this.lowerEntity.add(this.splitter);
        this.helpPage = new SidePanel(this.lowerEntity, this);
        this.helpPage.setDisableSubdsidiary(this::disableSubsidiary);
        this.buildColors(this.container.grid.getNodes());
    }

    public void updateCounter() {
        this.helpPage.updateCounterButton();
    }

    private void initializeBasicUI() {
        String name = I18Wrapper.format("tile.signalbox.name", new Object[0]);
        UILabel titlelabel = new UILabel(name);
        titlelabel.setCenterX(false);
        UIEntity titel = new UIEntity();
        titel.add(new UIScale(1.2f, 1.2f, 1.0f));
        titel.add(titlelabel);
        titel.setInheritHeight(true);
        titel.setInheritWidth(true);
        UIEntity header = new UIEntity();
        header.setInheritWidth(true);
        header.setHeight(20.0);
        header.add(new UIBox(UIBox.HBOX, 4));
        header.add(titel);
        header.add(GuiElements.createSpacerH(20));
        header.add(GuiElements.createButton(I18Wrapper.format("btn.settings", new Object[0]), this::initializePageSettings));
        header.add(GuiElements.createButton(I18Wrapper.format("btn.edit", new Object[0]), this::initializeFieldEdit));
        this.mainButton = GuiElements.createButton(I18Wrapper.format("btn.main", new Object[0]), this::initializeFieldUsage);
        header.add(this.mainButton);
        this.resetSelection(this.mainButton);
        UIEntity middlePart = new UIEntity();
        middlePart.setInheritHeight(true);
        middlePart.setInheritWidth(true);
        middlePart.add(new UIBox(UIBox.VBOX, 4));
        middlePart.add(header);
        middlePart.add(this.lowerEntity);
        this.lowerEntity.setInheritHeight(true);
        this.lowerEntity.setInheritWidth(true);
        this.initializeFieldTemplate(this::tileNormal, false);
        this.entity.add(GuiElements.createSpacerH(10));
        this.entity.add(middlePart);
        this.entity.add(GuiElements.createSpacerH(10));
        this.entity.add(new UIBox(UIBox.HBOX, 1));
        this.helpPage.helpUsageMode(this.enabledSubsidiaries, null, this.container.grid.getNodes(), this.container.possibleSubsidiaries);
    }

    private void sendPWRequest(SignalBoxNode currentNode) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.REQUEST_PW);
        this.lastTile.getPoint().writeNetwork(buffer);
        currentNode.getPoint().writeNetwork(buffer);
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    protected void resetPathwayOnServer(SignalBoxNode node) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.RESET_PW);
        node.getPoint().writeNetwork(buffer);
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    private void sendPosEntryToServer(BlockPos pos, SignalBoxNode node, EnumGuiMode mode, Rotation rotation, PathEntryType<BlockPos> entry) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.SEND_POS_ENTRY);
        buffer.putBlockPos(pos);
        node.getPoint().writeNetwork(buffer);
        buffer.putByte((byte)mode.ordinal());
        buffer.putByte((byte)rotation.ordinal());
        buffer.putByte((byte)entry.getID());
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    private void sendIntEntryToServer(int speed, SignalBoxNode node, EnumGuiMode mode, Rotation rotation, PathEntryType<Integer> entry) {
        if (speed == 127 || !this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.SEND_INT_ENTRY);
        buffer.putByte((byte)speed);
        node.getPoint().writeNetwork(buffer);
        buffer.putByte((byte)mode.ordinal());
        buffer.putByte((byte)rotation.ordinal());
        buffer.putByte((byte)entry.getID());
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    private void sendZS2Entry(byte value, SignalBoxNode node, EnumGuiMode mode, Rotation rotation, PathEntryType<Byte> entry) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.SEND_ZS2_ENTRY);
        buffer.putByte(value);
        node.getPoint().writeNetwork(buffer);
        buffer.putByte((byte)mode.ordinal());
        buffer.putByte((byte)rotation.ordinal());
        buffer.putByte((byte)entry.getID());
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    private void sendPointEntry(Point point, SignalBoxNode node, EnumGuiMode mode, Rotation rotation, PathEntryType<Point> entry) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.SEND_POINT_ENTRY);
        point.writeNetwork(buffer);
        node.getPoint().writeNetwork(buffer);
        buffer.putByte((byte)mode.ordinal());
        buffer.putByte((byte)rotation.ordinal());
        buffer.putByte((byte)entry.getID());
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    private void removeEntryFromServer(SignalBoxNode node, EnumGuiMode mode, Rotation rotation, PathEntryType<?> entry) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.REMOVE_ENTRY);
        node.getPoint().writeNetwork(buffer);
        buffer.putByte((byte)mode.ordinal());
        buffer.putByte((byte)rotation.ordinal());
        buffer.putByte((byte)entry.getID());
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    private void resetAllPathways() {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.RESET_ALL_PW);
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
        this.resetColors(this.container.grid.getNodes());
    }

    private void sendModeChanges() {
        if (this.changedModes.isEmpty() || !this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.SEND_CHANGED_MODES);
        buffer.putInt(this.changedModes.size());
        this.changedModes.forEach((point, node) -> {
            point.writeNetwork(buffer);
            node.writeNetwork(buffer);
        });
        this.container.grid.putAllNodes(this.changedModes);
        this.changedModes.clear();
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    private void removeBlockPos(BlockPos pos) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.REMOVE_POS);
        buffer.putBlockPos(pos);
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    protected void sendSubsidiaryRequest(SubsidiaryEntry entry, Point point, ModeSet mode) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.REQUEST_SUBSIDIARY);
        entry.writeNetwork(buffer);
        point.writeNetwork(buffer);
        mode.writeNetwork(buffer);
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    protected void changeRedstoneOutput(Point point, ModeSet mode, boolean state) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.UPDATE_RS_OUTPUT);
        point.writeNetwork(buffer);
        mode.writeNetwork(buffer);
        buffer.putBoolean(state);
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
        UISignalBoxTile tile = this.allTiles.get(point);
        tile.setColor(mode, state ? 0xFFFF00 : SignalBoxUtil.FREE_COLOR);
    }

    protected void setAutoPoint(Point point, byte state) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.SET_AUTO_POINT);
        point.writeNetwork(buffer);
        buffer.putByte(state);
        OpenSignalsMain.network.sendTo(this.info.player, buffer.build());
    }

    private void sendName(Point point, String name) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.SEND_NAME);
        point.writeNetwork(buffer);
        buffer.putString(name);
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    private void sendSignalRepeater(Point point, ModeSet mode, boolean state) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.SEND_SIGNAL_REPEATER);
        point.writeNetwork(buffer);
        mode.writeNetwork(buffer);
        buffer.putBoolean(state);
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    protected void removeNextPathwayFromServer(Point start, Point end) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.REMOVE_SAVEDPW);
        start.writeNetwork(buffer);
        end.writeNetwork(buffer);
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    protected void sendCurrentCounterToServer() {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.SEND_COUNTER);
        buffer.putInt(this.container.grid.getCurrentCounter());
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    private void sendTrainNumber(Point point, String number) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.SEND_TRAIN_NUMBER);
        point.writeNetwork(buffer);
        buffer.putString(number);
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    private void deleteTrainNumber(Point point) {
        if (!this.allPacketsRecived) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalBoxNetwork.SEND_TRAIN_NUMBER);
        point.writeNetwork(buffer);
        buffer.putString(TrainNumber.DEFAULT.trainNumber);
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    private void reset() {
        this.lowerEntity.clear();
    }

    @Override
    public void updateFromContainer() {
        if (!this.allPacketsRecived) {
            this.updateEnabledSubsidiaries();
            this.initializeBasicUI();
            this.allPacketsRecived = true;
        }
    }

    private void updateEnabledSubsidiaries() {
        this.container.enabledSubsidiaryTypes.forEach((point, map) -> map.forEach((modeSet, state) -> {
            if (!state.state) {
                return;
            }
            SignalBoxNode node = this.container.grid.getNode((Point)point);
            if (node == null) {
                return;
            }
            node.getOption((ModeSet)modeSet).get().getEntry(PathEntryType.SIGNAL).ifPresent(pos -> this.enabledSubsidiaries.put((BlockPos)pos, new SubsidiaryHolder((SubsidiaryEntry)state, (Point)point, (ModeSet)modeSet)));
        }));
    }

    private void buildColors(List<SignalBoxNode> nodes) {
        nodes.forEach(node -> {
            UISignalBoxTile tile = this.allTiles.get(node.getPoint());
            node.forEach(mode -> {
                if (node.containsManuellOutput((ModeSet)mode)) {
                    tile.setColor((ModeSet)mode, 0xFFFF00);
                    return;
                }
                int color = node.getOption((ModeSet)mode).get().getEntry(PathEntryType.PATHUSAGE).orElseGet(() -> EnumPathUsage.FREE).getColor();
                tile.setColor((ModeSet)mode, color);
            });
        });
    }

    private void resetColors(List<SignalBoxNode> nodes) {
        nodes.forEach(node -> {
            UISignalBoxTile tile = this.allTiles.get(node.getPoint());
            node.forEach(mode -> {
                tile.setColor((ModeSet)mode, SignalBoxUtil.FREE_COLOR);
                PathOptionEntry entry = node.getOption((ModeSet)mode).get();
                entry.getEntry(PathEntryType.PATHUSAGE).ifPresent(_u -> entry.setEntry(PathEntryType.PATHUSAGE, EnumPathUsage.FREE));
            });
        });
    }

    private void applyColorChanges(List<SignalBoxNode> listOfNodes) {
        for (int i = listOfNodes.size() - 2; i > 0; --i) {
            Point oldPos = listOfNodes.get(i - 1).getPoint();
            Point newPos = listOfNodes.get(i + 1).getPoint();
            Path path = new Path(oldPos, newPos);
            SignalBoxNode current = listOfNodes.get(i);
            UISignalBoxTile uiTile = this.allTiles.get(current.getPoint());
            ModeSet modeSet = current.getMode(path);
            current.getOption(modeSet).ifPresent(poe -> uiTile.setColor(modeSet, poe.getEntry(PathEntryType.PATHUSAGE).orElseGet(() -> EnumPathUsage.FREE).getColor()));
        }
    }

    @Override
    public ContainerBase getNewGuiContainer(GuiInfo info) {
        return new ContainerSignalBox(info);
    }
}

