/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.contentpacks;

import com.google.gson.Gson;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.contentpacks.ContentPackException;
import com.troblecodings.signals.contentpacks.SEPropertyParser;
import com.troblecodings.signals.core.SignalPropertiesBuilder;
import com.troblecodings.signals.parser.FunctionParsingInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SignalSystemParser {
    private SignalPropertiesBuilder systemProperties;
    private List<SEPropertyParser> seProperties;
    private static final Gson GSON = new Gson();

    public static Map<String, SignalSystemParser> getAllSignals() {
        List<Map.Entry<String, String>> systems = OpenSignalsMain.contentPacks.getFiles("signalsystems");
        HashMap<String, SignalSystemParser> properties = new HashMap<String, SignalSystemParser>();
        systems.forEach(entry -> properties.put((String)entry.getKey(), (SignalSystemParser)GSON.fromJson((String)entry.getValue(), SignalSystemParser.class)));
        return properties;
    }

    public Signal createSignalSystem(String fileName) {
        String name = fileName.replace(".json", "").replace("_", "").toLowerCase().trim();
        ArrayList<SEProperty> properties = new ArrayList<SEProperty>();
        FunctionParsingInfo info = new FunctionParsingInfo(name, properties);
        try {
            this.seProperties.forEach(prop -> {
                properties.add(prop.createSEProperty(info));
                if (properties.size() > 254) {
                    OpenSignalsMain.getLogger().info("Congratulations, you are probably one of the first people on earth to try to register more than 254 SEProperties. We don't want to ruin your work, but 254 is the maximum number of SEProperties!");
                    throw new ContentPackException("You added to many properties to your signalsystem. Max. is 254!");
                }
            });
        }
        catch (Exception e) {
            throw new ContentPackException(String.format("Error in file %s caused by parsing!", fileName), e);
        }
        Signal.nextConsumer = list -> list.addAll(properties);
        return new Signal(this.systemProperties.build(info));
    }
}

