/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals;

import com.google.common.collect.ImmutableList;
import com.troblecodings.core.I18Wrapper;
import com.troblecodings.core.NBTWrapper;
import com.troblecodings.guilib.ecs.interfaces.IIntegerable;
import com.troblecodings.signals.core.JsonEnum;
import com.troblecodings.signals.enums.ChangeableStage;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SEProperty
implements IIntegerable<String>,
IUnlistedProperty<String> {
    private final String name;
    private final JsonEnum parent;
    private final String defaultValue;
    private final ChangeableStage stage;
    private final Predicate<Map<SEProperty, String>> deps;
    private final List<String> allowedValues;
    private final int itemDamage;

    public SEProperty(String name, JsonEnum parent, String defaultValue, ChangeableStage stage, Predicate<Map<SEProperty, String>> deps, int itemDamage) {
        this.name = name;
        this.parent = parent;
        this.defaultValue = defaultValue;
        this.stage = stage;
        this.deps = deps;
        this.allowedValues = ImmutableList.copyOf(parent.getAllowedValues());
        this.itemDamage = itemDamage;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getItemDamage() {
        return this.itemDamage;
    }

    public boolean isValid(String value) {
        return this.allowedValues.contains(value);
    }

    public String valueToString(String value) {
        return this.parent.getName(value);
    }

    public Optional<String> readFromNBT(NBTWrapper comp) {
        if (comp.contains(this.getName())) {
            int id = comp.getInteger(this.getName());
            return Optional.of(this.getObjFromID(id));
        }
        return Optional.empty();
    }

    public NBTWrapper writeToNBT(NBTWrapper comp, String value) {
        if (value != null && this.isValid(value)) {
            comp.putInteger(this.getName(), this.parent.getIDFromValue(value));
        }
        return comp;
    }

    public boolean isValid(int id) {
        return id > -1 && id < this.count();
    }

    @Override
    public String getObjFromID(int pObjID) {
        if (pObjID < 0 || pObjID >= this.allowedValues.size()) {
            return "";
        }
        return this.allowedValues.get(pObjID);
    }

    @Override
    public int count() {
        return this.allowedValues.size();
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public boolean isChangabelAtStage(ChangeableStage stage) {
        return this.stage.equals((Object)stage);
    }

    public String toString() {
        return "SEP[" + this.getName() + "]";
    }

    public boolean testMap(Map<SEProperty, String> t) {
        return this.deps.test(t);
    }

    public JsonEnum getParent() {
        return this.parent;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowedValues, this.defaultValue, this.deps, this.name, this.parent, this.stage});
    }

    public Class<String> getType() {
        return String.class;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SEProperty other = (SEProperty)obj;
        return Objects.equals(this.allowedValues, other.allowedValues) && Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals(this.deps, other.deps) && Objects.equals(this.name, other.name) && Objects.equals(this.parent, other.parent) && this.stage == other.stage;
    }

    public static class SEAutoNameProp
    extends SEProperty {
        public SEAutoNameProp(String name, JsonEnum parent, String defaultValue, ChangeableStage stage, Predicate<Map<SEProperty, String>> deps, int itemDamage) {
            super(name, parent, defaultValue, stage, deps, itemDamage);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String getNamedObj(int obj) {
            return I18Wrapper.format("property." + this.getName() + ".name", new Object[0]) + ": " + (String)this.getObjFromID(obj);
        }
    }
}

