/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.item;

import crafttweaker.api.data.DataList;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.IData;
import crafttweaker.api.enchantments.IEnchantment;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IItemUtils;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.potions.IPotion;
import crafttweaker.api.potions.IPotionEffect;
import crafttweaker.mc1120.brackets.BracketHandlerItem;
import crafttweaker.mc1120.commands.Commands;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.item.MCItemStack;
import it.unimi.dsi.fastutil.shorts.Short2ShortOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import stanhebben.zenscript.annotations.Optional;

public class MCItemUtils
implements IItemUtils {
    private static ArrayList<ItemStack> ITEMLIST;

    public static void createItemList() {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        ArrayList<Item> items = new ArrayList<Item>(BracketHandlerItem.getItemNames().values());
        items.sort(Commands.ITEM_COMPARATOR);
        for (Item item : items) {
            if (item == null) continue;
            NonNullList list = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, list);
            if (!list.isEmpty()) {
                itemList.addAll((Collection<ItemStack>)list);
                continue;
            }
            ItemStack stack = new ItemStack(item, 1, 0);
            itemList.add(stack);
        }
        ITEMLIST = itemList;
    }

    @Override
    public IItemStack createPotion(Object[] ... params) {
        ItemStack item = new ItemStack((Item)Items.field_151068_bn, 1, 0);
        ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
        for (Object[] param : params) {
            if (param.length != 3 || !(param[0] instanceof IPotion)) continue;
            IPotion iPotion = (IPotion)param[0];
            if (!(param[1] instanceof Integer)) continue;
            int amplifier = (Integer)param[1];
            if (!(param[2] instanceof Integer)) continue;
            int duration = (Integer)param[2];
            PotionEffect effect = new PotionEffect((Potion)iPotion.getInternal(), duration, amplifier);
            potionEffects.add(effect);
        }
        PotionUtils.func_185184_a((ItemStack)item, potionEffects);
        return new MCItemStack(item);
    }

    @Override
    public IItemStack createPotion(IPotionEffect ... params) {
        ItemStack item = new ItemStack((Item)Items.field_151068_bn, 1, 0);
        List potionEffects = Stream.of(params).map(k -> (PotionEffect)k.getInternal()).collect(Collectors.toList());
        PotionUtils.func_185184_a((ItemStack)item, potionEffects);
        return new MCItemStack(item);
    }

    @Override
    public IItemStack enchantItem(IItemStack item, IEnchantment ... enchantments) {
        String baseKey;
        ItemStack base = (ItemStack)item.getInternal();
        NBTTagCompound tag = base.func_77978_p();
        Short2ShortOpenHashMap enchantmentMap = new Short2ShortOpenHashMap();
        if (base.func_77973_b() == Items.field_151134_bR || base.func_77973_b() == Items.field_151122_aG) {
            if (base.func_77973_b() == Items.field_151122_aG) {
                base = new ItemStack(Items.field_151134_bR);
                base.func_77982_d(tag);
            }
            baseKey = "StoredEnchantments";
        } else {
            baseKey = "ench";
        }
        if (tag != null && tag.func_74764_b(baseKey)) {
            NBTTagList list = tag.func_150295_c(baseKey, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound ench = list.func_150305_b(i);
                enchantmentMap.put(ench.func_74765_d("id"), ench.func_74765_d("lvl"));
            }
        } else if (tag == null) {
            tag = new NBTTagCompound();
            base.func_77982_d(tag);
        }
        for (NBTTagList ench : enchantments) {
            NBTTagCompound eTag = (NBTTagCompound)ench.makeNBTInternal();
            enchantmentMap.put(eTag.func_74765_d("id"), eTag.func_74765_d("lvl"));
        }
        NBTTagList result = new NBTTagList();
        for (Map.Entry i : enchantmentMap.entrySet()) {
            NBTTagCompound eTag = new NBTTagCompound();
            eTag.func_74777_a("id", ((Short)i.getKey()).shortValue());
            eTag.func_74777_a("lvl", ((Short)i.getValue()).shortValue());
            result.func_74742_a((NBTBase)eTag);
        }
        tag.func_74782_a(baseKey, (NBTBase)result);
        return new MCItemStack(base);
    }

    @Override
    public IItemStack createEnchantedBook(IEnchantment ... enchantments) {
        NBTTagList enchants = new NBTTagList();
        for (IEnchantment ench : enchantments) {
            enchants.func_74742_a((NBTBase)((NBTTagCompound)ench.makeNBTInternal()));
        }
        ItemStack book = new ItemStack(Items.field_151134_bR);
        NBTTagCompound result = new NBTTagCompound();
        result.func_74782_a("StoredEnchantments", (NBTBase)enchants);
        book.func_77982_d(result);
        return new MCItemStack(book);
    }

    @Override
    public IData combineEnchantments(String baseKey, IEnchantment ... enchantments) {
        ArrayList<IData> enchantmentsList = new ArrayList<IData>();
        for (IEnchantment enchDef : enchantments) {
            enchantmentsList.add(new DataMap(enchDef.makeTagInternal(), false));
        }
        return new DataMap(Collections.singletonMap(baseKey, new DataList(enchantmentsList, false)), false);
    }

    @Override
    public IData combineEnchantments(IEnchantment ... enchantments) {
        return this.combineEnchantments("ench", enchantments);
    }

    @Override
    public IItemStack[] getItemsByRegexRegistryName(String regex) {
        HashSet alreadyChecked = new HashSet();
        Predicate<String> predicate = Pattern.compile(regex).asPredicate();
        return (IItemStack[])ITEMLIST.stream().filter(stack -> {
            String currentRegName = Objects.toString(stack.func_77973_b().getRegistryName(), null);
            return currentRegName != null && alreadyChecked.add(currentRegName) && predicate.test(currentRegName);
        }).map(stack -> stack.func_77942_o() ? new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j()) : stack).map(CraftTweakerMC::getIItemStack).filter(Objects::nonNull).toArray(IItemStack[]::new);
    }

    @Override
    public IItemStack getItem(String location, @Optional int meta) {
        return BracketHandlerItem.getItem(location, meta);
    }

    @Override
    public IItemStack[] getItemsByRegexUnlocalizedName(String regex) {
        Predicate<String> predicate = Pattern.compile(regex).asPredicate();
        return (IItemStack[])ITEMLIST.stream().filter(stack -> predicate.test(stack.func_77977_a())).map(CraftTweakerMC::getIItemStack).filter(Objects::nonNull).toArray(IItemStack[]::new);
    }

    @Override
    public IItemStack createSpawnEgg(IEntityDefinition entity, @Optional IData customNBT) {
        ItemStack item = new ItemStack(Items.field_151063_bx, 1, 0);
        NBTTagCompound baseTag = customNBT != null ? (NBTTagCompound)NBTConverter.from(customNBT) : new NBTTagCompound();
        NBTTagCompound entityTag = baseTag.func_74764_b("EntityTag") ? baseTag.func_74775_l("EntityTag") : new NBTTagCompound();
        entityTag.func_74778_a("id", entity.getId());
        baseTag.func_74782_a("EntityTag", (NBTBase)entityTag);
        item.func_77982_d(baseTag);
        return new MCItemStack(item);
    }
}

