/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.wind;

import CoroUtil.util.CoroUtilEntOrParticle;
import CoroUtil.util.Vec3;
import java.util.Random;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weather2.Weather;
import weather2.config.ConfigMisc;
import weather2.config.ConfigWind;
import weather2.util.WeatherUtilEntity;
import weather2.weathersystem.WeatherManagerBase;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;

public class WindManager {
    public WeatherManagerBase manager;
    public float windAngleGlobal = 0.0f;
    public float windSpeedGlobal = 0.0f;
    public float windSpeedGlobalChangeRate = 0.05f;
    public int windSpeedGlobalRandChangeTimer = 0;
    public int windSpeedGlobalRandChangeDelay = 10;
    public float windAngleEvent = 0.0f;
    public BlockPos windOriginEvent = BlockPos.field_177992_a;
    public float windSpeedEvent = 0.0f;
    public int windTimeEvent = 0;
    public float windAngleGust = 0.0f;
    public float windSpeedGust = 0.0f;
    public int windTimeGust = 0;
    public int windGustEventTimeRand = 60;
    public float chanceOfWindGustEvent = 0.5f;
    public int lowWindTimer = 0;
    public int highWindTimer = 0;

    public WindManager(WeatherManagerBase parManager) {
        this.manager = parManager;
        Random rand = new Random();
        this.windAngleGlobal = rand.nextInt(360);
    }

    public float getWindSpeedForPriority() {
        if (this.windTimeEvent > 0) {
            return this.getWindSpeedForEvents();
        }
        if (this.windTimeGust > 0) {
            return this.getWindSpeedForGusts();
        }
        return this.getWindSpeedForClouds();
    }

    public float getWindSpeedForEvents() {
        if (this.windTimeEvent > 0) {
            return this.windSpeedEvent;
        }
        return 0.0f;
    }

    public float getWindSpeedForGusts() {
        return this.windSpeedGust;
    }

    public float getWindSpeedForClouds() {
        return this.windSpeedGlobal;
    }

    public float getWindAngleForPriority(Vec3 pos) {
        if (this.windTimeEvent > 0) {
            return this.getWindAngleForEvents(pos);
        }
        if (this.windTimeGust > 0) {
            return this.getWindAngleForGusts();
        }
        return this.getWindAngleForClouds();
    }

    public float getWindAngleForEvents() {
        return this.windAngleEvent;
    }

    public float getWindAngleForEvents(Vec3 pos) {
        if (pos != null && !this.windOriginEvent.equals((Object)BlockPos.field_177992_a)) {
            double var11 = (double)this.windOriginEvent.func_177958_n() + 0.5 - pos.xCoord;
            double var15 = (double)this.windOriginEvent.func_177952_p() + 0.5 - pos.zCoord;
            return -((float)Math.atan2(var11, var15)) * 180.0f / (float)Math.PI - 45.0f;
        }
        return this.windAngleEvent;
    }

    public float getWindAngleForGusts() {
        return this.windAngleGust;
    }

    public float getWindAngleForClouds() {
        return this.windAngleGlobal;
    }

    public void setWindTimeGust(int parVal) {
        this.windTimeGust = parVal;
        this.syncData();
    }

    public void setWindTimeEvent(int parVal) {
        this.windTimeEvent = parVal;
    }

    public void tick() {
        Random rand = new Random();
        if (!ConfigWind.Misc_windOn) {
            this.windSpeedGlobal = 0.0f;
            this.windSpeedGust = 0.0f;
            this.windTimeGust = 0;
        } else if (!this.manager.getWorld().field_72995_K) {
            if (!ConfigWind.Wind_LowWindEvents) {
                this.lowWindTimer = 0;
            }
            if (this.lowWindTimer <= 0) {
                if (this.windSpeedGlobalRandChangeTimer-- <= 0) {
                    this.windSpeedGlobal = this.highWindTimer <= 0 ? (float)((double)this.windSpeedGlobal + (rand.nextDouble() * (double)this.windSpeedGlobalChangeRate - (double)(this.windSpeedGlobalChangeRate / 2.0f))) : (float)((double)this.windSpeedGlobal + rand.nextDouble() * (double)this.windSpeedGlobalChangeRate);
                    this.windSpeedGlobalRandChangeTimer = this.windSpeedGlobalRandChangeDelay;
                }
                if (this.highWindTimer <= 0) {
                    if (ConfigWind.Wind_LowWindEvents && rand.nextInt(ConfigWind.lowWindOddsTo1) == 0) {
                        this.startLowWindEvent();
                        Weather.dbg("low wind event started, for ticks: " + this.lowWindTimer);
                    }
                } else {
                    this.stopLowWindEvent();
                }
                if (ConfigWind.Wind_HighWindEvents && this.highWindTimer <= 0 && rand.nextInt(ConfigWind.highWindOddsTo1) == 0) {
                    this.startHighWindEvent();
                    Weather.dbg("high wind event started, for ticks: " + this.highWindTimer);
                }
            } else {
                --this.lowWindTimer;
                if (this.lowWindTimer <= 0) {
                    Weather.dbg("low wind event ended");
                }
                this.windSpeedGlobal -= 0.01f;
            }
            if (this.highWindTimer > 0) {
                --this.highWindTimer;
                if (this.highWindTimer <= 0) {
                    Weather.dbg("high wind event ended");
                }
            }
            if ((double)this.windSpeedGlobal < ConfigWind.windSpeedMin) {
                this.windSpeedGlobal = (float)ConfigWind.windSpeedMin;
            }
            if ((double)this.windSpeedGlobal > ConfigWind.windSpeedMax) {
                this.windSpeedGlobal = (float)ConfigWind.windSpeedMax;
            }
            if (this.windTimeGust > 0) {
                --this.windTimeGust;
                if (this.windTimeGust == 0) {
                    this.syncData();
                }
            }
            if (ConfigMisc.overcastMode && this.manager.getWorld().func_72896_J() && (double)this.windSpeedGlobal < ConfigWind.windSpeedMinGlobalOvercastRaining) {
                this.windSpeedGlobal = (float)ConfigWind.windSpeedMinGlobalOvercastRaining;
            }
            float randGustWindFactor = 1.0f;
            if (this.windTimeGust == 0 && this.lowWindTimer <= 0 && this.chanceOfWindGustEvent > 0.0f && rand.nextInt((int)((100.0f - this.chanceOfWindGustEvent) * randGustWindFactor)) == 0) {
                this.windSpeedGust = this.windSpeedGlobal + rand.nextFloat() * 0.6f;
                boolean randomDirectionGust = false;
                this.windAngleGust = randomDirectionGust ? (float)(rand.nextInt(360) - 180) : this.windAngleGlobal + (float)rand.nextInt(120) - 60.0f;
                this.setWindTimeGust(rand.nextInt(this.windGustEventTimeRand));
            }
            this.windAngleGlobal = (float)((double)this.windAngleGlobal + ((double)rand.nextFloat() * ConfigWind.globalWindChangeAmountRate - (double)rand.nextFloat() * ConfigWind.globalWindChangeAmountRate));
            if (this.windAngleGlobal < -180.0f) {
                this.windAngleGlobal += 360.0f;
            }
            if (this.windAngleGlobal > 180.0f) {
                this.windAngleGlobal -= 360.0f;
            }
        } else {
            this.tickClient();
        }
    }

    public void startHighWindEvent() {
        this.highWindTimer = ConfigWind.highWindTimerEnableAmountBase + new Random().nextInt(ConfigWind.highWindTimerEnableAmountRnd);
    }

    public boolean isHighWindEventActive() {
        return this.highWindTimer > 0;
    }

    public void stopHighWindEvent() {
        this.highWindTimer = 0;
    }

    public void startLowWindEvent() {
        this.lowWindTimer = ConfigWind.lowWindTimerEnableAmountBase + new Random().nextInt(ConfigWind.lowWindTimerEnableAmountRnd);
    }

    public void stopLowWindEvent() {
        this.lowWindTimer = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void tickClient() {
        StormObject so;
        EntityPlayerSP entP = FMLClientHandler.instance().getClient().field_71439_g;
        if (this.windTimeEvent > 0) {
            --this.windTimeEvent;
        }
        if (entP != null && this.manager.getWorld().func_82737_E() % 10L == 0L && (so = this.manager.getClosestStorm(new Vec3(entP.field_70165_t, (double)StormObject.layers.get(0).intValue(), entP.field_70161_v), 256.0, StormObject.STATE_HIGHWIND)) != null) {
            float yaw;
            this.windOriginEvent = new BlockPos(so.posGround.xCoord, so.posGround.yCoord, so.posGround.zCoord);
            this.setWindTimeEvent(80);
            double stormDist = entP.func_70011_f(so.posGround.xCoord, so.posGround.yCoord, so.posGround.zCoord);
            double var11 = so.posGround.xCoord - entP.field_70165_t;
            double var15 = so.posGround.zCoord - entP.field_70161_v;
            this.windAngleEvent = yaw = -((float)Math.atan2(var11, var15)) * 180.0f / (float)Math.PI;
            this.windSpeedEvent = 2.0f;
        }
    }

    public NBTTagCompound nbtSyncForClient() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74776_a("windSpeedGlobal", this.windSpeedGlobal);
        data.func_74776_a("windAngleGlobal", this.windAngleGlobal);
        data.func_74776_a("windSpeedGust", this.windSpeedGust);
        data.func_74776_a("windAngleGust", this.windAngleGust);
        data.func_74768_a("windTimeGust", this.windTimeGust);
        return data;
    }

    public void nbtSyncFromServer(NBTTagCompound parNBT) {
        this.windSpeedGlobal = parNBT.func_74760_g("windSpeedGlobal");
        this.windAngleGlobal = parNBT.func_74760_g("windAngleGlobal");
        this.windSpeedGust = parNBT.func_74760_g("windSpeedGust");
        this.windAngleGust = parNBT.func_74760_g("windAngleGust");
        this.windTimeGust = parNBT.func_74762_e("windTimeGust");
    }

    public void syncData() {
        if (this.manager instanceof WeatherManagerServer) {
            ((WeatherManagerServer)this.manager).syncWindUpdate(this);
        }
    }

    public void reset() {
        this.manager = null;
    }

    public void applyWindForceNew(Object ent) {
        this.applyWindForceNew(ent, 0.05f, 0.5f);
    }

    public void applyWindForceNew(Object ent, float multiplier, float maxSpeed) {
        Vec3 pos = new Vec3(CoroUtilEntOrParticle.getPosX((Object)ent), CoroUtilEntOrParticle.getPosY((Object)ent), CoroUtilEntOrParticle.getPosZ((Object)ent));
        Vec3 motion = this.applyWindForceImpl(pos, new Vec3(CoroUtilEntOrParticle.getMotionX((Object)ent), CoroUtilEntOrParticle.getMotionY((Object)ent), CoroUtilEntOrParticle.getMotionZ((Object)ent)), WeatherUtilEntity.getWeight(ent), multiplier, maxSpeed);
        CoroUtilEntOrParticle.setMotionX((Object)ent, (double)motion.xCoord);
        CoroUtilEntOrParticle.setMotionZ((Object)ent, (double)motion.zCoord);
    }

    public Vec3 applyWindForceImpl(Vec3 pos, Vec3 motion, float weight) {
        return this.applyWindForceImpl(pos, motion, weight, 0.05f, 0.5f);
    }

    public Vec3 applyWindForceImpl(Vec3 pos, Vec3 motion, float weight, float multiplier, float maxSpeed) {
        boolean debugParticle = false;
        WindManager windMan = this;
        float windSpeed = windMan.getWindSpeedForPriority();
        float windAngle = windMan.getWindAngleForPriority(pos);
        float windX = (float)(-Math.sin(Math.toRadians(windAngle))) * windSpeed;
        float windZ = (float)Math.cos(Math.toRadians(windAngle)) * windSpeed;
        float objX = (float)motion.xCoord;
        float objZ = (float)motion.zCoord;
        float windWeight = 1.0f;
        float objWeight = weight;
        if (objWeight <= 0.0f) {
            objWeight = 0.001f;
        }
        float weightDiff = windWeight / objWeight;
        float vecX = (objX - windX) * weightDiff;
        float vecZ = (objZ - windZ) * weightDiff;
        vecX *= multiplier;
        vecZ *= multiplier;
        if (debugParticle) {
            System.out.println(windX + " vs " + objX);
            System.out.println("diff: " + String.format("%.5g%n", Float.valueOf(vecX)));
        }
        Vec3 newMotion = new Vec3(motion);
        double speedCheck = (double)(Math.abs(vecX) + Math.abs(vecZ)) / 2.0;
        if (speedCheck < (double)maxSpeed) {
            newMotion.xCoord = objX - vecX;
            newMotion.zCoord = objZ - vecZ;
        }
        return newMotion;
    }

    public Vec3 getWindForce() {
        float windSpeed = this.getWindSpeedForPriority();
        float windAngle = this.getWindAngleForPriority(null);
        float windX = (float)(-Math.sin(Math.toRadians(windAngle))) * windSpeed;
        float windZ = (float)Math.cos(Math.toRadians(windAngle)) * windSpeed;
        return new Vec3((double)windX, 0.0, (double)windZ);
    }

    public void readFromNBT(NBTTagCompound data) {
        this.windSpeedGlobal = data.func_74760_g("windSpeedGlobal");
        this.windAngleGlobal = data.func_74760_g("windAngleGlobal");
        this.windSpeedGust = data.func_74760_g("windSpeedGust");
        this.windAngleGust = data.func_74760_g("windAngleGust");
        this.windTimeGust = data.func_74762_e("windTimeGust");
        this.windSpeedEvent = data.func_74760_g("windSpeedEvent");
        this.windAngleEvent = data.func_74760_g("windAngleEvent");
        this.windTimeEvent = data.func_74762_e("windTimeEvent");
        this.lowWindTimer = data.func_74762_e("lowWindTimer");
        this.highWindTimer = data.func_74762_e("highWindTimer");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74776_a("windSpeedGlobal", this.windSpeedGlobal);
        data.func_74776_a("windAngleGlobal", this.windAngleGlobal);
        data.func_74776_a("windSpeedGust", this.windSpeedGust);
        data.func_74776_a("windAngleGust", this.windAngleGust);
        data.func_74768_a("windTimeGust", this.windTimeGust);
        data.func_74776_a("windSpeedEvent", this.windSpeedEvent);
        data.func_74776_a("windAngleEvent", this.windAngleEvent);
        data.func_74768_a("windTimeEvent", this.windTimeEvent);
        data.func_74768_a("lowWindTimer", this.lowWindTimer);
        data.func_74768_a("highWindTimer", this.highWindTimer);
        return data;
    }
}

