/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import CoroUtil.api.weather.IWindHandler;
import CoroUtil.util.CoroUtilEntOrParticle;
import CoroUtil.util.Vec3;
import extendedrenderer.particle.entity.EntityRotFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import weather2.ClientTickHandler;
import weather2.api.WeatherUtilData;
import weather2.entity.EntityMovingBlock;
import weather2.util.WeatherUtilBlock;
import weather2.util.WeatherUtilParticle;
import weather2.weathersystem.wind.WindManager;

public class WeatherUtilEntity {
    public static int playerInAirTime = 0;

    public static float getWeight(Object entity1) {
        return WeatherUtilEntity.getWeight(entity1, false);
    }

    public static float getWeight(Object entity1, boolean forTornado) {
        Entity ent;
        int airTime;
        float var;
        World world = CoroUtilEntOrParticle.getWorld((Object)entity1);
        if (world == null) {
            return 1.0f;
        }
        if (entity1 instanceof IWindHandler) {
            return ((IWindHandler)entity1).getWindWeight();
        }
        if (entity1 instanceof EntityMovingBlock) {
            return 1.0f + (float)((EntityMovingBlock)((Object)entity1)).age / 200.0f;
        }
        if (entity1 instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity1;
            playerInAirTime = player.field_70122_E || player.func_70072_I() ? 0 : ++playerInAirTime;
            if (((EntityPlayer)entity1).field_71075_bZ.field_75098_d) {
                return 1.0E8f;
            }
            int extraWeight = 0;
            if (((EntityPlayer)entity1).field_71071_by != null && !((ItemStack)((EntityPlayer)entity1).field_71071_by.field_70460_b.get(2)).func_190926_b() && ((ItemStack)((EntityPlayer)entity1).field_71071_by.field_70460_b.get(2)).func_77973_b() == Items.field_151030_Z) {
                extraWeight = 2;
            }
            if (((EntityPlayer)entity1).field_71071_by != null && !((ItemStack)((EntityPlayer)entity1).field_71071_by.field_70460_b.get(2)).func_190926_b() && ((ItemStack)((EntityPlayer)entity1).field_71071_by.field_70460_b.get(2)).func_77973_b() == Items.field_151163_ad) {
                extraWeight = 4;
            }
            if (forTornado) {
                return 4.5f + (float)extraWeight + (float)(playerInAirTime / 400);
            }
            return 5.0f + (float)extraWeight + (float)(playerInAirTime / 400);
        }
        if (WeatherUtilEntity.isParticleRotServerSafe(world, entity1) && (var = WeatherUtilParticle.getParticleWeight((EntityRotFX)entity1)) != -1.0f) {
            return var;
        }
        if (entity1 instanceof EntitySquid) {
            return 400.0f;
        }
        if (entity1 instanceof EntityLivingBase) {
            EntityLivingBase livingEnt = (EntityLivingBase)entity1;
            airTime = livingEnt.getEntityData().func_74762_e("timeInAir");
            airTime = livingEnt.field_70122_E || livingEnt.func_70072_I() ? 0 : ++airTime;
            livingEnt.getEntityData().func_74768_a("timeInAir", airTime);
        }
        if (entity1 instanceof Entity && WeatherUtilData.isWindWeightSet(ent = (Entity)entity1) && (forTornado || WeatherUtilData.isWindAffected(ent))) {
            return WeatherUtilData.getWindWeight(ent);
        }
        if (entity1 instanceof EntityLivingBase) {
            EntityLivingBase livingEnt = (EntityLivingBase)entity1;
            airTime = livingEnt.getEntityData().func_74762_e("timeInAir");
            if (forTornado) {
                return 0.5f + (float)airTime / 800.0f;
            }
            return 500.0f + (livingEnt.field_70122_E ? 2.0f : 0.0f) + (float)(airTime / 400);
        }
        if (entity1 instanceof EntityBoat || entity1 instanceof EntityItem || entity1 instanceof EntityFishHook) {
            return 4000.0f;
        }
        if (entity1 instanceof EntityMinecart) {
            return 80.0f;
        }
        return 1.0f;
    }

    public static boolean isParticleRotServerSafe(World world, Object obj) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return false;
        }
        if (!world.field_72995_K) {
            return false;
        }
        return WeatherUtilEntity.isParticleRotClientCheck(obj);
    }

    public static boolean isParticleRotClientCheck(Object obj) {
        return obj instanceof EntityRotFX;
    }

    public static boolean canPushEntity(Entity ent) {
        WindManager windMan = ClientTickHandler.weatherManager.windMan;
        double speed = 10.0;
        int startX = (int)(ent.field_70165_t - speed * (double)(-MathHelper.func_76126_a((float)(windMan.getWindAngleForPriority(null) / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.0f)));
        int startZ = (int)(ent.field_70161_v - speed * (double)(MathHelper.func_76134_b((float)(windMan.getWindAngleForPriority(null) / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.0f)));
        if (ent instanceof EntityPlayer) {
            boolean bl = true;
        }
        return ent.field_70170_p.func_72933_a(new Vec3(ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v).toMCVec(), new Vec3((double)startX, ent.field_70163_u + (double)ent.func_70047_e(), (double)startZ).toMCVec()) == null;
    }

    public static boolean isEntityOutside(Entity parEnt) {
        return WeatherUtilEntity.isEntityOutside(parEnt, false);
    }

    public static boolean isEntityOutside(Entity parEnt, boolean cheapCheck) {
        return WeatherUtilEntity.isPosOutside(parEnt.field_70170_p, new Vec3(parEnt.field_70165_t, parEnt.field_70163_u, parEnt.field_70161_v), cheapCheck);
    }

    public static boolean isPosOutside(World parWorld, Vec3 parPos) {
        return WeatherUtilEntity.isPosOutside(parWorld, parPos, false);
    }

    public static boolean isPosOutside(World parWorld, Vec3 parPos, boolean cheapCheck) {
        int rangeCheck = 5;
        boolean yOffset = true;
        BlockPos blockPos = new BlockPos(MathHelper.func_76128_c((double)parPos.xCoord), 0, MathHelper.func_76128_c((double)parPos.zCoord));
        if ((double)WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, blockPos).func_177956_o() < parPos.yCoord + 1.0) {
            return true;
        }
        if (cheapCheck) {
            return false;
        }
        Vec3 vecTry = new Vec3(parPos.xCoord + (double)(EnumFacing.NORTH.func_82601_c() * rangeCheck), parPos.yCoord + (double)yOffset, parPos.zCoord + (double)(EnumFacing.NORTH.func_82599_e() * rangeCheck));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPos, vecTry)) {
            return true;
        }
        vecTry = new Vec3(parPos.xCoord + (double)(EnumFacing.SOUTH.func_82601_c() * rangeCheck), parPos.yCoord + (double)yOffset, parPos.zCoord + (double)(EnumFacing.SOUTH.func_82599_e() * rangeCheck));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPos, vecTry)) {
            return true;
        }
        vecTry = new Vec3(parPos.xCoord + (double)(EnumFacing.EAST.func_82601_c() * rangeCheck), parPos.yCoord + (double)yOffset, parPos.zCoord + (double)(EnumFacing.EAST.func_82599_e() * rangeCheck));
        if (WeatherUtilEntity.checkVecOutside(parWorld, parPos, vecTry)) {
            return true;
        }
        vecTry = new Vec3(parPos.xCoord + (double)(EnumFacing.WEST.func_82601_c() * rangeCheck), parPos.yCoord + (double)yOffset, parPos.zCoord + (double)(EnumFacing.WEST.func_82599_e() * rangeCheck));
        return WeatherUtilEntity.checkVecOutside(parWorld, parPos, vecTry);
    }

    public static boolean checkVecOutside(World parWorld, Vec3 parPos, Vec3 parCheckPos) {
        boolean dirNorth;
        boolean bl = dirNorth = parWorld.func_72933_a(parPos.toMCVec(), parCheckPos.toMCVec()) == null;
        if (dirNorth) {
            BlockPos blockPos = new BlockPos(MathHelper.func_76128_c((double)parCheckPos.xCoord), 0, MathHelper.func_76128_c((double)parCheckPos.zCoord));
            if ((double)WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, blockPos).func_177956_o() < parCheckPos.yCoord) {
                return true;
            }
        }
        return false;
    }

    public static EntityPlayer getClosestPlayerAny(World world, double posX, double posY, double posZ, double distance) {
        double d0 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)world.field_73010_i.get(i);
            double d1 = entityplayer1.func_70092_e(posX, posY, posZ);
            if (!(distance < 0.0) && !(d1 < distance * distance) || d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }
}

