/*
 * Decompiled with CFR 0.152.
 */
package weather2.api;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weather2.ClientTickHandler;
import weather2.ServerTickHandler;
import weather2.weathersystem.WeatherManagerBase;

public class WindDataHelper {
    public static float getWindAngle(World parWorld, BlockPos parLocation) {
        return WindDataHelper.getWindAngle(parWorld, parLocation, WindType.PRIORITY);
    }

    public static float getWindAngle(World parWorld, BlockPos parLocation, WindType parWindType) {
        WeatherManagerBase wMan = null;
        wMan = parWorld.field_72995_K ? WindDataHelper.getWeatherManagerClient() : (WeatherManagerBase)ServerTickHandler.lookupDimToWeatherMan.get(parWorld.field_73011_w.getDimension());
        if (wMan != null) {
            if (parWindType == WindType.PRIORITY) {
                return wMan.windMan.getWindAngleForPriority(null);
            }
            if (parWindType == WindType.EVENT) {
                return wMan.windMan.getWindAngleForEvents();
            }
            if (parWindType == WindType.GUST) {
                return wMan.windMan.getWindAngleForGusts();
            }
            if (parWindType == WindType.CLOUD) {
                return wMan.windMan.getWindAngleForClouds();
            }
            return 0.0f;
        }
        return 0.0f;
    }

    public static float getWindSpeed(World parWorld, BlockPos parLocation) {
        return WindDataHelper.getWindSpeed(parWorld, parLocation, WindType.PRIORITY);
    }

    public static float getWindSpeed(World parWorld, BlockPos parLocation, WindType parWindType) {
        WeatherManagerBase wMan = null;
        wMan = parWorld.field_72995_K ? WindDataHelper.getWeatherManagerClient() : (WeatherManagerBase)ServerTickHandler.lookupDimToWeatherMan.get(parWorld.field_73011_w.getDimension());
        if (wMan != null) {
            if (parWindType == WindType.PRIORITY) {
                return wMan.windMan.getWindSpeedForPriority();
            }
            if (parWindType == WindType.EVENT) {
                return wMan.windMan.getWindSpeedForEvents();
            }
            if (parWindType == WindType.GUST) {
                return wMan.windMan.getWindSpeedForGusts();
            }
            if (parWindType == WindType.CLOUD) {
                return wMan.windMan.getWindSpeedForClouds();
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    private static WeatherManagerBase getWeatherManagerClient() {
        return ClientTickHandler.weatherManager;
    }

    public static enum WindType {
        PRIORITY,
        EVENT,
        GUST,
        CLOUD;

    }
}

