/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiatrader.commands;

import bletch.common.commands.CommonCommandBase;
import bletch.common.utils.TektopiaUtils;
import bletch.common.utils.TextUtils;
import bletch.tektopiatrader.entities.EntityTrader;
import bletch.tektopiatrader.utils.LoggerUtils;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.VillageManager;

public class CommandTraderSpawn
extends CommonCommandBase {
    private static final String COMMAND_NAME = "spawn";

    public CommandTraderSpawn() {
        super("tektopiatrader", "commands.trader.", COMMAND_NAME);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BlockPos spawnPosition;
        Village village;
        EntityPlayerMP entityPlayer;
        World world;
        if (args.length > 1) {
            throw new WrongUsageException(this.prefix + COMMAND_NAME + ".usage", new Object[0]);
        }
        boolean spawnNearMe = false;
        if (args.length > 0) {
            if (!args[0].equalsIgnoreCase("me")) {
                throw new WrongUsageException(this.prefix + COMMAND_NAME + ".usage", new Object[0]);
            }
            spawnNearMe = true;
        }
        World world2 = world = (entityPlayer = CommandTraderSpawn.func_71521_c((ICommandSender)sender)) != null ? entityPlayer.func_130014_f_() : null;
        if (world == null || world.func_72896_J() || Village.isNightTime((World)world)) {
            CommandTraderSpawn.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(this.prefix + COMMAND_NAME + ".badconditions"), (Object[])new Object[0]);
            LoggerUtils.instance.info(TextUtils.translate(this.prefix + COMMAND_NAME + ".badconditions", new Object[0]), true);
            return;
        }
        VillageManager villageManager = world != null ? VillageManager.get((World)world) : null;
        Village village2 = village = villageManager != null && entityPlayer != null ? villageManager.getVillageAt(entityPlayer.func_180425_c()) : null;
        if (village == null) {
            CommandTraderSpawn.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(this.prefix + COMMAND_NAME + ".novillage"), (Object[])new Object[0]);
            LoggerUtils.instance.info(TextUtils.translate(this.prefix + COMMAND_NAME + ".novillage", new Object[0]), true);
            return;
        }
        BlockPos blockPos = spawnPosition = spawnNearMe ? entityPlayer.func_180425_c() : TektopiaUtils.getVillageSpawnPoint(world, village);
        if (spawnPosition == null) {
            CommandTraderSpawn.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(this.prefix + COMMAND_NAME + ".noposition"), (Object[])new Object[0]);
            LoggerUtils.instance.info(TextUtils.translate(this.prefix + COMMAND_NAME + ".noposition", new Object[0]), true);
            return;
        }
        List entityList = world.func_72872_a(EntityTrader.class, village.getAABB().func_186662_g(120.0));
        if (entityList.size() > 0) {
            CommandTraderSpawn.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(this.prefix + COMMAND_NAME + ".exists"), (Object[])new Object[0]);
            LoggerUtils.instance.info(TextUtils.translate(this.prefix + COMMAND_NAME + ".exists", new Object[0]), true);
            return;
        }
        if (!TektopiaUtils.trySpawnEntity(world, spawnPosition, w -> new EntityTrader((World)w)).booleanValue()) {
            CommandTraderSpawn.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(this.prefix + COMMAND_NAME + ".failed"), (Object[])new Object[0]);
            LoggerUtils.instance.info(TextUtils.translate(this.prefix + COMMAND_NAME + ".failed", new Object[0]), true);
            return;
        }
        CommandTraderSpawn.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(this.prefix + COMMAND_NAME + ".success"), (Object[])new Object[]{TektopiaUtils.formatBlockPos(spawnPosition)});
        LoggerUtils.instance.info(TextUtils.translate(this.prefix + COMMAND_NAME + ".success", TektopiaUtils.formatBlockPos(spawnPosition)), true);
    }
}

