/*
 * Decompiled with CFR 0.152.
 */
package bletch.common.entities.ai;

import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.tangotek.tektopia.entities.EntityVillageNavigator;
import net.tangotek.tektopia.pathing.BasePathingNode;
import net.tangotek.tektopia.pathing.PathNavigateVillager2;
import net.tangotek.tektopia.structures.VillageStructure;

public abstract class EntityAIMoveToBlock
extends EntityAIBase {
    protected static int STUCK_TIME = 40;
    protected static int MAX_STUCK_COUNT = 1000;
    protected final EntityVillageNavigator navigator;
    protected BlockPos destinationPos;
    protected BlockPos walkPos;
    protected int pathUpdateTick = 20;
    protected boolean arrived = false;
    protected int stuckCheck;
    protected Vec3d stuckPos;
    protected boolean stuck;
    protected int lastPathIndex;
    protected int stuckCount = 0;

    public EntityAIMoveToBlock(EntityVillageNavigator navigator) {
        this.navigator = navigator;
        this.stuckCheck = STUCK_TIME;
        this.stuckPos = Vec3d.field_186680_a;
        this.stuck = false;
        this.lastPathIndex = -1;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.navigator.hasVillage() && this.navigator.func_70661_as() instanceof PathNavigateVillager2 && this.canNavigate()) {
            this.destinationPos = this.getDestinationBlock();
            if (this.destinationPos != null) {
                this.stuck = false;
                this.stuckPos = new Vec3d(0.0, -400.0, 0.0);
                this.arrived = false;
                this.pathUpdateTick = 40;
                this.doMove();
                return !this.stuck;
            }
        }
        return false;
    }

    public void func_75249_e() {
        this.updateMovementMode();
    }

    public boolean func_75253_b() {
        return !this.arrived && !this.stuck && this.navigator.canNavigate();
    }

    public void func_75246_d() {
        --this.pathUpdateTick;
        if (this.pathUpdateTick <= 0 && !this.arrived) {
            this.pathUpdateTick = 40;
            this.navigator.updateMovement(this.arrived);
        }
        if (!this.arrived && this.isNearWalkPos()) {
            this.arrived = true;
            this.navigator.func_70661_as().func_75499_g();
            this.onArrival();
        }
        this.updateFacing();
        if (!this.arrived) {
            if (this.navigator.func_70661_as().func_75500_f()) {
                this.doMove();
            } else {
                int pathIndex = this.navigator.func_70661_as().func_75505_d().func_75873_e();
                if (this.lastPathIndex != pathIndex) {
                    this.lastPathIndex = pathIndex;
                }
            }
            --this.stuckCheck;
            if (this.stuckCheck < 0) {
                this.stuckCheck = STUCK_TIME;
                if (!this.navigator.func_70661_as().func_75500_f()) {
                    this.stuck = this.navigator.func_174791_d().func_72436_e(this.stuckPos) < 1.0;
                    this.stuckPos = this.navigator.func_174791_d();
                }
            }
            if (this.stuck) {
                this.stuckCount = Math.min(MAX_STUCK_COUNT, ++this.stuckCount);
                if (this.stuckCount < MAX_STUCK_COUNT && this.attemptStuckFix() && this.lastPathIndex >= 0) {
                    this.navigator.func_70661_as().func_75499_g();
                    this.doMove();
                } else {
                    this.onStuck();
                }
            }
        }
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.arrived = false;
        this.stuckCheck = STUCK_TIME;
        this.navigator.resetMovement();
    }

    protected boolean attemptStuckFix() {
        return false;
    }

    protected boolean canNavigate() {
        return this.navigator.field_70122_E;
    }

    protected void doMove() {
        this.arrived = false;
        this.stuckCheck = STUCK_TIME;
        this.walkPos = this.findWalkPos();
        if (this.walkPos == null) {
            this.stuck = true;
        } else if (!this.isNearWalkPos() && this.canNavigate()) {
            boolean pathFound = this.navigator.func_70661_as().func_75492_a((double)this.walkPos.func_177958_n(), (double)this.walkPos.func_177956_o(), (double)this.walkPos.func_177952_p(), (double)this.navigator.func_70689_ay());
            if (pathFound) {
                this.navigator.func_70671_ap().func_75650_a((double)this.walkPos.func_177958_n(), (double)this.walkPos.func_177956_o(), (double)this.walkPos.func_177952_p(), 50.0f, (float)this.navigator.func_70646_bf());
            } else {
                this.onPathFailed(this.walkPos);
            }
        }
    }

    protected BlockPos findWalkPos() {
        BlockPos pos = this.destinationPos;
        BlockPos diff = this.navigator.func_180425_c().func_177973_b((Vec3i)pos);
        EnumFacing facing = EnumFacing.func_176737_a((float)diff.func_177958_n(), (float)0.0f, (float)diff.func_177952_p());
        BlockPos testPos = pos.func_177972_a(facing);
        if (this.isWalkable(testPos, this.navigator)) {
            return testPos;
        }
        testPos = pos.func_177972_a(facing).func_177972_a(facing.func_176746_e());
        if (this.isWalkable(testPos, this.navigator)) {
            return testPos;
        }
        testPos = pos.func_177972_a(facing).func_177972_a(facing.func_176735_f());
        if (this.isWalkable(testPos, this.navigator)) {
            return testPos;
        }
        testPos = pos.func_177972_a(facing.func_176746_e());
        if (this.isWalkable(testPos, this.navigator)) {
            return testPos;
        }
        testPos = pos.func_177972_a(facing.func_176735_f());
        if (this.isWalkable(testPos, this.navigator)) {
            return testPos;
        }
        testPos = pos.func_177972_a(facing.func_176734_d());
        if (this.isWalkable(testPos, this.navigator)) {
            return testPos;
        }
        testPos = pos.func_177972_a(facing.func_176734_d()).func_177972_a(facing.func_176746_e());
        if (this.isWalkable(testPos, this.navigator)) {
            return testPos;
        }
        testPos = pos.func_177972_a(facing.func_176734_d()).func_177972_a(facing.func_176735_f());
        if (this.isWalkable(testPos, this.navigator)) {
            return testPos;
        }
        if (this.isWalkable(pos, this.navigator)) {
            return pos;
        }
        return null;
    }

    protected abstract BlockPos getDestinationBlock();

    public BlockPos getWalkPos() {
        return this.walkPos;
    }

    protected boolean hasArrived() {
        return this.arrived;
    }

    protected boolean isNearDestination(double range) {
        return this.destinationPos.func_177951_i((Vec3i)this.navigator.func_180425_c()) < range * range;
    }

    protected boolean isNearWalkPos() {
        return this.walkPos != null && this.walkPos.func_177951_i((Vec3i)this.navigator.func_180425_c()) <= 1.0;
    }

    protected boolean isWalkable(BlockPos pos, EntityVillageNavigator entity) {
        BasePathingNode baseNode;
        if (entity.getVillage() != null && (baseNode = entity.getVillage().getPathingGraph().getBaseNode(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) != null) {
            return !VillageStructure.isWoodDoor((World)entity.field_70170_p, (BlockPos)pos) && !VillageStructure.isGate((World)entity.field_70170_p, (BlockPos)pos);
        }
        return false;
    }

    protected void onArrival() {
    }

    protected void onPathFailed(BlockPos pos) {
        this.stuck = true;
    }

    protected void onStuck() {
        this.navigator.func_70661_as().func_75499_g();
    }

    protected void setArrived() {
        this.arrived = true;
    }

    protected void updateFacing() {
        if (!this.arrived && !this.navigator.func_70661_as().func_75500_f()) {
            Vec3d lookPos = this.navigator.func_70661_as().func_75505_d().func_186310_f();
            this.navigator.faceLocation(lookPos.field_72450_a, lookPos.field_72449_c, 4.0f);
        }
    }

    protected abstract void updateMovementMode();
}

