/*
 * Decompiled with CFR 0.152.
 */
package bletch.common.entities;

import bletch.common.Interfaces.IVillageEnemy;
import bletch.common.MovementMode;
import bletch.common.entities.ai.EntityAIIdleCheck;
import bletch.common.entities.ai.EntityAIUseDoor;
import bletch.common.entities.ai.EntityAIUseGate;
import com.leviathanstudio.craftstudio.client.animation.ClientAnimationHandler;
import com.leviathanstudio.craftstudio.common.animation.AnimationHandler;
import com.leviathanstudio.craftstudio.common.animation.IAnimated;
import java.util.Objects;
import java.util.Set;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.IMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tangotek.tektopia.TekVillager;
import net.tangotek.tektopia.VillagerRole;
import net.tangotek.tektopia.entities.EntityVillageNavigator;

public abstract class EntityEnemyBase
extends EntityVillageNavigator
implements IVillageEnemy,
IMob {
    protected static final AnimationHandler<EntityEnemyBase> animationHandler;
    protected static final DataParameter<String> ANIMATION_KEY;
    protected static final DataParameter<Integer> LEVEL;
    protected static final DataParameter<Byte> MOVEMENT_MODE;
    public static final Integer MIN_LEVEL;
    public static final Integer MAX_LEVEL;
    protected String modId;
    protected BlockPos firstCheck;
    protected int idle;
    protected MovementMode lastMovementMode;

    public EntityEnemyBase(World worldIn, String modId) {
        super(worldIn, VillagerRole.ENEMY.value | VillagerRole.VISITOR.value);
        this.modId = modId;
        this.idle = 0;
        this.func_70105_a(0.6f, 1.95f);
        this.func_70101_b(0.0f, 0.0f);
    }

    public EntityEnemyBase(World worldIn, String modId, int level) {
        this(worldIn, modId);
        this.setLevel(level);
    }

    protected void addTask(int priority, EntityAIBase task) {
        this.field_70714_bg.func_75776_a(priority, task);
    }

    protected abstract void checkStuck();

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected boolean getCanUseDoors() {
        return true;
    }

    public int getIdle() {
        return this.idle;
    }

    @Override
    public int getLevel() {
        return (Integer)this.field_70180_af.func_187225_a(LEVEL);
    }

    public MovementMode getMovementMode() {
        return MovementMode.valueOf((Byte)this.field_70180_af.func_187225_a(MOVEMENT_MODE));
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public World getWorld() {
        return this.field_70170_p;
    }

    @Override
    public boolean isMale() {
        return this.func_110124_au().getLeastSignificantBits() % 2L == 0L;
    }

    protected void prepStuck() {
        this.firstCheck = this.func_180425_c();
    }

    public void setIdle(int idle) {
        this.idle = idle;
    }

    @Override
    public void setLevel(int level) {
        this.field_70180_af.func_187227_b(LEVEL, (Object)Math.max(MIN_LEVEL, Math.min(level, MAX_LEVEL)));
    }

    public void setMovementMode(MovementMode mode) {
        this.field_70180_af.func_187227_b(MOVEMENT_MODE, (Object)mode.id);
    }

    protected void setupAITasks() {
        this.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.addTask(15, new EntityAIUseDoor((EntityLiving)this));
        this.addTask(15, new EntityAIUseGate((EntityLiving)this));
        this.addTask(150, new EntityAIIdleCheck(this));
    }

    @SideOnly(value=Side.CLIENT)
    protected void startWalking() {
        MovementMode mode = this.getMovementMode();
        if (mode != this.lastMovementMode) {
            if (this.lastMovementMode != null) {
                this.stopWalking();
            }
            this.lastMovementMode = mode;
            if (mode != null) {
                this.playClientAnimation(mode.animation);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void stopWalking() {
        if (this.lastMovementMode != null) {
            this.stopClientAnimation(this.lastMovementMode.animation);
            this.lastMovementMode = null;
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("level")) {
            this.setLevel(compound.func_74762_e("level"));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("level", this.getLevel());
    }

    protected static void setupCraftStudioAnimations(String modId, String modelName) {
        animationHandler.addAnim(modId, "villager_walk", modelName, true);
        animationHandler.addAnim(modId, "villager_run", modelName, true);
    }

    public AnimationHandler<EntityEnemyBase> getAnimationHandler() {
        return animationHandler;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.field_70180_af.func_187227_b(ANIMATION_KEY, (Object)"");
        this.field_70180_af.func_187227_b(MOVEMENT_MODE, (Object)MovementMode.WALK.id);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ANIMATION_KEY, (Object)"");
        this.field_70180_af.func_187214_a(LEVEL, (Object)1);
        this.field_70180_af.func_187214_a(MOVEMENT_MODE, (Object)0);
        super.func_70088_a();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.isWorldRemote() && ANIMATION_KEY.equals(key)) {
            this.updateClientAnimation((String)this.field_70180_af.func_187225_a(ANIMATION_KEY));
        }
        if (MOVEMENT_MODE.equals(key) && this.isWalking()) {
            this.startWalking();
        }
    }

    public void playClientAnimation(String animationName) {
        if (!this.getAnimationHandler().isAnimationActive(this.modId, animationName, (IAnimated)this)) {
            this.getAnimationHandler().startAnimation(this.modId, animationName, (IAnimated)this);
        }
    }

    public void stopClientAnimation(String animationName) {
        super.stopClientAnimation(animationName);
        if (this.getAnimationHandler().isAnimationActive(this.modId, animationName, (IAnimated)this)) {
            this.getAnimationHandler().stopAnimation(this.modId, animationName, (IAnimated)this);
        }
    }

    protected void updateClientAnimation(String animationName) {
        ClientAnimationHandler clientAnimationHandler = (ClientAnimationHandler)this.getAnimationHandler();
        Set animChannels = clientAnimationHandler.getAnimChannels().keySet();
        animChannels.forEach(a -> clientAnimationHandler.stopAnimation(a, (IAnimated)this));
        if (!animationName.isEmpty()) {
            clientAnimationHandler.startAnimation(this.modId, animationName, (IAnimated)this);
        }
    }

    public boolean isPlayingAnimation(String animationName) {
        return Objects.equals(animationName, this.field_70180_af.func_187225_a(ANIMATION_KEY));
    }

    public void playServerAnimation(String animationName) {
        this.field_70180_af.func_187227_b(ANIMATION_KEY, (Object)animationName);
    }

    public void stopServerAnimation(String animationName) {
        this.field_70180_af.func_187227_b(ANIMATION_KEY, (Object)"");
    }

    static {
        MIN_LEVEL = 1;
        MAX_LEVEL = 5;
        ANIMATION_KEY = EntityDataManager.func_187226_a(EntityEnemyBase.class, (DataSerializer)DataSerializers.field_187194_d);
        LEVEL = EntityDataManager.func_187226_a(EntityEnemyBase.class, (DataSerializer)DataSerializers.field_187192_b);
        MOVEMENT_MODE = EntityDataManager.func_187226_a(EntityEnemyBase.class, (DataSerializer)DataSerializers.field_187191_a);
        animationHandler = TekVillager.getNewAnimationHandler(EntityEnemyBase.class);
    }
}

