/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.extra.common.entity.rodents.rabbits;

import com.animania.addons.extra.common.entity.rodents.rabbits.EntityRabbitKitBase;
import com.animania.addons.extra.common.entity.rodents.rabbits.RabbitLop;
import com.animania.addons.extra.common.entity.rodents.rabbits.RabbitType;
import com.animania.addons.extra.common.handler.ExtraAddonSoundHandler;
import com.animania.addons.extra.config.ExtraConfig;
import com.animania.api.data.AnimalContainer;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.AnimaniaType;
import com.animania.api.interfaces.IAnimaniaAnimalBase;
import com.animania.api.interfaces.IConvertable;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.entities.generic.ai.GenericAIAvoidEntity;
import com.animania.common.entities.generic.ai.GenericAIEatGrass;
import com.animania.common.entities.generic.ai.GenericAIFindFood;
import com.animania.common.entities.generic.ai.GenericAIFindWater;
import com.animania.common.entities.generic.ai.GenericAILookIdle;
import com.animania.common.entities.generic.ai.GenericAIPanic;
import com.animania.common.entities.generic.ai.GenericAISleep;
import com.animania.common.entities.generic.ai.GenericAITempt;
import com.animania.common.entities.generic.ai.GenericAIWanderAvoidWater;
import com.animania.common.entities.generic.ai.GenericAIWatchClosest;
import com.animania.common.handler.DamageSourceHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.items.ItemEntityEgg;
import com.animania.config.AnimaniaConfig;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimaniaRabbit
extends EntityRabbit
implements IAnimaniaAnimalBase,
IConvertable {
    public static final Set<ItemStack> TEMPTATION_ITEMS = Sets.newHashSet((Object[])AnimaniaHelper.getItemStackArray((String[])ExtraConfig.settings.rabbitFood));
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaRabbit.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaRabbit.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COLOR_NUM = EntityDataManager.func_187226_a(EntityAnimaniaRabbit.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaRabbit.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaRabbit.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityAnimaniaRabbit.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SLEEPTIMER = EntityDataManager.func_187226_a(EntityAnimaniaRabbit.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> INTERACTED = EntityDataManager.func_187226_a(EntityAnimaniaRabbit.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final String[] RABBIT_TEXTURES = new String[]{"black", "brown", "golden", "olive", "patch_black", "patch_brown", "patch_grey"};
    protected int happyTimer;
    public int blinkTimer;
    public int eatTimer;
    protected int fedTimer;
    protected int wateredTimer;
    protected int damageTimer;
    public RabbitType rabbitType;
    public GenericAIEatGrass<EntityAnimaniaRabbit> entityAIEatGrass;
    protected boolean mateable = false;
    protected EntityGender gender;
    private ResourceLocation resourceLocation;
    private ResourceLocation resourceLocationBlink;
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;
    private boolean mateUuidCached = false;
    private UUID mateUUID = null;

    public EntityAnimaniaRabbit(World worldIn) {
        super(worldIn);
        this.field_70714_bg.field_75782_a.clear();
        this.entityAIEatGrass = new GenericAIEatGrass((EntityCreature)this, false);
        if (!AnimaniaConfig.gameRules.ambianceMode) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new GenericAIFindWater((EntityCreature)this, 1.4, this.entityAIEatGrass, EntityAnimaniaRabbit.class, true));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new GenericAIFindFood((EntityCreature)this, 1.4, this.entityAIEatGrass, true));
        }
        if (!this.func_95999_t().equals("Killer")) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new GenericAIPanic((EntityCreature)this, 2.5));
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new GenericAIWanderAvoidWater((EntityCreature)this, 1.8));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(7, (EntityAIBase)new GenericAITempt((EntityCreature)this, 1.25, false, TEMPTATION_ITEMS));
            this.field_70714_bg.func_75776_a(8, this.entityAIEatGrass);
            this.field_70714_bg.func_75776_a(9, (EntityAIBase)new GenericAIAvoidEntity((EntityCreature)this, EntityWolf.class, 24.0f, 3.0, 3.5));
            this.field_70714_bg.func_75776_a(9, (EntityAIBase)new GenericAIAvoidEntity((EntityCreature)this, EntityMob.class, 16.0f, 2.2, 2.2));
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)new GenericAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
            this.field_70714_bg.func_75776_a(11, (EntityAIBase)new GenericAILookIdle((EntityLiving)this));
            if (AnimaniaConfig.gameRules.animalsSleep) {
                this.field_70714_bg.func_75776_a(12, (EntityAIBase)new GenericAISleep((EntityCreature)this, 0.8, Block.func_149684_b((String)ExtraConfig.settings.rabbitBed), Block.func_149684_b((String)ExtraConfig.settings.rabbitBed2), EntityAnimaniaRabbit.class, (Function)new Function<Long, Boolean>(){

                    @Override
                    public Boolean apply(Long worldtime) {
                        return worldtime > 20000L && worldtime < 24000L || worldtime > 10000L && worldtime < 15000L;
                    }
                }));
            }
        } else {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.7f));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 2.0, true));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new GenericAIWanderAvoidWater((EntityCreature)this, 1.8));
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 20.0f));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
            this.func_70606_j(50.0f);
        }
        this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
        this.func_110163_bv();
        this.field_70767_i = new RabbitJumpHelper(this);
        this.field_70765_h = new RabbitMoveHelper(this);
        this.func_175515_b(0.0);
    }

    protected void resetAI() {
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.7f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 2.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new GenericAIWanderAvoidWater((EntityCreature)this, 1.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_70606_j(50.0f);
    }

    protected void func_184651_r() {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.34000001192092894);
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getSleeping()) {
            this.setSleeping(false);
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSourceHandler.killerRabbitDamage, 5.0f);
        entityIn.func_70097_a(DamageSourceHandler.killerRabbitDamage, 5.0f);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        if (entityIn instanceof EntityPlayer) {
            ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 1.0f, this.field_70165_t - entityIn.field_70165_t, this.field_70161_v - entityIn.field_70161_v);
        }
        return flag;
    }

    protected float func_175134_bD() {
        if (!(this.field_70123_F || this.field_70765_h.func_75640_a() && !(this.field_70765_h.func_179919_e() <= this.field_70163_u + 0.4))) {
            Path path = this.field_70699_by.func_75505_d();
            if (path != null && path.func_75873_e() < path.func_75874_d()) {
                Vec3d vec3d = path.func_75878_a((Entity)this);
                if (vec3d.field_72448_b > this.field_70163_u + 0.4) {
                    return 0.4f;
                }
            }
            return this.field_70765_h.func_75638_b() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.4f;
    }

    protected SoundEvent func_184639_G() {
        return GenericBehavior.getAmbientSound((EntityAnimal)this, (SoundEvent[])new SoundEvent[]{ExtraAddonSoundHandler.rabbit1, ExtraAddonSoundHandler.rabbit2, ExtraAddonSoundHandler.rabbit3, ExtraAddonSoundHandler.rabbit4});
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return GenericBehavior.getRandomSound((SoundEvent[])new SoundEvent[]{ExtraAddonSoundHandler.rabbitHurt1, ExtraAddonSoundHandler.rabbitHurt2});
    }

    protected SoundEvent func_184615_bR() {
        return GenericBehavior.getRandomSound((SoundEvent[])new SoundEvent[]{ExtraAddonSoundHandler.rabbitHurt1, ExtraAddonSoundHandler.rabbitHurt2});
    }

    protected void func_70664_aZ() {
        double d1;
        super.func_70664_aZ();
        double d0 = this.field_70765_h.func_75638_b();
        if (d0 > 0.0 && (d1 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) < 0.010000000000000002) {
            this.func_191958_b(0.0f, 1.5f, 0.1f, 0.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_175521_o(float p_175521_1_) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + p_175521_1_) / (float)this.jumpDuration;
    }

    public void func_175515_b(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    public void func_70637_d(boolean jumping) {
        super.func_70637_d(jumping);
        if (jumping) {
            // empty if block
        }
    }

    public void func_184770_cZ() {
        this.func_70637_d(true);
        this.jumpDuration = 20;
        this.jumpTicks = 0;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        if (this instanceof RabbitLop.EntityRabbitBuckLop || this instanceof RabbitLop.EntityRabbitKitLop || this instanceof RabbitLop.EntityRabbitDoeLop) {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(7));
        } else {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)0);
        }
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(INTERACTED, (Object)false);
    }

    protected ResourceLocation func_184647_J() {
        return this instanceof EntityRabbitKitBase ? null : (this.rabbitType.isPrime ? new ResourceLocation("extra/animania", "rabbit_prime") : new ResourceLocation("extra/animania", "rabbit_regular"));
    }

    public void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.field_70122_E) {
            RabbitJumpHelper entityrabbit$rabbitjumphelper;
            EntityLivingBase entitylivingbase;
            if (!this.wasOnGround) {
                this.func_70637_d(false);
                this.checkLandingDelay();
            }
            if (this.currentMoveTypeDuration == 0 && (entitylivingbase = this.func_70638_az()) != null && this.func_70068_e((Entity)entitylivingbase) < 16.0) {
                this.calculateRotationYaw(entitylivingbase.field_70165_t, entitylivingbase.field_70161_v);
                this.field_70765_h.func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, this.field_70765_h.func_75638_b());
                this.func_184770_cZ();
                this.wasOnGround = true;
            }
            if (!(entityrabbit$rabbitjumphelper = (RabbitJumpHelper)this.field_70767_i).getIsJumping()) {
                if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                    Path path = this.field_70699_by.func_75505_d();
                    Vec3d vec3d = new Vec3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (path != null && path.func_75873_e() < path.func_75874_d()) {
                        vec3d = path.func_75878_a((Entity)this);
                    }
                    this.calculateRotationYaw(vec3d.field_72450_a, vec3d.field_72449_c);
                    this.func_184770_cZ();
                }
            } else if (!entityrabbit$rabbitjumphelper.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    @Override
    public DataParameter<Integer> getAgeParam() {
        return AGE;
    }

    @Override
    public DataParameter<Boolean> getSleepingParam() {
        return SLEEPING;
    }

    @Override
    public DataParameter<Float> getSleepTimerParam() {
        return SLEEPTIMER;
    }

    @Override
    public DataParameter<Boolean> getHandFedParam() {
        return HANDFED;
    }

    @Override
    public DataParameter<Boolean> getFedParam() {
        return FED;
    }

    @Override
    public DataParameter<Boolean> getWateredParam() {
        return WATERED;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public int getColorNumber() {
        return this.getIntFromDataManager(COLOR_NUM);
    }

    public void setColorNumber(int color) {
        this.field_70180_af.func_187227_b(COLOR_NUM, (Object)color);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public ResourceLocation getResourceLocationBlink() {
        return this.resourceLocationBlink;
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.field_70161_v), (double)(x - this.field_70165_t)) * 57.29577951308232) - 90.0f;
    }

    private void enableJumpControl() {
        ((RabbitJumpHelper)this.field_70767_i).setCanJump(true);
    }

    private void disableJumpControl() {
        ((RabbitJumpHelper)this.field_70767_i).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    public void func_70636_d() {
        GenericBehavior.livingUpdateCommon((EntityAnimal)this);
        if (this.func_95999_t().equals("Killer")) {
            for (Object a : this.field_70714_bg.field_75782_a.toArray()) {
                EntityAIBase ai = ((EntityAITasks.EntityAITaskEntry)a).field_75733_a;
                if (!(ai instanceof GenericAIPanic)) continue;
                this.resetAI();
            }
        }
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.func_70637_d(false);
        }
        super.func_70636_d();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        EntityPlayer entityplayer = player;
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() == Items.field_151057_cb) {
            if (!stack.func_82837_s()) {
                return false;
            }
            EntityAnimaniaRabbit entityliving = this;
            entityliving.func_96094_a(stack.func_82833_r());
            entityliving.func_110163_bv();
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (stack.func_82833_r().equals("Killer")) {
                this.resetAI();
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
                this.func_70606_j(50.0f);
            }
        }
        return GenericBehavior.interactCommon((EntityAnimal)this, (EntityPlayer)entityplayer, (EnumHand)hand, this.entityAIEatGrass) ? true : super.func_184645_a(player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ColorNumber", this.getColorNumber());
        GenericBehavior.writeCommonNBT((NBTTagCompound)compound, (EntityAnimal)this);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setColorNumber(compound.func_74762_e("ColorNumber"));
        GenericBehavior.readCommonNBT((NBTTagCompound)compound, (EntityAnimal)this);
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != ItemStack.field_190927_a && AnimaniaHelper.containsItemStack(TEMPTATION_ITEMS, (ItemStack)stack);
    }

    public EntityAnimaniaRabbit createChild(EntityAgeable ageable) {
        return null;
    }

    @Override
    public Item getSpawnEgg() {
        return (Item)ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(this.rabbitType, this.gender));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 0;
    }

    @Override
    public int getSecondaryEggColor() {
        return 0;
    }

    @Override
    public EntityGender getEntityGender() {
        return this.gender;
    }

    @Override
    public Set<ItemStack> getFoodItems() {
        return TEMPTATION_ITEMS;
    }

    @Override
    public void setSleepingPos(BlockPos pos) {
    }

    @Override
    public BlockPos getSleepingPos() {
        return null;
    }

    @Override
    public int getBlinkTimer() {
        return this.blinkTimer;
    }

    @Override
    public void setBlinkTimer(int i) {
        this.blinkTimer = i;
    }

    @Override
    public Class[] getFoodBlocks() {
        return new Class[]{BlockCarrot.class, BlockTallGrass.class, BlockFlower.class};
    }

    @Override
    public int getEatTimer() {
        return this.eatTimer;
    }

    @Override
    public void setEatTimer(int i) {
        this.eatTimer = i;
    }

    @Override
    public int getFedTimer() {
        return this.fedTimer;
    }

    @Override
    public void setFedTimer(int i) {
        this.fedTimer = i;
    }

    @Override
    public DataParameter<Boolean> getInteractedParam() {
        return INTERACTED;
    }

    @Override
    public int getWaterTimer() {
        return this.wateredTimer;
    }

    @Override
    public void setWaterTimer(int i) {
        this.wateredTimer = i;
    }

    @Override
    public int getDamageTimer() {
        return this.damageTimer;
    }

    @Override
    public void setDamageTimer(int i) {
        this.damageTimer = i;
    }

    @Override
    public int getHappyTimer() {
        return this.happyTimer;
    }

    @Override
    public void setHappyTimer(int i) {
        this.happyTimer = i;
    }

    @Override
    public AnimaniaType getAnimalType() {
        return this.rabbitType;
    }

    @Override
    public Entity convertToVanilla() {
        EntityRabbit entity = new EntityRabbit(this.field_70170_p);
        entity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (entity.func_145818_k_()) {
            entity.func_96094_a(this.func_95999_t());
        }
        return entity;
    }

    static class RabbitMoveHelper
    extends EntityMoveHelper {
        private final EntityAnimaniaRabbit theEntity;
        private double nextJumpSpeed;

        public RabbitMoveHelper(EntityAnimaniaRabbit rabbit) {
            super((EntityLiving)rabbit);
            this.theEntity = rabbit;
        }

        public void func_75641_c() {
            if (this.theEntity.field_70122_E && !this.theEntity.field_70703_bu && !((RabbitJumpHelper)this.theEntity.field_70767_i).getIsJumping()) {
                this.theEntity.func_175515_b(0.0);
            } else if (this.func_75640_a()) {
                this.theEntity.func_175515_b(this.nextJumpSpeed);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            if (this.theEntity.func_70090_H()) {
                speedIn = 1.5;
            }
            super.func_75642_a(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }

    public class RabbitJumpHelper
    extends EntityJumpHelper {
        private final EntityAnimaniaRabbit theEntity;
        private boolean canJump;

        public RabbitJumpHelper(EntityAnimaniaRabbit rabbit) {
            super((EntityLiving)rabbit);
            this.theEntity = rabbit;
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.theEntity.func_184770_cZ();
                this.field_75662_b = false;
            }
        }
    }

    static class AIRaidFarm
    extends EntityAIMoveToBlock {
        private final EntityAnimaniaRabbit rabbit;
        private boolean wantsToRaid;
        private boolean canRaid;

        public AIRaidFarm(EntityAnimaniaRabbit rabbitIn) {
            super((EntityCreature)rabbitIn, (double)0.7f, 16);
            this.rabbit = rabbitIn;
        }

        public boolean func_75250_a() {
            if (this.field_179496_a <= 0) {
                if (!this.rabbit.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    return false;
                }
                this.canRaid = false;
                this.wantsToRaid = true;
            }
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            return this.canRaid && super.func_75253_b();
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.rabbit.func_70671_ap().func_75650_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)(this.field_179494_b.func_177956_o() + 1), (double)this.field_179494_b.func_177952_p() + 0.5, 10.0f, (float)this.rabbit.func_70646_bf());
            if (this.func_179487_f()) {
                World world = this.rabbit.field_70170_p;
                BlockPos blockpos = this.field_179494_b.func_177984_a();
                IBlockState iblockstate = world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (this.canRaid && block instanceof BlockCarrot) {
                    Integer integer = (Integer)iblockstate.func_177229_b((IProperty)BlockCarrot.field_176488_a);
                    if (integer == 0) {
                        world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 2);
                        world.func_175655_b(blockpos, true);
                    } else {
                        world.func_180501_a(blockpos, iblockstate.func_177226_a((IProperty)BlockCarrot.field_176488_a, (Comparable)Integer.valueOf(integer - 1)), 2);
                        world.func_175718_b(2001, blockpos, Block.func_176210_f((IBlockState)iblockstate));
                    }
                }
                this.canRaid = false;
                this.field_179496_a = 10;
            }
        }

        protected boolean func_179488_a(World worldIn, BlockPos pos) {
            IBlockState iblockstate;
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            if (block == Blocks.field_150458_ak && this.wantsToRaid && !this.canRaid && (block = (iblockstate = worldIn.func_180495_p(pos = pos.func_177984_a())).func_177230_c()) instanceof BlockCarrot && ((BlockCarrot)block).func_185525_y(iblockstate)) {
                this.canRaid = true;
                return true;
            }
            return false;
        }
    }

    static class AIPanic
    extends GenericAIPanic {
        private final EntityAnimaniaRabbit theEntity;

        public AIPanic(EntityAnimaniaRabbit rabbit, double speedIn) {
            super((EntityCreature)rabbit, speedIn);
            this.theEntity = rabbit;
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.theEntity.func_175515_b(this.field_75265_b);
        }
    }

    static class AIEvilAttack
    extends EntityAIAttackMelee {
        public AIEvilAttack(EntityAnimaniaRabbit rabbit) {
            super((EntityCreature)rabbit, 1.4, true);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }

    static class AIAvoidEntity<T extends Entity>
    extends GenericAIAvoidEntity<T> {
        private final EntityAnimaniaRabbit entityInstance;

        public AIAvoidEntity(EntityAnimaniaRabbit rabbit, Class<T> p_i46403_2_, float p_i46403_3_, double p_i46403_4_, double p_i46403_6_) {
            super((EntityCreature)rabbit, p_i46403_2_, p_i46403_3_, p_i46403_4_, p_i46403_6_);
            this.entityInstance = rabbit;
        }

        public boolean func_75250_a() {
            return true;
        }
    }
}

