/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.extra.common.entity.amphibians;

import com.animania.Animania;
import com.animania.addons.extra.common.entity.amphibians.AmphibianType;
import com.animania.addons.extra.common.entity.amphibians.EntityAmphibian;
import com.animania.addons.extra.common.handler.ExtraAddonSoundHandler;
import com.animania.api.data.AnimalContainer;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.AnimaniaType;
import com.animania.common.items.ItemEntityEgg;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityDartFrogs
extends EntityAmphibian {
    private static final DataParameter<Integer> FROGS_TYPE = EntityDataManager.func_187226_a(EntityDartFrogs.class, (DataSerializer)DataSerializers.field_187192_b);
    public int poisonTimer = 2;
    private int jumpTicks;
    private int jumpDuration;
    private boolean canEntityJump;

    public EntityDartFrogs(World worldIn) {
        super(worldIn, true);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FROGS_TYPE, (Object)this.field_70146_Z.nextInt(3));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("FrogsType", this.getFrogsType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setFrogsType(compound.func_74762_e("FrogsType"));
    }

    public int getFrogsType() {
        return (Integer)this.field_70180_af.func_187225_a(FROGS_TYPE);
    }

    public void setFrogsType(int frogsId) {
        this.field_70180_af.func_187227_b(FROGS_TYPE, (Object)frogsId);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        EntityPlayer entityplayer = player;
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151032_g && this.poisonTimer <= 1) {
            this.poisonTimer = 800;
            player.func_184185_a(SoundEvents.field_187764_dj, 0.2f, 1.8f);
            ItemStack bob = new ItemStack(Items.field_185167_i);
            PotionUtils.func_185188_a((ItemStack)bob, (PotionType)PotionTypes.field_185254_z);
            stack.func_190918_g(1);
            if (stack.func_190916_E() == 0) {
                player.func_184611_a(hand, bob);
                return true;
            }
            if (!player.field_71071_by.func_70441_a(bob)) {
                player.func_71019_a(bob, false);
                return true;
            }
            return super.func_184645_a(player, hand);
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof EntityPlayer && entityIn != this) {
            EntityPlayer player = (EntityPlayer)entityIn;
            player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 1, false, false));
        }
        entityIn.func_70108_f((Entity)this);
    }

    @Override
    public void func_70636_d() {
        if (this.poisonTimer > 1) {
            --this.poisonTimer;
        }
        if (this.canEntityJump) {
            if (this.jumpTicks != this.jumpDuration) {
                ++this.jumpTicks;
            } else if (this.jumpDuration != 0) {
                this.jumpTicks = 0;
                this.jumpDuration = 0;
                this.func_70637_d(false);
            }
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70636_d();
        if (this.field_70122_E) {
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E) {
            this.squishAmount = 0.5f;
        }
        this.alterSquishAmount();
    }

    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("extra/animania", "dart_frog");
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setFrogsType(this.field_70146_Z.nextInt(3));
        return livingdata;
    }

    @Override
    protected SoundEvent func_184639_G() {
        int chooser = Animania.RANDOM.nextInt(5);
        if (chooser == 0) {
            return ExtraAddonSoundHandler.dartfrogLiving1;
        }
        if (chooser == 1) {
            return ExtraAddonSoundHandler.dartfrogLiving2;
        }
        if (chooser == 2) {
            return ExtraAddonSoundHandler.dartfrogLiving3;
        }
        if (chooser == 3) {
            return ExtraAddonSoundHandler.dartfrogLiving4;
        }
        return null;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return null;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - (float)(this.func_70874_b() * 2));
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.04f, 1.1f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Override
    public Item getSpawnEgg() {
        return (Item)ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(AmphibianType.DART_FROG, EntityGender.NONE));
    }

    @Override
    public boolean usesEggColor() {
        return false;
    }

    @Override
    public AnimaniaType getAnimalType() {
        return AmphibianType.DART_FROG;
    }
}

