/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import toughasnails.api.temperature.IModifierMonitor;
import toughasnails.api.temperature.Temperature;
import toughasnails.handler.PacketHandler;
import toughasnails.network.message.MessageTemperatureClient;
import toughasnails.network.message.MessageToggleUI;

public class TemperatureDebugger
implements IModifierMonitor {
    public Map<String, IModifierMonitor.Context> modifiers = new LinkedHashMap<String, IModifierMonitor.Context>();
    private boolean showGui = false;
    public int debugTimer;
    public int temperatureTimer;
    public int changeTicks;
    public int targetTemperature;

    @Override
    public void addEntry(IModifierMonitor.Context context) {
        int difference = -(context.startTemperature.getRawValue() - context.endTemperature.getRawValue());
        if (difference != 0) {
            this.modifiers.put(context.modifierId, context);
        }
    }

    @Override
    public void setTargetTemperature(Temperature temperature) {
        this.targetTemperature = temperature.getRawValue();
    }

    public void finalize(EntityPlayerMP player) {
        this.debugTimer = 0;
        if (this.showGui) {
            this.sortModifiers();
        }
        PacketHandler.instance.sendTo((IMessage)new MessageTemperatureClient(this.temperatureTimer, this.changeTicks, this.targetTemperature, this.modifiers), player);
        this.clearModifiers();
    }

    private void sortModifiers() {
        LinkedList<Map.Entry<String, IModifierMonitor.Context>> entries = new LinkedList<Map.Entry<String, IModifierMonitor.Context>>(this.modifiers.entrySet());
        Collections.sort(entries, (o1, o2) -> {
            int difference2;
            int difference1 = ((IModifierMonitor.Context)o1.getValue()).endTemperature.getRawValue() - ((IModifierMonitor.Context)o1.getValue()).startTemperature.getRawValue();
            return difference1 > (difference2 = ((IModifierMonitor.Context)o2.getValue()).endTemperature.getRawValue() - ((IModifierMonitor.Context)o2.getValue()).startTemperature.getRawValue()) ? -1 : (difference1 < difference2 ? 1 : 0);
        });
        LinkedHashMap<String, IModifierMonitor.Context> sortedMap = new LinkedHashMap<String, IModifierMonitor.Context>();
        entries.forEach(entry -> {
            IModifierMonitor.Context cfr_ignored_0 = (IModifierMonitor.Context)sortedMap.put((String)entry.getKey(), (IModifierMonitor.Context)entry.getValue());
        });
        this.modifiers = sortedMap;
    }

    public void clearModifiers() {
        this.modifiers.clear();
    }

    public void setGuiVisible(boolean state, EntityPlayerMP updatePlayer) {
        this.showGui = state;
        this.debugTimer = 0;
        if (updatePlayer != null) {
            PacketHandler.instance.sendTo((IMessage)new MessageToggleUI(state), updatePlayer);
        }
    }

    public void setGuiVisible(boolean state) {
        this.setGuiVisible(state, null);
    }

    public boolean isGuiVisible() {
        return this.showGui;
    }
}

