/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.misc;

import com.hbm.config.RadiationConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderScreenOverlay {
    private static final ResourceLocation misc = new ResourceLocation("hbm:textures/misc/overlay_misc.png");
    private static final RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
    private static long lastRadSurvey;
    private static float prevRadResult;
    private static float lastRadResult;
    private static long lastDigSurvey;
    private static float prevDigResult;
    private static float lastDigResult;

    public static void renderRadCounter(ScaledResolution resolution, float in, Gui gui) {
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        float radiation = 0.0f;
        radiation = lastRadResult - prevRadResult;
        if (System.currentTimeMillis() >= lastRadSurvey + 1000L) {
            lastRadSurvey = System.currentTimeMillis();
            prevRadResult = lastRadResult;
            lastRadResult = in;
        }
        int length = 74;
        int maxRad = 1000;
        int bar = RenderScreenOverlay.getScaled(in, maxRad, 74.0);
        int posX = RadiationConfig.geigerX;
        int posY = resolution.func_78328_b() - 18 - RadiationConfig.geigerY;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        gui.func_73729_b(posX, posY, 0, 0, 94, 18);
        gui.func_73729_b(posX + 1, posY + 1, 1, 19, bar, 16);
        if (radiation >= 25.0f) {
            gui.func_73729_b(posX + length + 2 + 18, posY, 36, 36, 18, 18);
        } else if (radiation >= 10.0f) {
            gui.func_73729_b(posX + length + 2 + 18, posY, 18, 36, 18, 18);
        } else if ((double)radiation >= 2.5) {
            gui.func_73729_b(posX + length + 2 + 18, posY, 0, 36, 18, 18);
        }
        if (radiation > 1000.0f) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(">1000 RAD/s", posX, posY - 8, 0xFF0000);
        } else if (radiation >= 1.0f) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(Math.round(radiation) + " RAD/s", posX, posY - 8, 0xFFFF00);
        } else if (radiation > 0.0f) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b("<1 RAD/s", posX, posY - 8, 65280);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    public static void renderDigCounter(ScaledResolution resolution, float in, Gui gui) {
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        float digamma = 0.0f;
        digamma = lastDigResult - prevDigResult;
        if (System.currentTimeMillis() >= lastDigSurvey + 1000L) {
            lastDigSurvey = System.currentTimeMillis();
            prevDigResult = lastDigResult;
            lastDigResult = in;
        }
        int length = 74;
        int maxDig = 10;
        int bar = RenderScreenOverlay.getScaled(in, maxDig, 74.0);
        int posX = RadiationConfig.digammaX;
        int posY = resolution.func_78328_b() - 18 - RadiationConfig.digammaY;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        gui.func_73729_b(posX, posY, 0, 218, 94, 18);
        gui.func_73729_b(posX + 1, posY + 1, 1, 237, bar, 16);
        if ((double)digamma >= 0.25) {
            gui.func_73729_b(posX + length + 2 + 18, posY, 108, 72, 18, 18);
        } else if ((double)digamma >= 0.1) {
            gui.func_73729_b(posX + length + 2 + 18, posY, 90, 72, 18, 18);
        } else if ((double)digamma >= 0.025) {
            gui.func_73729_b(posX + length + 2 + 18, posY, 72, 72, 18, 18);
        }
        if ((double)digamma > 0.1) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(">100 mDRX/s", posX, posY - 8, 0xCC0000);
        } else if ((double)digamma >= 0.01) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b((int)Math.round((double)digamma * 1000.0) + " mDRX/s", posX, posY - 8, 0xFF0000);
        } else if (digamma > 0.0f) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b("<10 mDRX/s", posX, posY - 8, 0xFF3232);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    private static int getScaled(double cur, double max, double scale) {
        return (int)Math.min(cur / max * scale, scale);
    }

    public static void renderCustomCrosshairs(ScaledResolution resolution, Gui gui, Crosshair cross) {
        if (cross == Crosshair.NONE) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
            return;
        }
        int size = cross.size;
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        gui.func_73729_b(resolution.func_78326_a() / 2 - size / 2, resolution.func_78328_b() / 2 - size / 2, cross.x, cross.y, size, size);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179084_k();
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    public static void renderAmmo(ScaledResolution resolution, Gui gui, Item ammo, int count, int max, int dura, EnumHand hand, boolean renderCount) {
        GL11.glPushMatrix();
        int pX = resolution.func_78326_a() / 2 + 62 + 36;
        int pZ = resolution.func_78328_b() - 21;
        if (hand == EnumHand.OFF_HAND) {
            pX -= 277;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        gui.func_73729_b(pX, pZ + 16, 94, 0, 52, 3);
        gui.func_73729_b(pX + 1, pZ + 16, 95, 3, 50 - dura, 3);
        String cap = max == -1 ? "\u221e" : "" + max;
        Minecraft.func_71410_x().field_71466_p.func_78276_b(count + " / " + cap, pX + 16, pZ + 6, 0xFFFFFF);
        GlStateManager.func_179084_k();
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        itemRenderer.func_184391_a(null, new ItemStack(ammo), pX, pZ);
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179147_l();
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    public static void renderAmmoAlt(ScaledResolution resolution, Gui gui, Item ammo, int count, EnumHand hand) {
        GL11.glPushMatrix();
        int pX = resolution.func_78326_a() / 2 + 62 + 36 + 18;
        int pZ = resolution.func_78328_b() - 21 - 16;
        if (hand == EnumHand.OFF_HAND) {
            pX -= 296;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(count + "x", pX + 16, pZ + 6, 0xFFFFFF);
        GlStateManager.func_179084_k();
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        itemRenderer.func_184391_a(null, new ItemStack(ammo), pX, pZ);
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    public static enum Crosshair {
        NONE(0, 0, 0),
        CROSS(1, 55, 16),
        CIRCLE(19, 55, 16),
        SEMI(37, 55, 16),
        KRUCK(55, 55, 16),
        DUAL(1, 73, 16),
        SPLIT(19, 73, 16),
        CLASSIC(37, 73, 16),
        BOX(55, 73, 16),
        L_CROSS(0, 90, 32),
        L_KRUCK(32, 90, 32),
        L_CLASSIC(64, 90, 32),
        L_CIRCLE(96, 90, 32),
        L_SPLIT(0, 122, 32),
        L_ARROWS(32, 122, 32),
        L_BOX(64, 122, 32),
        L_CIRCUMFLEX(96, 122, 32),
        L_RAD(0, 154, 32);

        public int x;
        public int y;
        public int size;

        private Crosshair(int x, int y, int size) {
            this.x = x;
            this.y = y;
            this.size = size;
        }
    }
}

