/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.anim;

import com.hbm.animloader.AnimationWrapper;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationSequence;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class HbmAnimations {
    public static final Animation[] hotbar = new Animation[10];

    public static AnimationWrapper getRelevantBlenderAnim(EnumHand hand) {
        Animation anim = HbmAnimations.getRelevantAnim(hand);
        if (anim instanceof BlenderAnimation) {
            return ((BlenderAnimation)anim).wrapper;
        }
        return AnimationWrapper.EMPTY;
    }

    public static Animation getRelevantAnim(EnumHand hand) {
        ItemStack stack;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        int slot = player.field_71071_by.field_70461_c;
        if (hand == EnumHand.OFF_HAND) {
            slot = 9;
        }
        if ((stack = player.func_184586_b(hand)) == null || stack.func_190926_b()) {
            return null;
        }
        if (hotbar[slot] == null) {
            return null;
        }
        if (HbmAnimations.hotbar[slot].key.equals(stack.func_77973_b().func_77658_a())) {
            return hotbar[slot];
        }
        return null;
    }

    public static double[] getRelevantTransformation(String bus, EnumHand hand) {
        Animation anim = HbmAnimations.getRelevantAnim(hand);
        if (anim != null && anim.animation != null) {
            double[] trans;
            BusAnimation buses = anim.animation;
            int millis = (int)(System.currentTimeMillis() - anim.startMillis);
            BusAnimationSequence seq = buses.getBus(bus);
            if (seq != null && (trans = seq.getTransformation(millis)) != null) {
                return trans;
            }
        }
        return new double[]{0.0, 0.0, 0.0};
    }

    public static float getTimeDifference(String bus, EnumHand hand) {
        Animation anim = HbmAnimations.getRelevantAnim(hand);
        if (anim != null && anim.animation != null) {
            return (float)(System.currentTimeMillis() - anim.startMillis) / 1000.0f;
        }
        return 0.0f;
    }

    public static class BlenderAnimation
    extends Animation {
        public AnimationWrapper wrapper;

        public BlenderAnimation(String key, long startMillis, float scale, com.hbm.animloader.Animation animation, AnimationWrapper.EndResult end) {
            super(key, startMillis, null);
            this.wrapper = new AnimationWrapper(startMillis, scale, animation).onEnd(end);
        }
    }

    public static class Animation {
        public String key;
        public long startMillis;
        public BusAnimation animation;

        public Animation(String key, long startMillis, BusAnimation animation) {
            this.key = key;
            this.startMillis = startMillis;
            this.animation = animation;
        }
    }

    public static enum AnimType {
        RELOAD,
        CYCLE,
        ALT_CYCLE,
        SPINUP,
        SPINDOWN;

    }
}

