/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render;

import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.Project;

public class FakeWorldRenderer {
    private final FloatBuffer fogColorBuffer = GLAllocation.func_74529_h((int)16);
    private float fogColorRed;
    private float fogColorGreen;
    private float fogColorBlue;
    private float bossColorModifier;
    private float bossColorModifierPrev;
    private float fogColor2;
    private float fogColor1;
    private boolean cloudFog;
    private float farPlaneDistance;
    public int rendererUpdateCount;
    private final Random random = new Random();
    private final float[] rainXCoords = new float[1024];
    private final float[] rainYCoords = new float[1024];
    private static final ResourceLocation RAIN_TEXTURES = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation SNOW_TEXTURES = new ResourceLocation("textures/environment/snow.png");
    public static final FakeWorldRenderer INSTANCE = new FakeWorldRenderer();
    private Minecraft mc = null;

    private FakeWorldRenderer() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.rainXCoords[i << 5 | j] = -f1 / f2;
                this.rainYCoords[i << 5 | j] = f / f2;
            }
        }
    }

    public void renderWorld(float partialTicks, long finishTimeNano) {
        if (this.mc == null) {
            this.mc = Minecraft.func_71410_x();
        }
        if (this.mc.func_175606_aa() == null) {
            this.mc.func_175607_a((Entity)this.mc.field_71439_g);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.5f);
        this.renderWorldPass(2, partialTicks, finishTimeNano);
    }

    private void renderWorldPass(int pass, float partialTicks, long finishTimeNano) {
        RenderGlobal renderglobal = this.mc.field_71438_f;
        ParticleManager particlemanager = this.mc.field_71452_i;
        GlStateManager.func_179089_o();
        this.mc.field_71424_I.func_76318_c("clear");
        GlStateManager.func_179083_b((int)0, (int)0, (int)this.mc.field_71443_c, (int)this.mc.field_71440_d);
        this.updateFogColor(partialTicks);
        GlStateManager.func_179086_m((int)16640);
        this.mc.field_71424_I.func_76318_c("camera");
        this.setupCameraTransform(partialTicks, pass);
        this.mc.field_71424_I.func_76318_c("frustum");
        ClippingHelperImpl.func_78558_a();
        this.mc.field_71424_I.func_76318_c("culling");
        Frustum icamera = new Frustum();
        Entity entity = this.mc.func_175606_aa();
        double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        icamera.func_78547_a(d0, d1, d2);
        if (this.mc.field_71474_y.field_151451_c >= 4) {
            this.setupFog(-1, partialTicks);
            this.mc.field_71424_I.func_76318_c("sky");
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            Project.gluPerspective((float)this.getFOVModifier(partialTicks, true), (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)0.05f, (float)(this.farPlaneDistance * 2.0f));
            GlStateManager.func_179128_n((int)5888);
            renderglobal.func_174976_a(partialTicks, pass);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            Project.gluPerspective((float)this.getFOVModifier(partialTicks, true), (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)0.05f, (float)(this.farPlaneDistance * MathHelper.field_180189_a));
            GlStateManager.func_179128_n((int)5888);
        }
        this.setupFog(0, partialTicks);
        GlStateManager.func_179103_j((int)7425);
        this.mc.field_71424_I.func_76318_c("prepareterrain");
        this.setupFog(0, partialTicks);
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        this.mc.field_71424_I.func_76318_c("terrain_setup");
        renderglobal.func_174970_a(entity, (double)partialTicks, (ICamera)icamera, 0, this.mc.field_71439_g.func_175149_v());
        if (pass == 0 || pass == 2) {
            this.mc.field_71424_I.func_76318_c("updatechunks");
            this.mc.field_71438_f.func_174967_a(finishTimeNano);
        }
        this.mc.field_71424_I.func_76318_c("terrain");
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179118_c();
        renderglobal.func_174977_a(BlockRenderLayer.SOLID, (double)partialTicks, pass, entity);
        GlStateManager.func_179141_d();
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, this.mc.field_71474_y.field_151442_I > 0);
        renderglobal.func_174977_a(BlockRenderLayer.CUTOUT_MIPPED, (double)partialTicks, pass, entity);
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        renderglobal.func_174977_a(BlockRenderLayer.CUTOUT, (double)partialTicks, pass, entity);
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        RenderHelper.func_74519_b();
        this.mc.field_71424_I.func_76318_c("entities");
        ForgeHooksClient.setRenderPass((int)0);
        renderglobal.func_180446_a(entity, (ICamera)icamera, partialTicks);
        ForgeHooksClient.setRenderPass((int)0);
        RenderHelper.func_74518_a();
        this.disableLightmap();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        if (this.mc.field_184132_p.func_190074_a()) {
            this.mc.field_184132_p.func_190073_a(partialTicks, finishTimeNano);
        }
        this.mc.field_71424_I.func_76318_c("destroyProgress");
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        renderglobal.func_174981_a(Tessellator.func_178181_a(), Tessellator.func_178181_a().func_178180_c(), entity, partialTicks);
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179084_k();
        this.enableLightmap();
        this.mc.field_71424_I.func_76318_c("litParticles");
        particlemanager.func_78872_b(entity, partialTicks);
        RenderHelper.func_74518_a();
        this.setupFog(0, partialTicks);
        this.mc.field_71424_I.func_76318_c("particles");
        particlemanager.func_78874_a(entity, partialTicks);
        this.disableLightmap();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179089_o();
        this.mc.field_71424_I.func_76318_c("weather");
        this.renderRainSnow(partialTicks);
        GlStateManager.func_179132_a((boolean)true);
        renderglobal.func_180449_a(entity, partialTicks);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        this.setupFog(0, partialTicks);
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)false);
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179103_j((int)7425);
        this.mc.field_71424_I.func_76318_c("translucent");
        renderglobal.func_174977_a(BlockRenderLayer.TRANSLUCENT, (double)partialTicks, pass, entity);
        RenderHelper.func_74519_b();
        this.mc.field_71424_I.func_76318_c("entities");
        ForgeHooksClient.setRenderPass((int)1);
        renderglobal.func_180446_a(entity, (ICamera)icamera, partialTicks);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        ForgeHooksClient.setRenderPass((int)-1);
        RenderHelper.func_74518_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179106_n();
        this.mc.field_71424_I.func_76318_c("forge_render_last");
        ForgeHooksClient.dispatchRenderLast((RenderGlobal)renderglobal, (float)partialTicks);
        this.mc.field_71424_I.func_76318_c("hand");
    }

    private void setupFog(int startCoords, float partialTicks) {
        Entity entity = this.mc.func_175606_aa();
        this.setupFogColor(false);
        GlStateManager.func_187432_a((float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IBlockState iblockstate = ActiveRenderInfo.func_186703_a((World)this.mc.field_71441_e, (Entity)entity, (float)partialTicks);
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76440_q)) {
            float f1 = 5.0f;
            int i = ((EntityLivingBase)entity).func_70660_b(MobEffects.field_76440_q).func_76459_b();
            if (i < 20) {
                f1 = 5.0f + (this.farPlaneDistance - 5.0f) * (1.0f - (float)i / 20.0f);
            }
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            if (startCoords == -1) {
                GlStateManager.func_179102_b((float)0.0f);
                GlStateManager.func_179153_c((float)(f1 * 0.8f));
            } else {
                GlStateManager.func_179102_b((float)(f1 * 0.25f));
                GlStateManager.func_179153_c((float)f1);
            }
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GlStateManager.func_187412_c((int)34138, (int)34139);
            }
        } else if (this.cloudFog) {
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            GlStateManager.func_179095_a((float)0.1f);
        } else if (iblockstate.func_185904_a() == Material.field_151586_h) {
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            if (entity instanceof EntityLivingBase) {
                if (((EntityLivingBase)entity).func_70644_a(MobEffects.field_76427_o)) {
                    GlStateManager.func_179095_a((float)0.01f);
                } else {
                    GlStateManager.func_179095_a((float)(0.1f - (float)EnchantmentHelper.func_185292_c((EntityLivingBase)((EntityLivingBase)entity)) * 0.03f));
                }
            } else {
                GlStateManager.func_179095_a((float)0.1f);
            }
        } else if (iblockstate.func_185904_a() == Material.field_151587_i) {
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            GlStateManager.func_179095_a((float)2.0f);
        } else {
            float f = this.farPlaneDistance;
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            if (startCoords == -1) {
                GlStateManager.func_179102_b((float)0.0f);
                GlStateManager.func_179153_c((float)f);
            } else {
                GlStateManager.func_179102_b((float)(f * 0.75f));
                GlStateManager.func_179153_c((float)f);
            }
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GlStateManager.func_187412_c((int)34138, (int)34139);
            }
            if (this.mc.field_71441_e.field_73011_w.func_76568_b((int)entity.field_70165_t, (int)entity.field_70161_v) || this.mc.field_71456_v.func_184046_j().func_184056_f()) {
                GlStateManager.func_179102_b((float)(f * 0.05f));
                GlStateManager.func_179153_c((float)(Math.min(f, 192.0f) * 0.5f));
            }
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_179127_m();
        GlStateManager.func_179104_a((int)1028, (int)4608);
    }

    public void setupFogColor(boolean black) {
        if (black) {
            GlStateManager.func_187402_b((int)2918, (FloatBuffer)this.setFogColorBuffer(0.0f, 0.0f, 0.0f, 1.0f));
        } else {
            GlStateManager.func_187402_b((int)2918, (FloatBuffer)this.setFogColorBuffer(this.fogColorRed, this.fogColorGreen, this.fogColorBlue, 1.0f));
        }
    }

    private FloatBuffer setFogColorBuffer(float red, float green, float blue, float alpha) {
        this.fogColorBuffer.clear();
        this.fogColorBuffer.put(red).put(green).put(blue).put(alpha);
        this.fogColorBuffer.flip();
        return this.fogColorBuffer;
    }

    private void updateFogColor(float partialTicks) {
        float f9;
        WorldClient world = this.mc.field_71441_e;
        Entity entity = this.mc.func_175606_aa();
        float f = 0.25f + 0.75f * (float)this.mc.field_71474_y.field_151451_c / 32.0f;
        f = 1.0f - (float)Math.pow(f, 0.25);
        Vec3d vec3d = world.func_72833_a(this.mc.func_175606_aa(), partialTicks);
        float f1 = (float)vec3d.field_72450_a;
        float f2 = (float)vec3d.field_72448_b;
        float f3 = (float)vec3d.field_72449_c;
        Vec3d vec3d1 = world.func_72948_g(partialTicks);
        this.fogColorRed = (float)vec3d1.field_72450_a;
        this.fogColorGreen = (float)vec3d1.field_72448_b;
        this.fogColorBlue = (float)vec3d1.field_72449_c;
        if (this.mc.field_71474_y.field_151451_c >= 4) {
            float[] afloat;
            double d0 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) > 0.0f ? -1.0 : 1.0;
            Vec3d vec3d2 = new Vec3d(d0, 0.0, 0.0);
            float f5 = (float)entity.func_70676_i(partialTicks).func_72430_b(vec3d2);
            if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            if (f5 > 0.0f && (afloat = world.field_73011_w.func_76560_a(world.func_72826_c(partialTicks), partialTicks)) != null) {
                this.fogColorRed = this.fogColorRed * (1.0f - (f5 *= afloat[3])) + afloat[0] * f5;
                this.fogColorGreen = this.fogColorGreen * (1.0f - f5) + afloat[1] * f5;
                this.fogColorBlue = this.fogColorBlue * (1.0f - f5) + afloat[2] * f5;
            }
        }
        this.fogColorRed += (f1 - this.fogColorRed) * f;
        this.fogColorGreen += (f2 - this.fogColorGreen) * f;
        this.fogColorBlue += (f3 - this.fogColorBlue) * f;
        float f8 = world.func_72867_j(partialTicks);
        if (f8 > 0.0f) {
            float f4 = 1.0f - f8 * 0.5f;
            float f10 = 1.0f - f8 * 0.4f;
            this.fogColorRed *= f4;
            this.fogColorGreen *= f4;
            this.fogColorBlue *= f10;
        }
        if ((f9 = world.func_72819_i(partialTicks)) > 0.0f) {
            float f11 = 1.0f - f9 * 0.5f;
            this.fogColorRed *= f11;
            this.fogColorGreen *= f11;
            this.fogColorBlue *= f11;
        }
        float f13 = this.fogColor2 + (this.fogColor1 - this.fogColor2) * partialTicks;
        this.fogColorRed *= f13;
        this.fogColorGreen *= f13;
        this.fogColorBlue *= f13;
        double d1 = (entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks) * world.field_73011_w.func_76565_k();
        if (d1 < 1.0) {
            if (d1 < 0.0) {
                d1 = 0.0;
            }
            d1 *= d1;
            this.fogColorRed = (float)((double)this.fogColorRed * d1);
            this.fogColorGreen = (float)((double)this.fogColorGreen * d1);
            this.fogColorBlue = (float)((double)this.fogColorBlue * d1);
        }
        if (this.bossColorModifier > 0.0f) {
            float f14 = this.bossColorModifierPrev + (this.bossColorModifier - this.bossColorModifierPrev) * partialTicks;
            this.fogColorRed = this.fogColorRed * (1.0f - f14) + this.fogColorRed * 0.7f * f14;
            this.fogColorGreen = this.fogColorGreen * (1.0f - f14) + this.fogColorGreen * 0.6f * f14;
            this.fogColorBlue = this.fogColorBlue * (1.0f - f14) + this.fogColorBlue * 0.6f * f14;
        }
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76439_r)) {
            float f15 = this.getNightVisionBrightness((EntityLivingBase)entity, partialTicks);
            float f6 = 1.0f / this.fogColorRed;
            if (f6 > 1.0f / this.fogColorGreen) {
                f6 = 1.0f / this.fogColorGreen;
            }
            if (f6 > 1.0f / this.fogColorBlue) {
                f6 = 1.0f / this.fogColorBlue;
            }
            if (Float.isInfinite(f6)) {
                f6 = Math.nextAfter(f6, 0.0);
            }
            this.fogColorRed = this.fogColorRed * (1.0f - f15) + this.fogColorRed * f6 * f15;
            this.fogColorGreen = this.fogColorGreen * (1.0f - f15) + this.fogColorGreen * f6 * f15;
            this.fogColorBlue = this.fogColorBlue * (1.0f - f15) + this.fogColorBlue * f6 * f15;
        }
        if (this.mc.field_71474_y.field_74337_g) {
            float f16 = (this.fogColorRed * 30.0f + this.fogColorGreen * 59.0f + this.fogColorBlue * 11.0f) / 100.0f;
            float f17 = (this.fogColorRed * 30.0f + this.fogColorGreen * 70.0f) / 100.0f;
            float f7 = (this.fogColorRed * 30.0f + this.fogColorBlue * 70.0f) / 100.0f;
            this.fogColorRed = f16;
            this.fogColorGreen = f17;
            this.fogColorBlue = f7;
        }
        GlStateManager.func_179082_a((float)this.fogColorRed, (float)this.fogColorGreen, (float)this.fogColorBlue, (float)0.0f);
    }

    private float getNightVisionBrightness(EntityLivingBase entitylivingbaseIn, float partialTicks) {
        int i = entitylivingbaseIn.func_70660_b(MobEffects.field_76439_r).func_76459_b();
        return i > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)(((float)i - partialTicks) * (float)Math.PI * 0.2f)) * 0.3f;
    }

    private void orientCamera(float partialTicks) {
        Entity entity = this.mc.func_175606_aa();
        float f = entity.func_70047_e();
        double d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        double d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks + (double)f;
        double d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.05f);
        GlStateManager.func_179109_b((float)0.0f, (float)(-f), (float)0.0f);
        d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks + (double)f;
        d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        this.cloudFog = this.mc.field_71438_f.func_72721_a(d0, d1, d2, partialTicks);
    }

    private void setupCameraTransform(float partialTicks, int pass) {
        this.farPlaneDistance = this.mc.field_71474_y.field_151451_c * 16;
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        if (this.mc.field_71474_y.field_74337_g) {
            GlStateManager.func_179109_b((float)((float)(-(pass * 2 - 1)) * 0.07f), (float)0.0f, (float)0.0f);
        }
        Project.gluPerspective((float)this.getFOVModifier(partialTicks, true), (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)0.05f, (float)(this.farPlaneDistance * MathHelper.field_180189_a));
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        if (this.mc.field_71474_y.field_74337_g) {
            GlStateManager.func_179109_b((float)((float)(pass * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
        }
        this.orientCamera(partialTicks);
    }

    public void disableLightmap() {
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public void enableLightmap() {
    }

    private float getFOVModifier(float partialTicks, boolean useFOVSetting) {
        return 70.0f;
    }

    protected void renderRainSnow(float partialTicks) {
        IRenderHandler renderer = this.mc.field_71441_e.field_73011_w.getWeatherRenderer();
        if (renderer != null) {
            renderer.render(partialTicks, this.mc.field_71441_e, this.mc);
            return;
        }
        float f = this.mc.field_71441_e.func_72867_j(partialTicks);
        if (f > 0.0f) {
            this.enableLightmap();
            Entity entity = this.mc.func_175606_aa();
            WorldClient world = this.mc.field_71441_e;
            int i = MathHelper.func_76128_c((double)entity.field_70165_t);
            int j = MathHelper.func_76128_c((double)entity.field_70163_u);
            int k = MathHelper.func_76128_c((double)entity.field_70161_v);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179129_p();
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            int l = MathHelper.func_76128_c((double)d1);
            int i1 = 5;
            if (this.mc.field_71474_y.field_74347_j) {
                i1 = 10;
            }
            int j1 = -1;
            float f1 = (float)this.rendererUpdateCount + partialTicks;
            bufferbuilder.func_178969_c(-d0, -d1, -d2);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)this.rainXCoords[i2] * 0.5;
                    double d4 = (double)this.rainYCoords[i2] * 0.5;
                    blockpos$mutableblockpos.func_181079_c(l1, 0, k1);
                    Biome biome = world.func_180494_b((BlockPos)blockpos$mutableblockpos);
                    if (!biome.func_76738_d() && !biome.func_76746_c()) continue;
                    int j2 = world.func_175725_q((BlockPos)blockpos$mutableblockpos).func_177956_o();
                    int k2 = j - i1;
                    int l2 = j + i1;
                    if (k2 < j2) {
                        k2 = j2;
                    }
                    if (l2 < j2) {
                        l2 = j2;
                    }
                    int i3 = j2;
                    if (j2 < l) {
                        i3 = l;
                    }
                    if (k2 == l2) continue;
                    this.random.setSeed(l1 * l1 * 3121 + l1 * 45238971 ^ k1 * k1 * 418711 + k1 * 13761);
                    blockpos$mutableblockpos.func_181079_c(l1, k2, k1);
                    float f2 = biome.func_180626_a((BlockPos)blockpos$mutableblockpos);
                    if (world.func_72959_q().func_76939_a(f2, j2) >= 0.15f) {
                        if (j1 != 0) {
                            if (j1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            j1 = 0;
                            this.mc.func_110434_K().func_110577_a(RAIN_TEXTURES);
                            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        double d5 = -((double)(this.rendererUpdateCount + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + this.random.nextDouble());
                        double d6 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                        double d7 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                        float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)i1;
                        float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                        blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                        int j3 = world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0);
                        int k3 = j3 >> 16 & 0xFFFF;
                        int l3 = j3 & 0xFFFF;
                        bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        continue;
                    }
                    if (j1 != 1) {
                        if (j1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        j1 = 1;
                        this.mc.func_110434_K().func_110577_a(SNOW_TEXTURES);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    double d8 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                    double d9 = this.random.nextDouble() + (double)f1 * 0.01 * (double)((float)this.random.nextGaussian());
                    double d10 = this.random.nextDouble() + (double)(f1 * (float)this.random.nextGaussian()) * 0.001;
                    double d11 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                    double d12 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                    float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)i1;
                    float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * f;
                    blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                    int i4 = (world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0) * 3 + 0xF000F0) / 4;
                    int j4 = i4 >> 16 & 0xFFFF;
                    int k4 = i4 & 0xFFFF;
                    bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                }
            }
            if (j1 >= 0) {
                tessellator.func_78381_a();
            }
            bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            this.disableLightmap();
        }
    }
}

