/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.special;

import com.hbm.blocks.generic.BlockClean;
import com.hbm.config.CompatibilityConfig;
import com.hbm.entity.effect.EntityFalloutUnderGround;
import com.hbm.items.special.ItemHazard;
import com.hbm.util.I18nUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemContaminating
extends ItemHazard {
    private int burntime;
    private int falloutBallRadius = 0;

    public ItemContaminating(float radiation, String s) {
        super(radiation, s);
        this.falloutBallRadius = (int)Math.min(Math.sqrt(radiation) + 0.5, 500.0);
    }

    public ItemContaminating(float radiation, boolean fire, String s) {
        super(radiation, fire, s);
        this.falloutBallRadius = (int)Math.min(Math.sqrt(radiation) + 0.5, 500.0);
    }

    public ItemContaminating(float radiation, boolean fire, boolean blinding, String s) {
        super(radiation, fire, blinding, s);
        this.falloutBallRadius = (int)Math.min(Math.sqrt(radiation) + 0.5, 500.0);
    }

    @Override
    public boolean onEntityItemUpdate(EntityItem entityItem) {
        boolean m = this.module.onEntityItemUpdate(entityItem);
        if (entityItem != null && !entityItem.field_70170_p.field_72995_K && (entityItem.field_70122_E || entityItem.func_70027_ad()) && CompatibilityConfig.isWarDim(entityItem.field_70170_p)) {
            if (ItemContaminating.isCleanGround(new BlockPos(entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v), entityItem.field_70170_p)) {
                return false;
            }
            if (this.falloutBallRadius > 1) {
                EntityFalloutUnderGround falloutBall = new EntityFalloutUnderGround(entityItem.field_70170_p);
                falloutBall.field_70165_t = entityItem.field_70165_t;
                falloutBall.field_70163_u = entityItem.field_70163_u + 0.5;
                falloutBall.field_70161_v = entityItem.field_70161_v;
                falloutBall.setScale(this.falloutBallRadius);
                entityItem.field_70170_p.func_72838_d((Entity)falloutBall);
            }
            entityItem.func_70106_y();
            return true;
        }
        return m;
    }

    public static boolean isCleanGround(BlockPos pos, World world) {
        Block b = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        boolean isClean = b instanceof BlockClean;
        if (isClean) {
            BlockClean.getUsed(b, pos.func_177977_b(), world);
        }
        return isClean;
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, list, flagIn);
        if (this.falloutBallRadius > 1) {
            list.add("\u00a72[" + I18nUtil.resolveKey("trait.contaminating", new Object[0]) + "\u00a72]");
            list.add(" \u00a7a" + I18nUtil.resolveKey("trait.contaminating.radius", this.falloutBallRadius));
        }
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return this.burntime;
    }
}

