/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.nodes;

import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.NodeConnection;
import com.hbm.inventory.control_panel.NodeDropdown;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.NodeType;
import com.hbm.inventory.control_panel.nodes.Node;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public class NodeMath
extends Node {
    public Operation op = Operation.ADD;

    public NodeMath(float x, float y) {
        super(x, y);
        this.outputs.add(new NodeConnection("Output", this, this.outputs.size(), false, DataValue.DataType.NUMBER, new DataValueFloat(0.0f)));
        NodeDropdown opSelector = new NodeDropdown(this, this.otherElements.size(), s -> {
            Operation op = Operation.getByName(s);
            if (op != null) {
                this.setOperation(op);
            }
            return null;
        }, () -> this.op.name);
        for (Operation op : Operation.values()) {
            opSelector.list.addItems(op.name);
        }
        this.otherElements.add(opSelector);
        this.setOperation(Operation.ADD);
        this.evalCache = new DataValue[1];
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, NodeSystem sys) {
        tag.func_74778_a("nodeType", "math");
        tag.func_74768_a("op", this.op.ordinal());
        return super.writeToNBT(tag, sys);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, NodeSystem sys) {
        this.op = Operation.values()[tag.func_74762_e("op") % Operation.values().length];
        super.readFromNBT(tag, sys);
    }

    @Override
    public DataValue evaluate(int idx) {
        if (this.cacheValid) {
            return this.evalCache[0];
        }
        this.cacheValid = true;
        DataValue[] evals = new DataValue[this.inputs.size()];
        for (int i = 0; i < evals.length; ++i) {
            evals[i] = ((NodeConnection)this.inputs.get(i)).evaluate();
            if (evals[i] != null) continue;
            return null;
        }
        switch (this.op) {
            case ADD: {
                this.evalCache[0] = new DataValueFloat(evals[0].getNumber() + evals[1].getNumber());
                return this.evalCache[0];
            }
            case SUB: {
                this.evalCache[0] = new DataValueFloat(evals[0].getNumber() - evals[1].getNumber());
                return this.evalCache[0];
            }
            case MULT: {
                this.evalCache[0] = new DataValueFloat(evals[0].getNumber() * evals[1].getNumber());
                return this.evalCache[0];
            }
            case DIV: {
                this.evalCache[0] = new DataValueFloat(evals[0].getNumber() / evals[1].getNumber());
                return this.evalCache[0];
            }
            case MOD: {
                this.evalCache[0] = new DataValueFloat(evals[0].getNumber() % evals[1].getNumber());
                return this.evalCache[0];
            }
            case POW: {
                this.evalCache[0] = new DataValueFloat((float)Math.pow(evals[0].getNumber(), evals[1].getNumber()));
                return this.evalCache[0];
            }
            case LOG: {
                this.evalCache[0] = new DataValueFloat((float)(Math.log(evals[0].getNumber()) / Math.log(evals[1].getNumber())));
                return this.evalCache[0];
            }
            case EXP: {
                this.evalCache[0] = new DataValueFloat((float)Math.exp(evals[0].getNumber()));
                return this.evalCache[0];
            }
            case SQRT: {
                this.evalCache[0] = new DataValueFloat((float)Math.sqrt(evals[0].getNumber()));
                return this.evalCache[0];
            }
            case ABS: {
                this.evalCache[0] = new DataValueFloat(Math.abs(evals[0].getNumber()));
                return this.evalCache[0];
            }
            case EQUAL: {
                this.evalCache[0] = new DataValueFloat(evals[0].getNumber() == evals[1].getNumber() ? 1.0f : 0.0f);
                return this.evalCache[0];
            }
            case GREATER: {
                this.evalCache[0] = new DataValueFloat(evals[0].getNumber() > evals[1].getNumber() ? 1.0f : 0.0f);
                return this.evalCache[0];
            }
            case LESS: {
                this.evalCache[0] = new DataValueFloat(evals[0].getNumber() < evals[1].getNumber() ? 1.0f : 0.0f);
                return this.evalCache[0];
            }
            case GEQUAL: {
                this.evalCache[0] = new DataValueFloat(evals[0].getNumber() >= evals[1].getNumber() ? 1.0f : 0.0f);
                return this.evalCache[0];
            }
            case LEQUAL: {
                this.evalCache[0] = new DataValueFloat(evals[0].getNumber() <= evals[1].getNumber() ? 1.0f : 0.0f);
                return this.evalCache[0];
            }
            case CLAMP: {
                this.evalCache[0] = new DataValueFloat(MathHelper.func_76131_a((float)evals[0].getNumber(), (float)evals[1].getNumber(), (float)evals[2].getNumber()));
                return this.evalCache[0];
            }
        }
        this.evalCache[0] = null;
        return null;
    }

    public NodeMath setData(Operation op) {
        this.setOperation(op);
        return this;
    }

    public void setOperation(Operation op) {
        this.op = op;
        for (NodeConnection c : this.inputs) {
            c.removeConnection();
        }
        this.inputs.clear();
        String s1 = "Input 1";
        String s2 = "Input 2";
        switch (op) {
            case ADD: 
            case SUB: 
            case MULT: 
            case DIV: 
            case MOD: 
            case POW: 
            case LOG: 
            case EQUAL: 
            case GREATER: 
            case LESS: 
            case GEQUAL: 
            case LEQUAL: {
                if (op == Operation.POW) {
                    s1 = "Base";
                    s2 = "Exponent";
                } else if (op == Operation.LOG) {
                    s1 = "Value";
                    s2 = "Base";
                }
                this.inputs.add(new NodeConnection(s1, this, this.inputs.size(), true, DataValue.DataType.NUMBER, new DataValueFloat(0.0f)));
                this.inputs.add(new NodeConnection(s2, this, this.inputs.size(), true, DataValue.DataType.NUMBER, new DataValueFloat(0.0f)));
                break;
            }
            case EXP: 
            case SQRT: 
            case ABS: {
                this.inputs.add(new NodeConnection("Input", this, this.inputs.size(), true, DataValue.DataType.NUMBER, new DataValueFloat(0.0f)));
                break;
            }
            case CLAMP: {
                this.inputs.add(new NodeConnection("Value", this, this.inputs.size(), true, DataValue.DataType.NUMBER, new DataValueFloat(0.0f)));
                this.inputs.add(new NodeConnection("Min", this, this.inputs.size(), true, DataValue.DataType.NUMBER, new DataValueFloat(0.0f)));
                this.inputs.add(new NodeConnection("Max", this, this.inputs.size(), true, DataValue.DataType.NUMBER, new DataValueFloat(0.0f)));
            }
        }
        this.recalcSize();
    }

    @Override
    public NodeType getType() {
        return NodeType.MATH;
    }

    @Override
    public String getDisplayName() {
        return this.op.name;
    }

    public static enum Operation {
        ADD("Add"),
        SUB("Subtract"),
        MULT("Multiply"),
        DIV("Divide"),
        MOD("Modulo"),
        POW("Power"),
        LOG("Logarithm"),
        EXP("Exponent"),
        SQRT("Square root"),
        ABS("Absolute"),
        EQUAL("Equal"),
        GREATER("Greater"),
        LESS("Less"),
        GEQUAL("Greater/equal"),
        LEQUAL("Less/equal"),
        CLAMP("Clamp");

        public String name;

        private Operation(String name) {
            this.name = name;
        }

        public static Operation getByName(String name) {
            for (Operation o : Operation.values()) {
                if (!o.name.equals(name)) continue;
                return o;
            }
            return null;
        }
    }
}

