/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon;

import com.google.common.collect.ImmutableList;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tschipp.carryon.common.CommonProxy;
import tschipp.carryon.common.command.CommandCarryOn;
import tschipp.carryon.common.command.CommandCarryOnReload;
import tschipp.carryon.common.handler.ListHandler;
import tschipp.carryon.common.handler.ModelOverridesHandler;

@Mod.EventBusSubscriber
@Mod(modid="carryon", name="Carry On", version="1.12.3", guiFactory="tschipp.carryon.client.gui.GuiFactoryCarryOn", dependencies="required-after:forge@[13.20.1.2386,);after:gamestages;", updateJSON="https://gist.githubusercontent.com/Tschipp/dccadee7c90d7a34e6e76a35d9d6fa2e/raw/", acceptedMinecraftVersions="[1.12.2,1.13)", certificateFingerprint="fd21553434f4905f2f73ea7838147ac4ea07bd88")
public class CarryOn {
    @SidedProxy(clientSide="tschipp.carryon.client.ClientProxy", serverSide="tschipp.carryon.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="carryon")
    public static CarryOn instance;
    public static final String MODID = "carryon";
    public static final String VERSION = "1.12.3";
    public static final String NAME = "Carry On";
    public static final String ACCEPTED_VERSIONS = "[1.12.2,1.13)";
    public static final String UPDATE_JSON = "https://gist.githubusercontent.com/Tschipp/dccadee7c90d7a34e6e76a35d9d6fa2e/raw/";
    public static final Logger LOGGER;
    public static final String DEPENDENCIES = "required-after:forge@[13.20.1.2386,);after:gamestages;";
    public static final String CERTIFICATE_FINGERPRINT = "fd21553434f4905f2f73ea7838147ac4ea07bd88";
    public static File CONFIGURATION_FILE;
    public static boolean FINGERPRINT_VIOLATED;
    public static SimpleNetworkWrapper network;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCarryOn());
        event.registerServerCommand((ICommand)new CommandCarryOnReload());
    }

    @Mod.EventHandler
    public void imcEvent(FMLInterModComms.IMCEvent event) {
        ImmutableList messages = event.getMessages();
        messages.forEach(msg -> {
            String method = msg.key;
            String str = msg.getStringValue();
            switch (method) {
                case "blacklistBlock": {
                    ListHandler.FORBIDDEN_TILES.add(str);
                    break;
                }
                case "blacklistEntity": {
                    ListHandler.FORBIDDEN_ENTITIES.add(str);
                    break;
                }
                case "whitelistBlock": {
                    ListHandler.ALLOWED_TILES.add(str);
                    break;
                }
                case "whitelistEntity": {
                    ListHandler.ALLOWED_ENTITIES.add(str);
                    break;
                }
                case "blacklistStacking": {
                    ListHandler.FORBIDDEN_STACKING.add(str);
                    break;
                }
                case "whitelistStacking": {
                    ListHandler.ALLOWED_STACKING.add(str);
                    break;
                }
                case "addModelOverride": {
                    ModelOverridesHandler.parseOverride(str, 0);
                }
            }
        });
    }

    static {
        LOGGER = LogManager.getFormatterLogger((String)"CarryOn");
        FINGERPRINT_VIOLATED = false;
    }
}

