/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.common.FloatBounds;
import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.api.IEmitter;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.ForgeEmitter;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public class Emitter
extends SourceBase
implements IEmitter {
    private final ForgeEmitter emitter;
    private final float fuelConsumptionRate;

    public Emitter(UnitConfig config, UnitId id, KeyValuePair identityTag, boolean isEntity, String activeStateTag, boolean useDroppedItemMeta, String[] relatedBlocks, Emissions emissions, float fuelConsumptionRate) {
        super(config, id, emissions);
        this.emitter = new ForgeEmitter(config, id, identityTag, isEntity, activeStateTag, useDroppedItemMeta, relatedBlocks){

            public String getClassCategory() {
                return Emitter.this.getClassCategory();
            }

            public Set<BlockState> getRelatedBlocks() {
                return this.relatedBlocks;
            }
        };
        this.fuelConsumptionRate = UnitConfig.getFloat((ForgeConfig)config, (String)this.getClassCategory(), (String)"fuelConsumptionRate", (float)fuelConsumptionRate, (FloatBounds)FloatBounds.from((Float)Float.valueOf(0.0f), (Float)Float.valueOf(10.0f)), (String)"Defines the fuel consumption rate for this emitter. Actual only for emitters with a hardcoded fuel consumption hook.");
    }

    public boolean isActive(INBTSerializable<NBTTagCompound> nbtSource) {
        try {
            return super.isActive(nbtSource);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isEntity(SourceBase source) {
        return source instanceof Emitter && ((Emitter)source).isEntity();
    }

    public String getClassCategory() {
        return IHaveConfig.getClassCategory(Emitter.class);
    }

    public String getActiveStateTag() {
        return this.emitter.getActiveStateTag();
    }

    public KeyValuePair getIdentityTag() {
        return this.emitter.getIdentityTag();
    }

    public boolean isEntity() {
        return this.emitter.isEntity();
    }

    public boolean useDroppedItemMeta() {
        return this.emitter.useDroppedItemMeta();
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        this.emitter.onPostInit(event);
    }

    public Set<BlockState> getRelatedBlocks() {
        return this.emitter.getRelatedBlocks();
    }

    public boolean hasSeparateRateControl() {
        return false;
    }

    public float getFuelConsumptionRate(INBTSerializable<NBTTagCompound> nbtSource) {
        return this.fuelConsumptionRate;
    }
}

