/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.SourceLiving;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AnimalFeeding
extends SourceLiving<EntityAnimal> {
    public AnimalFeeding(UnitConfig config) {
        super(config, UnitId.EMPTY, Emissions.of().carbon(0.2f));
    }

    public void emitFrom(EntityAnimal animal, ItemStack food) {
        World world = animal.func_130014_f_();
        if (this.isEnabled() && ForgeWorld.isServerSide((World)world)) {
            Fuel fuel = Main.getFuels().findBy(food);
            if (fuel != null) {
                BlockPos pos = this.getOutletPosition(animal);
                fuel.emitAt(world, pos);
            } else {
                this.emitFrom(animal, 1.0f);
            }
        }
    }
}

