/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.GasEmission;
import com.endertech.minecraft.mods.adpother.pollution.GasChain;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GasExplosion {
    public static int maxChainLength = 512;
    protected World world;
    protected Iterable<BlockPos> positions = Collections.emptyList();
    protected Consumer<? super GasChain> action = chain -> {};

    protected GasExplosion(World world) {
        this.world = world;
    }

    public static GasExplosion in(World world) {
        return new GasExplosion(world);
    }

    public GasExplosion position(BlockPos position) {
        return this.positions(Collections.singleton(position));
    }

    public GasExplosion positions(Iterable<BlockPos> positions) {
        this.positions = positions;
        return this;
    }

    public GasExplosion action(Consumer<? super GasChain> action) {
        this.action = action;
        return this;
    }

    public boolean tryTrigger() {
        for (BlockPos pos : this.positions) {
            GasEmission gas;
            IBlockState state = this.world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!(block instanceof GasEmission) || (gas = (GasEmission)block).getLowerExplosiveLimit() <= 0 || gas.affectsPollutionLevel(this.world, pos, state)) continue;
            GasChain chain = new GasChain(this.world, pos, gas, gas.getLowerExplosiveLimit());
            chain.build();
            if (chain.getFound().size() < gas.getLowerExplosiveLimit()) continue;
            this.action.accept(chain);
            return true;
        }
        return false;
    }

    public boolean tryExplode() {
        return this.action(GasExplosion::explode).tryTrigger();
    }

    public static void explode(GasChain fuseChain) {
        World world = fuseChain.getWorld();
        GasChain fullChain = new GasChain(world, fuseChain.getStartPos(), fuseChain.getGas(), maxChainLength);
        fullChain.build();
        int maxExplosions = (int)Math.max(1.0, CommonMath.raiseToPower((double)fullChain.length(), (double)0.3333333333333333));
        int maxExplosionSize = (int)Math.sqrt(fullChain.length());
        int step = Math.max(1, fullChain.length() / maxExplosions);
        HashMap<BlockPos, Float> explosions = new HashMap<BlockPos, Float>(maxExplosions + 1, 1.0f);
        for (int i = 0; i < fullChain.length(); i += step) {
            float explosionSize = 0.0f;
            BlockPos centerPos = (BlockPos)fullChain.getChain().get(i);
            for (BlockPos pos2 : ForgeWorld.Position.getAroundHoriz((BlockPos)centerPos, (boolean)false, (BlockPos[])new BlockPos[]{centerPos.func_177984_a(), centerPos.func_177977_b(), centerPos})) {
                IBlockState state = world.func_180495_p(pos2);
                if (!((explosionSize += (float)fullChain.getGas().getCarriedPollutionAmount(state)) >= (float)maxExplosionSize)) continue;
                explosionSize = maxExplosionSize;
                break;
            }
            if (!(explosionSize > 0.0f)) continue;
            explosions.put(centerPos, Float.valueOf(explosionSize));
        }
        fullChain.getChain().forEach(pos -> world.func_175698_g(pos));
        explosions.forEach((pos, size) -> ForgeWorld.scheduleBlockExplosion((World)world, (BlockPos)pos, (CommonTime.Interval)CommonTime.Interval.ZERO, (float)size.floatValue(), (boolean)true, (boolean)false, null));
    }

    public static GasExplosion fromHeldTorch(EntityPlayer player) {
        GasExplosion explosion = GasExplosion.in(player.func_130014_f_());
        Set<EnumHand> hands = GasExplosion.getTorchHoldingHands(player);
        return hands.isEmpty() ? explosion : explosion.positions(GasExplosion.getIgnitablePositionsAround(player, hands));
    }

    public static List<BlockPos> getIgnitablePositionsAround(EntityPlayer player, Set<EnumHand> hands) {
        EnumFacing face = player.func_174811_aO();
        BlockPos eyes = ForgeEntity.getPositionEyes((Entity)player);
        BlockPos body = eyes.func_177977_b();
        ArrayList positions = Lists.newArrayList((Object[])new BlockPos[]{eyes.func_177984_a(), eyes.func_177972_a(face), body.func_177972_a(face)});
        for (EnumHand hand : hands) {
            EnumFacing facing = hand == EnumHand.MAIN_HAND ? face.func_176746_e() : face.func_176735_f();
            positions.add(eyes.func_177972_a(facing));
            positions.add(body.func_177972_a(facing));
        }
        positions.add(eyes);
        positions.add(body);
        return positions;
    }

    public static Set<EnumHand> getTorchHoldingHands(EntityPlayer player) {
        EnumSet<EnumHand> hands = EnumSet.noneOf(EnumHand.class);
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            Torch torch = (Torch)Main.getTorches().findBy(stack);
            if (torch == null) continue;
            hands.add(hand);
        }
        return hands;
    }
}

