/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.Fluid;

public class Fuels
extends RelatedUnitsInit<Fuel, BuiltInFuels> {
    protected final Map<String, Fuel> fluids = new ConcurrentHashMap<String, Fuel>();

    public Fuels(ForgeMod mod) {
        super(mod, BuiltInFuels.class);
    }

    public Fuel createCustomUnitFrom(UnitConfig config, String name) {
        boolean liquid = name.startsWith("fluid$");
        return new Fuel(config, UnitId.EMPTY, Emissions.of(), liquid);
    }

    public Fuel createDefaultUnitFrom(UnitConfig config, BuiltInFuels e) {
        boolean liquid = e.id.getModId().equals("fluid");
        return new Fuel(config, e.id, e.emissions, liquid);
    }

    public static Optional<Emissions> defaultEmissionsFor(ItemStack stack) {
        int burnTime = TileEntityFurnace.func_145952_a((ItemStack)stack);
        if (burnTime > 0) {
            double carbon = (double)burnTime / 2000.0;
            double sulfur = carbon / 10.0;
            Emissions emissions = Emissions.of().carbon((float)carbon).sulfur((float)sulfur);
            return Optional.of(emissions);
        }
        return Optional.empty();
    }

    @Nullable
    public Fuel findBy(ItemStack stack) {
        Optional<Emissions> emissions;
        Fuel fuel = (Fuel)super.findBy(stack);
        if (fuel == null && (emissions = Fuels.defaultEmissionsFor(stack)).isPresent()) {
            fuel = new Fuel(null, UnitId.EMPTY, emissions.get(), false);
        }
        return fuel;
    }

    public Fuel findBy(Fluid fluid) {
        return this.fluids.get(fluid.getName());
    }

    protected void clearAttachedStates() {
        super.clearAttachedStates();
        this.fluids.clear();
    }

    protected void attachToStates() {
        super.attachToStates();
        for (Fuel fuel : this.getAll()) {
            if (!fuel.isLiquid()) continue;
            UnitId id = fuel.getRelatedId();
            this.fluids.put(id.getRegName(), fuel);
        }
    }

    static enum BuiltInFuels implements IForgeEnum
    {
        fluid$benzene(7.62, Percentage.value((float)0.0f)),
        fluid$bio_diesel(4.18, Percentage.value((float)10.0f)),
        fluid$biodiesel(4.18, Percentage.value((float)10.0f)),
        fluid$biofuel(1.52, Percentage.value((float)0.0f)),
        fluid$biogas(2.32, Percentage.value((float)10.0f)),
        fluid$biomass(1.52, Percentage.value((float)0.0f)),
        fluid$butadiene(5.08, Percentage.value((float)0.0f)),
        fluid$butane(5.08, Percentage.value((float)0.0f)),
        fluid$butene(5.08, Percentage.value((float)0.0f)),
        fluid$carbon_monoxide(1.27, Percentage.value((float)0.0f)),
        fluid$coal_tar(5.26, Percentage.value((float)10.0f)),
        fluid$coal_tar_oil(5.1, Percentage.value((float)10.0f)),
        fluid$creosote(5.1, Percentage.value((float)10.0f)),
        fluid$crude_oil(11.17, Percentage.value((float)40.0f)),
        fluid$dense_hydrazine_fuel_mixture(14.0, Percentage.value((float)15.0f)),
        fluid$diesel(4.46, Percentage.value((float)5.0f)),
        fluid$ethane(2.54, Percentage.value((float)0.0f)),
        fluid$ethanol(2.54, Percentage.value((float)10.0f)),
        fluid$ethylene(2.54, Percentage.value((float)0.0f)),
        fluid$fish_oil(0.4, Percentage.value((float)0.0f)),
        fluid$fuel(4.0, Percentage.value((float)10.0f)),
        fluid$fuelium(20.0, Percentage.value((float)10.0f)),
        fluid$gas(2.32, Percentage.value((float)10.0f)),
        fluid$gasoline(4.06, Percentage.value((float)3.0f)),
        fluid$heatingoil(5.59, Percentage.value((float)40.0f)),
        fluid$heavy_fuel(6.3, Percentage.value((float)10.0f)),
        fluid$heavyoil(21.68, Percentage.value((float)40.0f)),
        fluid$high_octane(3.69, Percentage.value((float)1.5f)),
        fluid$hotoil(5.59, Percentage.value((float)40.0f)),
        fluid$kerosene(4.12, Percentage.value((float)10.0f)),
        fluid$lava(4.0, Percentage.value((float)10.0f)),
        fluid$light_fuel(5.57, Percentage.value((float)10.0f)),
        fluid$lightoil(5.34, Percentage.value((float)40.0f)),
        fluid$liquidethene(2.54, Percentage.value((float)0.0f)),
        fluid$lpg(1.05, Percentage.value((float)0.0f)),
        fluid$methane(1.27, Percentage.value((float)0.0f)),
        fluid$methanol(1.27, Percentage.value((float)10.0f)),
        fluid$naphtha(2.32, Percentage.value((float)10.0f)),
        fluid$natural_gas(2.32, Percentage.value((float)10.0f)),
        fluid$nitan(4.0, Percentage.value((float)10.0f)),
        fluid$nitro_fuel(4.0, Percentage.value((float)2.5f)),
        fluid$obsidian(1.0, Percentage.value((float)10.0f)),
        fluid$octane(10.16, Percentage.value((float)4.0f)),
        fluid$oil(11.17, Percentage.value((float)40.0f)),
        fluid$oil_heavy(16.0, Percentage.value((float)40.0f)),
        fluid$oil_light(5.34, Percentage.value((float)40.0f)),
        fluid$oil_medium(5.59, Percentage.value((float)40.0f)),
        fluid$petroil(4.06, Percentage.value((float)3.0f)),
        fluid$petrol(4.06, Percentage.value((float)3.0f)),
        fluid$petroleum(11.17, Percentage.value((float)40.0f)),
        fluid$petrolium(11.17, Percentage.value((float)40.0f)),
        fluid$phenol(7.62, Percentage.value((float)0.0f)),
        fluid$plant_oil(0.4, Percentage.value((float)0.0f)),
        fluid$propane(3.81, Percentage.value((float)0.0f)),
        fluid$propene(3.81, Percentage.value((float)0.0f)),
        fluid$protein_if("fluid:if.protein", 3.04, 0.0),
        fluid$reclaimed(5.59, Percentage.value((float)40.0f)),
        fluid$refinery_gas(2.32, Percentage.value((float)0.0f)),
        fluid$rocketfuel(28.0, Percentage.value((float)15.0f)),
        fluid$rocket_fuel(4.0, Percentage.value((float)15.0f)),
        fluid$rocket_fuel_a(14.0, Percentage.value((float)5.0f)),
        fluid$rocket_fuel_b(14.0, Percentage.value((float)10.0f)),
        fluid$rocket_fuel_c(14.0, Percentage.value((float)20.0f)),
        fluid$seed_oil(0.4, Percentage.value((float)0.0f)),
        fluid$smear(5.1, Percentage.value((float)40.0f)),
        fluid$sulfuric_coal_tar_oil(5.1, Percentage.value((float)40.0f)),
        fluid$sulfuric_gas(2.32, Percentage.value((float)40.0f)),
        fluid$sulfuric_heavy_fuel(6.3, Percentage.value((float)40.0f)),
        fluid$sulfuric_light_fuel(5.57, Percentage.value((float)40.0f)),
        fluid$sulfuric_naphtha(2.32, Percentage.value((float)40.0f)),
        fluid$toluene(8.89, Percentage.value((float)10.0f)),
        fluid$wood_gas(1.27, Percentage.value((float)0.0f)),
        armor_stand(0.3),
        arrow(0.05),
        acacia_boat(0.2),
        banner(0.15),
        birch_boat(0.2),
        blaze_rod("rodBlaze", 1.2, 0.6),
        blaze_powder("dustBlaze", 0.6, 0.3),
        bed("bedAny", 0.75),
        boat(0.2),
        book(0.5),
        bookshelf(0.15),
        bow(0.15),
        bowl(0.05),
        brown_mushroom(0.05),
        cactus("blockCactus", 0.15),
        carpet(0.0335),
        carrot_on_a_stick(0.15),
        charcoal(0.8),
        charcoal_block("blockCharcoal", 8.0),
        chest(0.15),
        chorus_plant(0.3),
        chorus_flower(0.3),
        coal(0.8),
        coal_block("blockCoal", 8.0),
        coke_block("blockCoke", 16.0),
        crafting_table(0.15),
        dark_oak_boat(0.2),
        daylight_detector(0.15),
        deadbush(0.1),
        door("doorWood", 0.15),
        double_plant(0.1),
        dragon_breath(1.05, 0.525),
        farm_ender(0.15),
        feather("feather", 0.05),
        fence("fenceWood", 0.15),
        fence_gate("fenceGateWood", 0.15),
        fire_charge(0.75, 0.325),
        fireworks(2.55),
        firework_charge(1.2, 0.6),
        fishing_rod(0.1),
        ghast_tear(1.0, 0.5),
        grass("grass", 0.1),
        gunpowder("gunpowder", 0.8, 0.4),
        hay_block(0.45),
        item_frame(0.45),
        jukebox(0.15),
        jungle_boat(0.2),
        ladder(0.15),
        lava_bucket(10.0, 10.0),
        lava(0.02, 0.01),
        lever(0.05),
        magma_cream(1.0, 0.5),
        map(1.25),
        noteblock(0.15),
        nether_star("netherStar", 50.0, 25.0),
        painting(0.5),
        paper("paper", 0.15),
        piston("craftingPiston", 0.5),
        poisonous_potato(0.05),
        rail(0.05),
        reeds("sugarcane", 0.05),
        red_flower(0.05),
        red_mushroom(0.05),
        redstone_torch(0.05),
        rotten_flesh(0.1, 0.3),
        saplings("treeSapling", 0.05),
        seeds("seed", 0.05),
        shield(0.9),
        sign(0.35),
        spider_eye(0.05),
        spruce_boat(0.2),
        stick(0.05),
        tallgrass(0.1),
        tnt("industrialTnt", 4.05, 2.025),
        tnt_minecart(4.1, 2.05),
        torch("torch", 0.05),
        trapdoor(0.15),
        trapped_chest(0.15),
        tree_leaves("treeLeaves", 0.15),
        tripwire_hook(0.1),
        vine(0.05),
        waterlily(0.05),
        web(0.1),
        wheat("cropWheat", 0.05),
        wood("logWood", 0.15),
        wood_planks("plankWood", 0.15),
        wood_slabs("slabWood", 0.075),
        wooden_axe(0.1),
        wooden_button(0.05),
        wooden_door(0.1),
        wooden_hoe(0.1),
        wooden_pickaxe(0.1),
        wooden_pressure_plate(0.15),
        wooden_shovel(0.1),
        wooden_stairs("stairWood", 0.15),
        wooden_sword(0.1),
        wool(0.05),
        writable_book(0.55),
        written_book(0.55),
        yellow_flower(0.05),
        beef(0.05),
        chicken(0.05),
        fish(0.05),
        mutton(0.05),
        porkchop(0.05),
        potato(0.035),
        rabbit(0.05),
        sulfur_dust("dustSulfur", 0.08, 0.8),
        actuallyadditions$tiny_coal("actuallyadditions:item_misc:10", 0.4, 0.04),
        actuallyadditions$tiny_charcoal("actuallyadditions:item_misc:11", 0.4, 0.04),
        actuallyadditions$tiny_biocoal("actuallyadditions:item_misc:22", 0.1, 0.01),
        actuallyadditions$tiny_dustcoal("actuallyadditions:item_dust:6", 0.7, 0.07),
        advancedrocketry$charcoallog(0.15),
        betterwithmods$bark("barkWood", 0.05, 0.0025),
        betterwithmods$nether_coal("betterwithmods:material:1", 1.6, 0.1),
        betterwithmods$saw_dust("betterwithmods:material:22", 0.05, 0.0025),
        calculator$coaldust(0.5, 0.05),
        calculator$enrichedcoal(2.5, 0.25),
        calculator$purifiedcoal(5.0, 0.5),
        calculator$firecoal(12.5, 1.25),
        calculator$firediamond(0.4, 0.8),
        evilcraft$blood_waxed_coal(1.6, 0.16),
        evilcraft$blood_waxed_coal_block(16.0, 1.6),
        extrautils2$red_coal("coalPowered", 0.8, 0.1),
        forestry$apiary(0.15),
        forestry$bee_chest(0.15),
        forestry$bee_house(0.15),
        forestry$pollen_fertile(0.05),
        forestry$wood_pile(0.6),
        forestry$wood_pile_decorative(0.6),
        galacticraftcore$fuel(0.1),
        harvestcraft$beeswaxitem(0.4, 0.04),
        harvestcraft$pressedwax(4.0, 0.4),
        hbm$lignite(0.6),
        hbm$briquette_lignite(0.8),
        hbm$powder_lignite(0.6),
        mekanism$biofuel(0.15, 0.0),
        mysticalagriculture$inferium_coal("coalInferium", 1.2, 0.12),
        mysticalagriculture$inferium_coal_block("blockInferiumCoal", 12.0, 1.2),
        mysticalagriculture$prudentium_coal("coalPrudentium", 2.4, 0.24),
        mysticalagriculture$prudentium_coal_block("blockPrudentiumCoal", 24.0, 2.4),
        mysticalagriculture$intermedium_coal("coalIntermedium", 4.8, 0.48),
        mysticalagriculture$intermedium_coal_block("blockIntermediumCoal", 48.0, 4.8),
        mysticalagriculture$superium_coal("coalSuperium", 9.6, 0.96),
        mysticalagriculture$superium_coal_block("blockSuperiumCoal", 96.0, 9.6),
        mysticalagriculture$supremium_coal("coalSupremium", 19.2, 1.92),
        mysticalagriculture$supremium_coal_block("blockSupremiumCoal", 192.0, 19.2),
        morefuelsmod$coke(0.8),
        morefuelsmod$block_coke(14.4),
        morefuelsmod$bituminous_coal(0.8),
        morefuelsmod$block_bituminous_coal(7.2),
        morefuelsmod$pellet_fuel(0.45),
        morefuelsmod$block_pellet_fuel(4.05),
        morefuelsmod$compressed_pellet_fuel(16.2),
        morefuelsmod$block_compressed_pellet_fuel(145.8),
        morefuelsmod$can_of_slimoline(10.0),
        immersiveengineering$coal_coke("fuelCoke", 1.6, 0.16),
        immersiveengineering$coal_coke_block("blockFuelCoke", 16.0, 1.6),
        primal$charcoal_mote(0.1, 0.01),
        primal$charcoal_fair(0.8, 0.08),
        primal$charcoal_good(1.0, 0.1),
        primal$charcoal_high(1.2, 0.12),
        primal$logs_stacked("logStacked", 0.5, 0.025),
        primal$logs_split("logSplit", 0.1, 0.005),
        pytotech$rock_wood_chips("pyrotech:rock:7", 0.1, 0.005),
        pyrotech$log_pile(5.0, 0.25),
        pyrotech$thatch(0.2, 0.01),
        pyrotech$planks_tarred(1.2, 0.06),
        pyrotech$pile_wood_chips(1.2, 0.06),
        pyrotech$wool_tarred(1.6, 0.08),
        pyrotech$charcoal_block(8.0, 0.8),
        pyrotech$wood_tar_block(8.0, 0.8),
        pyrotech$living_tar(16.0, 1.6),
        pyrotech$coal_coke("pyrotech:material:1", 1.6, 0.16),
        pytotech$straw("pyrotech:material:2", 0.05, 0.0025),
        pytotech$plant_fibers("pyrotech:material:13", 0.025, 0.0025),
        pytotech$charcoal_flakes("pyrotech:material:15", 0.1, 0.01),
        pytotech$board("pyrotech:material:20", 0.2, 0.01),
        pytotech$coal_pieces("pyrotech:material:21", 0.1, 0.01),
        pytotech$board_tarred("pyrotech:material:23", 0.4, 0.02),
        pytotech$kindling("pyrotech:material:29", 1.2, 0.06),
        pytotech$kindling_tarred("pyrotech:material:30", 2.4, 0.12),
        pytotech$burned_food(0.1, 0.005),
        pytotech$tinder(0.12, 0.006),
        rockhounding_oretiers$anthracite_block("rockhounding_oretiers:coal_blocks:0", 14.4, 1.44),
        rockhounding_oretiers$bituminous_coal_block("rockhounding_oretiers:coal_blocks:1", 10.8, 1.08),
        rockhounding_oretiers$lignite_block("rockhounding_oretiers:coal_blocks:2", 4.5, 0.45),
        rockhounding_oretiers$peat_block("rockhounding_oretiers:coal_blocks:3", 1.6, 0.16),
        rockhounding_oretiers$charcoal_block("rockhounding_oretiers:coal_blocks:4", 2.7, 0.27),
        rockhounding_oretiers$anthracite("rockhounding_oretiers:tier_items:0", 1.6, 0.16),
        rockhounding_oretiers$bituminous_coal("rockhounding_oretiers:tier_items:1", 1.2, 0.12),
        rockhounding_oretiers$lignite("rockhounding_oretiers:tier_items:2", 0.5, 0.05),
        rockhounding_oretiers$moist_peat("rockhounding_oretiers:tier_items:3", 0.05, 0.005),
        rockhounding_oretiers$charcoal_lump("rockhounding_oretiers:tier_items:4", 0.3, 0.03),
        rockhounding_oretiers$coal_pellet("rockhounding_oretiers:tier_items:5", 0.1, 0.01),
        rockhounding_oretiers$dry_peat("rockhounding_oretiers:tier_items:6", 0.2, 0.02),
        tfc$peat(0.8),
        viescraft$viesoline_pellets("vc:item_viesoline_pellets:*", 0.8, 0.16);

        public final UnitId id;
        public final Emissions emissions;

        private BuiltInFuels(double carbon) {
            this("", carbon);
        }

        private BuiltInFuels(double carbon, Percentage sulfur) {
            this(carbon, carbon * (double)sulfur.toFraction());
        }

        private BuiltInFuels(double carbon, double sulfur) {
            this("", carbon, sulfur);
        }

        private BuiltInFuels(String id, double carbon) {
            this(id, carbon, carbon / 10.0);
        }

        private BuiltInFuels(String id, double carbon, double sulfur) {
            this(id, Emissions.of().carbon((float)carbon).sulfur((float)sulfur));
        }

        private BuiltInFuels(String id, Emissions emissions) {
            this.id = id.isEmpty() ? UnitId.from((Enum)this, (boolean)true) : UnitId.from((String)id);
            this.emissions = emissions;
        }

        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }
    }
}

