/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.config.AbstractParsableList;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class Gregtech {

    static class FuelConsumptionRates
    extends AbstractParsableList {
        protected final Map<String, Float> factorsByMetaId = new HashMap<String, Float>();

        public FuelConsumptionRates(ForgeConfig config, String category, String[] defaultValues) {
            super(config, category, "fuelConsumptionRates", defaultValues);
        }

        @Override
        protected String getComment() {
            return "Fuel consumption rates for machines in the format: metaId, rate";
        }

        @Override
        protected void parseConfigValues() {
            this.factorsByMetaId.clear();
            for (String string : this.configValues) {
                String metaId;
                List<String> split = this.splitArgs(string);
                if (split.size() == 2 && !(metaId = split.get(0)).isEmpty()) {
                    try {
                        Float factor = Float.valueOf(Float.parseFloat(split.get(1)));
                        this.factorsByMetaId.put(metaId, factor);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.logParsingError(string);
            }
        }

        public Optional<Float> getFactor(String metaId) {
            if (!metaId.isEmpty()) {
                for (Map.Entry<String, Float> entry : this.factorsByMetaId.entrySet()) {
                    if (!metaId.contains(entry.getKey())) continue;
                    return Optional.of(entry.getValue());
                }
            }
            return Optional.empty();
        }
    }

    public static class Machine
    extends Emitter {
        protected final FuelConsumptionRates fuelConsumptionRates;

        public Machine(UnitConfig config, UnitId id, String activeTag, String[] relatedBlocks, Emissions emissions, float fuelConsuptionRate) {
            super(config, id, KeyValuePair.from((String)"#hardcoded"), false, activeTag, false, relatedBlocks, emissions, fuelConsuptionRate);
            this.fuelConsumptionRates = new FuelConsumptionRates((ForgeConfig)config, this.getClassCategory(), new String[]{"gregtech:large_turbine.gas, 0.6", "gregtech:large_boiler.bronze, 1.0", "gregtech:large_boiler.steel, 0.8", "gregtech:large_boiler.titanium, 0.6", "gregtech:primitive_blast_furnace, 1.0", "gtadditions:industrial_primitive_blast_furnace, 0.8", "gtadditions:large_turbine.gas, 0.6", "gtadditions:diesel_engine, 0.6", "gtadditions:large_rocket_engine, 0.6"});
            this.fuelConsumptionRates.loadData();
        }

        public boolean isIdentified(@Nullable INBTSerializable<NBTTagCompound> nbtSource) {
            if (nbtSource == null) {
                return false;
            }
            String metaId = this.getMetaId(nbtSource);
            return !metaId.contains("solar");
        }

        @Override
        public boolean isActive(@Nullable INBTSerializable<NBTTagCompound> nbtSource) {
            if (nbtSource == null) {
                return false;
            }
            NBTTagCompound compound = (NBTTagCompound)nbtSource.serializeNBT();
            NBTTagCompound metaTag = ForgeNBT.getNestedCompound((NBTTagCompound)compound, (String)"MetaTileEntity");
            int fuelLeft = metaTag != null ? metaTag.func_74762_e("FuelBurnTimeLeft") : 0;
            return fuelLeft > 0;
        }

        protected String getMetaId(@Nullable INBTSerializable<NBTTagCompound> nbtSource) {
            if (nbtSource == null) {
                return "";
            }
            NBTTagCompound compound = (NBTTagCompound)nbtSource.serializeNBT();
            String metaId = compound.func_74779_i("MetaId");
            return metaId;
        }

        @Override
        public float getFuelConsumptionRate(@Nullable INBTSerializable<NBTTagCompound> nbtSource) {
            String metaId = this.getMetaId(nbtSource);
            Optional<Float> factor = this.fuelConsumptionRates.getFactor(metaId);
            return factor.isPresent() ? factor.get().floatValue() : super.getFuelConsumptionRate(nbtSource);
        }
    }
}

