/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.roadfactory;

import com.silvaniastudios.roads.blocks.tileentities.RoadTEBlock;
import com.silvaniastudios.roads.blocks.tileentities.roadfactory.RoadFactoryElectricEntity;
import com.silvaniastudios.roads.blocks.tileentities.roadfactory.RoadFactoryEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class RoadFactoryBlock
extends RoadTEBlock {
    public static final PropertyBool FLUID_LEFT = PropertyBool.func_177716_a((String)"fluid_left");
    public static final PropertyBool FLUID_UP = PropertyBool.func_177716_a((String)"fluid_up");

    public RoadFactoryBlock(String name, boolean electric) {
        super(name, electric, 3);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ROTATION, (Comparable)((Object)RoadTEBlock.EnumRotation.north)).func_177226_a((IProperty)FLUID_LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FLUID_UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FURNACE_ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"roads.gui.road_factory.tooltip_1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"roads.gui.road_factory.tooltip_2", (Object[])new Object[0]));
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack held = player.func_184586_b(EnumHand.MAIN_HAND);
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof RoadFactoryEntity) {
            RoadFactoryEntity te = (RoadFactoryEntity)world.func_175625_s(pos);
            if (held.func_77973_b() == Items.field_151133_ar && te.tarFluid.getFluidAmount() >= 1000) {
                if (!player.func_184812_l_()) {
                    if (held.func_190916_E() > 1) {
                        held.func_190920_e(held.func_190916_E() - 1);
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    }
                }
                player.func_191521_c(FluidUtil.getFilledBucket((FluidStack)te.tarFluid.getFluid()));
                te.tarFluid.drain(1000, true);
                te.sendUpdates();
                return true;
            }
            if (held.func_77973_b().func_77658_a().compareTo("item.forge.bucketFilled") == 0) {
                FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)held);
                if (te.tarFluid.getFluidAmount() + 1000 <= 64000) {
                    if (te.tarFluid.getFluidAmount() > 0 && te.tarFluid.getFluid().getFluid() == fluidStack.getFluid() || te.tarFluid.getFluidAmount() == 0) {
                        if (!player.func_184812_l_()) {
                            if (held.func_190916_E() > 1) {
                                held.func_190920_e(held.func_190916_E() - 1);
                            } else {
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                            }
                            player.func_191521_c(new ItemStack(Items.field_151133_ar));
                        }
                        if (te.tarFluid.getFluidAmount() > 0) {
                            te.tarFluid.fill(fluidStack, true);
                        } else {
                            te.tarFluid.setFluid(fluidStack);
                        }
                    }
                    te.sendUpdates();
                    return true;
                }
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        if (this.electric) {
            return new RoadFactoryElectricEntity();
        }
        return new RoadFactoryEntity();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing left = EnumFacing.WEST;
        EnumFacing right = EnumFacing.EAST;
        if (this.func_176201_c(state) == 1) {
            left = EnumFacing.NORTH;
            right = EnumFacing.SOUTH;
        }
        if (this.func_176201_c(state) == 2) {
            left = EnumFacing.EAST;
            right = EnumFacing.WEST;
        }
        if (this.func_176201_c(state) == 3) {
            left = EnumFacing.SOUTH;
            right = EnumFacing.NORTH;
        }
        boolean fluid_left = this.fluidLeft(world, pos, left, right);
        boolean fluid_up = this.fluidTop(world, pos);
        return state.func_177226_a((IProperty)FLUID_LEFT, (Comparable)Boolean.valueOf(fluid_left)).func_177226_a((IProperty)FLUID_UP, (Comparable)Boolean.valueOf(fluid_up)).func_177226_a((IProperty)FURNACE_ACTIVE, (Comparable)Boolean.valueOf(this.isFurnaceEnabled(state, world, pos))).func_177226_a((IProperty)BASE_PLATE, (Comparable)Boolean.valueOf(this.hasBasePlate(world, pos)));
    }

    private boolean fluidLeft(IBlockAccess world, BlockPos pos, EnumFacing left, EnumFacing right) {
        return world.func_175625_s(pos.func_177972_a(left)) != null && world.func_175625_s(pos.func_177972_a(left)).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, right);
    }

    private boolean fluidTop(IBlockAccess world, BlockPos pos) {
        return world.func_175625_s(pos.func_177972_a(EnumFacing.UP)) != null && (world.func_175625_s(pos.func_177972_a(EnumFacing.UP)).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN) || world.func_175625_s(pos.func_177972_a(EnumFacing.UP)).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        double top;
        EnumFacing left = EnumFacing.WEST;
        EnumFacing right = EnumFacing.EAST;
        int meta = this.func_176201_c(state);
        if (meta == 1) {
            left = EnumFacing.NORTH;
            right = EnumFacing.SOUTH;
        }
        if (meta == 2) {
            left = EnumFacing.EAST;
            right = EnumFacing.WEST;
        }
        if (meta == 3) {
            left = EnumFacing.SOUTH;
            right = EnumFacing.NORTH;
        }
        boolean fluid_left = this.fluidLeft(world, pos, left, right);
        boolean fluid_top = this.fluidTop(world, pos);
        double d = top = fluid_top ? 1.0 : 0.84375;
        if (meta == 0) {
            double l = fluid_left ? 0.0 : 0.0625;
            return new AxisAlignedBB(l, 0.0, 0.0625, 0.9375, top, 0.9375);
        }
        if (meta == 1) {
            double l = fluid_left ? 0.0 : 0.0625;
            return new AxisAlignedBB(0.0625, 0.0, l, 0.9375, top, 0.9375);
        }
        if (meta == 2) {
            double r = fluid_left ? 1.0 : 0.9375;
            return new AxisAlignedBB(0.0625, 0.0, 0.0625, r, top, 0.9375);
        }
        if (meta == 3) {
            double r = fluid_left ? 1.0 : 0.9375;
            return new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, top, r);
        }
        return new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, top, 0.9375);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FLUID_LEFT, FLUID_UP, ROTATION, FURNACE_ACTIVE, BASE_PLATE});
    }
}

