/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.paint;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.PaintColour;
import com.silvaniastudios.roads.blocks.paint.ArrowLinePaintBlock;
import com.silvaniastudios.roads.blocks.paint.PaintBlockCustomRenderBase;
import com.silvaniastudios.roads.blocks.paint.properties.UnlistedPropertyConnection;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class LinePaintBlock
extends PaintBlockCustomRenderBase {
    public static final UnlistedPropertyConnection NORTH = new UnlistedPropertyConnection("north");
    public static final UnlistedPropertyConnection EAST = new UnlistedPropertyConnection("east");
    public static final UnlistedPropertyConnection SOUTH = new UnlistedPropertyConnection("south");
    public static final UnlistedPropertyConnection WEST = new UnlistedPropertyConnection("west");
    public static final PropertyEnum<EnumRotation> FACING = PropertyEnum.func_177709_a((String)"facing", EnumRotation.class);

    public LinePaintBlock(String name, String category, PaintColour colour) {
        super(name, category, new int[]{0, 2}, new boolean[]{false, true}, colour);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)((Object)EnumRotation.ns)));
        this.func_149647_a(FurenikusRoads.tab_paint_lines);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (meta < 2) {
            if (placer.func_174811_aO() == EnumFacing.EAST || placer.func_174811_aO() == EnumFacing.WEST) {
                return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumRotation.ew));
            }
            return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumRotation.ns));
        }
        return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumRotation.connect));
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block instanceof LinePaintBlock || block instanceof ArrowLinePaintBlock;
    }

    private boolean canLineConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos offset = pos.func_177972_a(facing);
        return this.canConnectTo(world, offset, facing.func_176734_d()) || this.canConnectTo(world, offset.func_177972_a(EnumFacing.DOWN), facing.func_176734_d()) || this.canConnectTo(world, offset.func_177972_a(EnumFacing.UP), facing.func_176734_d());
    }

    public int func_176201_c(IBlockState state) {
        if (((EnumRotation)((Object)state.func_177229_b(FACING))).equals((Object)EnumRotation.ns)) {
            return 0;
        }
        if (((EnumRotation)((Object)state.func_177229_b(FACING))).equals((Object)EnumRotation.ew)) {
            return 1;
        }
        return 2;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 0) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumRotation.ns));
        }
        if (meta == 1) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumRotation.ew));
        }
        return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)EnumRotation.connect));
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{FACING};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{NORTH, EAST, WEST, SOUTH};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        boolean n = this.canLineConnectTo(worldIn, pos, EnumFacing.NORTH);
        boolean e = this.canLineConnectTo(worldIn, pos, EnumFacing.EAST);
        boolean s = this.canLineConnectTo(worldIn, pos, EnumFacing.SOUTH);
        boolean w = this.canLineConnectTo(worldIn, pos, EnumFacing.WEST);
        if (state.func_177229_b(FACING) == EnumRotation.ns) {
            n = true;
            s = true;
        }
        if (state.func_177229_b(FACING) == EnumRotation.ew) {
            e = true;
            w = true;
        }
        return extendedBlockState.withProperty((IUnlistedProperty)NORTH, (Object)n).withProperty((IUnlistedProperty)EAST, (Object)e).withProperty((IUnlistedProperty)SOUTH, (Object)s).withProperty((IUnlistedProperty)WEST, (Object)w);
    }

    public static enum EnumRotation implements IStringSerializable
    {
        ns("north_south"),
        ew("east_west"),
        connect("connect");

        private final String name;

        private EnumRotation(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumRotation byMetadata(int meta) {
            if (meta == 0) {
                return ns;
            }
            if (meta == 1) {
                return ew;
            }
            return connect;
        }
    }
}

