/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.diagonal;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.BlockBase;
import com.silvaniastudios.roads.blocks.diagonal.HalfBlock;
import com.silvaniastudios.roads.blocks.diagonal.UnlistedPropertyBlockPos;
import com.silvaniastudios.roads.blocks.diagonal.UnlistedPropertySideBlock;
import com.silvaniastudios.roads.client.BoundingBoxDraw;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RoadBlockDiagonal
extends BlockBase {
    public static final PropertyEnum<EnumFacing> FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool TRANSPARENCY = PropertyBool.func_177716_a((String)"transparency");
    public static final UnlistedPropertySideBlock LEFT = new UnlistedPropertySideBlock("left");
    public static final UnlistedPropertySideBlock RIGHT = new UnlistedPropertySideBlock("right");
    public static final UnlistedPropertyBlockPos POS = new UnlistedPropertyBlockPos("pos");
    private String modelName;
    boolean mirror;
    float minWidth;
    float maxWidth;

    public RoadBlockDiagonal(String name, boolean mirror, String modelName, float minWidth, float maxWidth) {
        super(name, Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TRANSPARENCY, (Comparable)Boolean.valueOf(false)));
        this.mirror = mirror;
        this.func_149647_a(FurenikusRoads.tab_diagonals);
        this.setHarvestLevel("pneumatic_drill", 0);
        this.func_149711_c(1.0f);
        this.modelName = modelName;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("Place other blocks alongside this to use. This block will not appear on its own.");
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        BlockPos left = pos.func_177972_a(placer.func_174811_aO().func_176735_f());
        BlockPos right = pos.func_177972_a(placer.func_174811_aO().func_176746_e());
        IBlockState stateLeft = world.func_180495_p(left);
        IBlockState stateRight = world.func_180495_p(right);
        boolean trans = false;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && (stateLeft.func_177230_c().func_180664_k() == BlockRenderLayer.TRANSLUCENT || stateRight.func_177230_c().func_180664_k() == BlockRenderLayer.TRANSLUCENT)) {
            trans = true;
        }
        return this.func_176223_P().func_177226_a(FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)TRANSPARENCY, (Comparable)Boolean.valueOf(trans));
    }

    public int func_176201_c(IBlockState state) {
        int add;
        int n = add = (Boolean)state.func_177229_b((IProperty)TRANSPARENCY) != false ? 4 : 0;
        if (((EnumFacing)state.func_177229_b(FACING)).equals((Object)EnumFacing.NORTH)) {
            return 0 + add;
        }
        if (((EnumFacing)state.func_177229_b(FACING)).equals((Object)EnumFacing.EAST)) {
            return 1 + add;
        }
        if (((EnumFacing)state.func_177229_b(FACING)).equals((Object)EnumFacing.SOUTH)) {
            return 2 + add;
        }
        if (((EnumFacing)state.func_177229_b(FACING)).equals((Object)EnumFacing.WEST)) {
            return 3 + add;
        }
        return 0 + add;
    }

    public IBlockState func_176203_a(int meta) {
        int m = meta;
        boolean t = false;
        if (meta > 3) {
            m = meta - 4;
            t = true;
        }
        if (m == 0) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TRANSPARENCY, (Comparable)Boolean.valueOf(t));
        }
        if (m == 1) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)TRANSPARENCY, (Comparable)Boolean.valueOf(t));
        }
        if (m == 2) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)TRANSPARENCY, (Comparable)Boolean.valueOf(t));
        }
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)TRANSPARENCY, (Comparable)Boolean.valueOf(t));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        BlockPos left = pos.func_177972_a(((EnumFacing)state.func_177229_b(FACING)).func_176735_f());
        BlockPos right = pos.func_177972_a(((EnumFacing)state.func_177229_b(FACING)).func_176746_e());
        IBlockState stateLeft = worldIn.func_180495_p(left);
        IBlockState stateRight = worldIn.func_180495_p(right);
        boolean trans = false;
        if (stateLeft.func_177230_c().func_180664_k() == BlockRenderLayer.TRANSLUCENT || stateRight.func_177230_c().func_180664_k() == BlockRenderLayer.TRANSLUCENT) {
            trans = true;
        }
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)TRANSPARENCY, (Comparable)Boolean.valueOf(trans)));
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{FACING, TRANSPARENCY};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{LEFT, RIGHT, POS};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        IBlockState l = this.getLeftBlock(state, world, pos);
        IBlockState r = this.getRightBlock(state, world, pos);
        return extendedBlockState.withProperty((IUnlistedProperty)LEFT, (Object)l).withProperty((IUnlistedProperty)RIGHT, (Object)r).withProperty((IUnlistedProperty)POS, (Object)pos);
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getBoxList(pos, worldIn, blockState)) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public ArrayList<AxisAlignedBB> getBoxList(BlockPos pos, World world, IBlockState state) {
        boolean rightFluid;
        boolean leftFluid;
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        EnumFacing facing = (EnumFacing)state.func_177229_b(FACING);
        BlockPos posLeft = pos.func_177972_a(facing.func_176735_f());
        BlockPos posRight = pos.func_177972_a(facing.func_176746_e());
        IBlockState leftState = this.getLeftBlock(state, (IBlockAccess)world, pos);
        IBlockState rightState = this.getRightBlock(state, (IBlockAccess)world, pos);
        double leftHeight = this.getBlockHeight((IBlockAccess)world, leftState, posLeft);
        double rightHeight = this.getBlockHeight((IBlockAccess)world, rightState, posRight);
        boolean bl = leftState != null ? leftState.func_177230_c() instanceof BlockFluidBase || leftState.func_177230_c() instanceof BlockLiquid : (leftFluid = false);
        boolean bl2 = rightState != null ? rightState.func_177230_c() instanceof BlockFluidBase || rightState.func_177230_c() instanceof BlockLiquid : (rightFluid = false);
        if (this.isAir(leftState, (IBlockAccess)world, posLeft) && this.isAir(rightState, (IBlockAccess)world, posRight)) {
            list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
            return list;
        }
        if (this.isAir(leftState, (IBlockAccess)world, posLeft)) {
            leftFluid = true;
        }
        if (this.isAir(rightState, (IBlockAccess)world, posRight)) {
            rightFluid = true;
        }
        if (leftHeight == rightHeight && !leftFluid && !rightFluid) {
            list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, leftHeight, 1.0));
            return list;
        }
        float width = this.maxWidth - this.minWidth;
        float eighth = width / 8.0f;
        float step1 = 1.0f;
        float step2 = 0.75f;
        float step3 = 0.5f;
        float step4 = 0.25f;
        float step = 0.25f;
        if (this.mirror) {
            step1 = 0.25f;
            step2 = 0.5f;
            step3 = 0.75f;
            step4 = 1.0f;
        }
        if (facing.equals((Object)EnumFacing.NORTH)) {
            if (!leftFluid) {
                list.add(new AxisAlignedBB(0.0, 0.0, (double)(step1 - step), (double)this.minWidth + (double)width * 0.25 - (double)eighth, leftHeight, (double)step1));
                list.add(new AxisAlignedBB(0.0, 0.0, (double)(step2 - step), (double)this.minWidth + (double)width * 0.5 - (double)eighth, leftHeight, (double)step2));
                list.add(new AxisAlignedBB(0.0, 0.0, (double)(step3 - step), (double)this.minWidth + (double)width * 0.75 - (double)eighth, leftHeight, (double)step3));
                list.add(new AxisAlignedBB(0.0, 0.0, (double)(step4 - step), (double)(this.minWidth - eighth), leftHeight, (double)step4));
            }
            if (!rightFluid) {
                list.add(new AxisAlignedBB((double)(this.minWidth + eighth), 0.0, (double)(step1 - step), 1.0, rightHeight, (double)step1));
                list.add(new AxisAlignedBB((double)this.minWidth + (double)width * 0.25 + (double)eighth, 0.0, (double)(step2 - step), 1.0, rightHeight, (double)step2));
                list.add(new AxisAlignedBB((double)this.minWidth + (double)width * 0.5 + (double)eighth, 0.0, (double)(step3 - step), 1.0, rightHeight, (double)step3));
                list.add(new AxisAlignedBB((double)this.minWidth + (double)width * 0.75 + (double)eighth, 0.0, (double)(step4 - step), 1.0, rightHeight, (double)step4));
            }
        }
        if (facing.equals((Object)EnumFacing.EAST)) {
            if (!leftFluid) {
                list.add(new AxisAlignedBB((double)(step4 - step), 0.0, 0.0, (double)step4, leftHeight, (double)this.minWidth + (double)width * 0.25 - (double)eighth));
                list.add(new AxisAlignedBB((double)(step3 - step), 0.0, 0.0, (double)step3, leftHeight, (double)this.minWidth + (double)width * 0.5 - (double)eighth));
                list.add(new AxisAlignedBB((double)(step2 - step), 0.0, 0.0, (double)step2, leftHeight, (double)this.minWidth + (double)width * 0.75 - (double)eighth));
                list.add(new AxisAlignedBB((double)(step1 - step), 0.0, 0.0, (double)step1, leftHeight, (double)(this.minWidth - eighth)));
            }
            if (!rightFluid) {
                list.add(new AxisAlignedBB((double)(step4 - step), 0.0, (double)(this.minWidth + eighth), (double)step4, rightHeight, 1.0));
                list.add(new AxisAlignedBB((double)(step3 - step), 0.0, (double)this.minWidth + (double)width * 0.25 + (double)eighth, (double)step3, rightHeight, 1.0));
                list.add(new AxisAlignedBB((double)(step2 - step), 0.0, (double)this.minWidth + (double)width * 0.5 + (double)eighth, (double)step2, rightHeight, 1.0));
                list.add(new AxisAlignedBB((double)(step1 - step), 0.0, (double)this.minWidth + (double)width * 0.75 + (double)eighth, (double)step1, rightHeight, 1.0));
            }
        }
        double h100 = 1.0 - (double)this.maxWidth + ((double)width * 1.0 - (double)eighth);
        double h075 = 1.0 - (double)this.maxWidth + ((double)width * 0.75 - (double)eighth);
        double h050 = 1.0 - (double)this.maxWidth + ((double)width * 0.5 - (double)eighth);
        double h025 = 1.0 - (double)this.maxWidth + ((double)width * 0.25 - (double)eighth);
        if (facing.equals((Object)EnumFacing.SOUTH)) {
            if (!leftFluid) {
                list.add(new AxisAlignedBB(1.0 - (double)(this.minWidth + eighth), 0.0, (double)(step4 - step), 1.0, leftHeight, (double)step4));
                list.add(new AxisAlignedBB(1.0 - ((double)this.minWidth + (double)width * 0.25 + (double)eighth), 0.0, (double)(step3 - step), 1.0, leftHeight, (double)step3));
                list.add(new AxisAlignedBB(1.0 - ((double)this.minWidth + (double)width * 0.5 + (double)eighth), 0.0, (double)(step2 - step), 1.0, leftHeight, (double)step2));
                list.add(new AxisAlignedBB(1.0 - ((double)this.minWidth + (double)width * 0.75 + (double)eighth), 0.0, (double)(step1 - step), 1.0, leftHeight, (double)step1));
            }
            if (!rightFluid) {
                list.add(new AxisAlignedBB(0.0, 0.0, (double)(step4 - step), h100, rightHeight, (double)step4));
                list.add(new AxisAlignedBB(0.0, 0.0, (double)(step3 - step), h075, rightHeight, (double)step3));
                list.add(new AxisAlignedBB(0.0, 0.0, (double)(step2 - step), h050, rightHeight, (double)step2));
                list.add(new AxisAlignedBB(0.0, 0.0, (double)(step1 - step), h025, rightHeight, (double)step1));
            }
        }
        if (facing.equals((Object)EnumFacing.WEST)) {
            if (!leftFluid) {
                list.add(new AxisAlignedBB((double)(step1 - step), 0.0, 1.0 - (double)(this.minWidth + eighth), (double)step1, leftHeight, 1.0));
                list.add(new AxisAlignedBB((double)(step2 - step), 0.0, 1.0 - ((double)this.minWidth + (double)width * 0.25 + (double)eighth), (double)step2, leftHeight, 1.0));
                list.add(new AxisAlignedBB((double)(step3 - step), 0.0, 1.0 - ((double)this.minWidth + (double)width * 0.5 + (double)eighth), (double)step3, leftHeight, 1.0));
                list.add(new AxisAlignedBB((double)(step4 - step), 0.0, 1.0 - ((double)this.minWidth + (double)width * 0.75 + (double)eighth), (double)step4, leftHeight, 1.0));
            }
            if (!rightFluid) {
                list.add(new AxisAlignedBB((double)(step1 - step), 0.0, 0.0, (double)step1, rightHeight, h100));
                list.add(new AxisAlignedBB((double)(step2 - step), 0.0, 0.0, (double)step2, rightHeight, h075));
                list.add(new AxisAlignedBB((double)(step3 - step), 0.0, 0.0, (double)step3, rightHeight, h050));
                list.add(new AxisAlignedBB((double)(step4 - step), 0.0, 0.0, (double)step4, rightHeight, h025));
            }
        }
        return list;
    }

    public Vec3d[] getLeftVecs(World world, IBlockState state, BlockPos pos) {
        Vec3d[] vecs = new Vec3d[16];
        EnumFacing facing = (EnumFacing)state.func_177229_b(FACING);
        BlockPos posLeft = pos.func_177972_a(facing.func_176735_f());
        BlockPos posRight = pos.func_177972_a(facing.func_176746_e());
        boolean airLeft = world.func_180495_p(posLeft).func_177230_c().isAir(world.func_180495_p(posLeft), (IBlockAccess)world, posLeft);
        boolean airRight = world.func_180495_p(posRight).func_177230_c().isAir(world.func_180495_p(posRight), (IBlockAccess)world, posRight);
        double height = this.getBlockHeight((IBlockAccess)world, this.getLeftBlock(state, (IBlockAccess)world, pos), posLeft);
        if (airLeft) {
            double d = height = airRight ? 1.0 : 0.0;
        }
        if (this.getHalfBlock(state, HalfBlock.HalfBlockSide.LEFT, posLeft, facing, world).isFluid()) {
            for (int i = 0; i < vecs.length; ++i) {
                vecs[i] = new Vec3d(0.0, 0.0, 0.0);
            }
            return vecs;
        }
        double g = 0.002f;
        if (this.mirror) {
            vecs[0] = new Vec3d(0.0 - g, 0.0 - g, 0.0 - g);
            vecs[1] = new Vec3d((double)this.minWidth + g, 0.0 - g, 0.0 - g);
            vecs[2] = new Vec3d((double)this.maxWidth + g, 0.0 - g, 1.0 + g);
            vecs[3] = new Vec3d(0.0 - g, 0.0 - g, 1.0 + g);
            vecs[4] = new Vec3d(0.0 - g, 0.0 - g, 0.0 - g);
            vecs[5] = new Vec3d(0.0 - g, height + g, 0.0 - g);
            vecs[6] = new Vec3d((double)this.minWidth + g, height + g, 0.0 - g);
            vecs[7] = new Vec3d((double)this.maxWidth + g, height + g, 1.0 + g);
            vecs[8] = new Vec3d(0.0 - g, height + g, 1.0 + g);
            vecs[9] = new Vec3d(0.0 - g, height + g, 0.0 - g);
            vecs[10] = new Vec3d(0.0 - g, height + g, 1.0 + g);
            vecs[11] = new Vec3d(0.0 - g, 0.0 - g, 1.0 + g);
            vecs[12] = new Vec3d((double)this.maxWidth + g, 0.0 - g, 1.0 + g);
            vecs[13] = new Vec3d((double)this.maxWidth + g, height + g, 1.0 + g);
            vecs[14] = new Vec3d((double)this.minWidth + g, height + g, 0.0 - g);
            vecs[15] = new Vec3d((double)this.minWidth + g, 0.0 - g, 0.0 - g);
        } else {
            vecs[0] = new Vec3d(0.0 - g, 0.0 - g, 0.0 - g);
            vecs[1] = new Vec3d((double)this.maxWidth + g, 0.0 - g, 0.0 - g);
            vecs[2] = new Vec3d((double)this.minWidth + g, 0.0 - g, 1.0 + g);
            vecs[3] = new Vec3d(0.0 - g, 0.0 - g, 1.0 + g);
            vecs[4] = new Vec3d(0.0 - g, 0.0 - g, 0.0 - g);
            vecs[5] = new Vec3d(0.0 - g, height + g, 0.0 - g);
            vecs[6] = new Vec3d((double)this.maxWidth + g, height + g, 0.0 - g);
            vecs[7] = new Vec3d((double)this.minWidth + g, height + g, 1.0 + g);
            vecs[8] = new Vec3d(0.0 - g, height + g, 1.0 + g);
            vecs[9] = new Vec3d(0.0 - g, height + g, 0.0 - g);
            vecs[10] = new Vec3d(0.0 - g, height + g, 1.0 + g);
            vecs[11] = new Vec3d(0.0 - g, 0.0 - g, 1.0 + g);
            vecs[12] = new Vec3d((double)this.minWidth + g, 0.0 - g, 1.0 + g);
            vecs[13] = new Vec3d((double)this.minWidth + g, height + g, 1.0 + g);
            vecs[14] = new Vec3d((double)this.maxWidth + g, height + g, 0.0 - g);
            vecs[15] = new Vec3d((double)this.maxWidth + g, 0.0 - g, 0.0 - g);
        }
        if (facing.equals((Object)EnumFacing.EAST)) {
            vecs = BoundingBoxDraw.getRotatedVecs(vecs, 270, new Vec3d(2.0, 0.0, 0.0));
        }
        if (facing.equals((Object)EnumFacing.SOUTH)) {
            vecs = BoundingBoxDraw.getRotatedVecs(vecs, 180, new Vec3d(2.0, 0.0, 2.0));
        }
        if (facing.equals((Object)EnumFacing.WEST)) {
            vecs = BoundingBoxDraw.getRotatedVecs(vecs, 90, new Vec3d(0.0, 0.0, 2.0));
        }
        return vecs;
    }

    public Vec3d[] getRightVecs(World world, IBlockState state, BlockPos pos) {
        Vec3d[] vecs = new Vec3d[16];
        EnumFacing facing = (EnumFacing)state.func_177229_b(FACING);
        BlockPos posLeft = pos.func_177972_a(facing.func_176735_f());
        BlockPos posRight = pos.func_177972_a(facing.func_176746_e());
        boolean airLeft = world.func_180495_p(posLeft).func_177230_c().isAir(world.func_180495_p(posLeft), (IBlockAccess)world, posLeft);
        boolean airRight = world.func_180495_p(posRight).func_177230_c().isAir(world.func_180495_p(posRight), (IBlockAccess)world, posRight);
        double height = this.getBlockHeight((IBlockAccess)world, this.getRightBlock(state, (IBlockAccess)world, pos), posRight);
        if (airRight) {
            double d = height = airLeft ? 1.0 : 0.0;
        }
        if (this.getHalfBlock(state, HalfBlock.HalfBlockSide.RIGHT, posRight, facing, world).isFluid()) {
            for (int i = 0; i < vecs.length; ++i) {
                vecs[i] = new Vec3d(0.0, 0.0, 0.0);
            }
            return vecs;
        }
        double g = 0.002f;
        if (this.mirror) {
            vecs[0] = new Vec3d((double)this.minWidth - g, 0.0 - g, 0.0 - g);
            vecs[1] = new Vec3d(1.0 + g, 0.0 - g, 0.0 - g);
            vecs[2] = new Vec3d(1.0 + g, 0.0 - g, 1.0 + g);
            vecs[3] = new Vec3d((double)this.maxWidth - g, 0.0 - g, 1.0 + g);
            vecs[4] = new Vec3d((double)this.minWidth - g, 0.0 - g, 0.0 - g);
            vecs[5] = new Vec3d((double)this.minWidth - g, height + g, 0.0 - g);
            vecs[6] = new Vec3d(1.0 + g, height + g, 0.0 - g);
            vecs[7] = new Vec3d(1.0 + g, height + g, 1.0 + g);
            vecs[8] = new Vec3d((double)this.maxWidth - g, height + g, 1.0 + g);
            vecs[9] = new Vec3d((double)this.minWidth - g, height + g, 0.0 - g);
            vecs[10] = new Vec3d((double)this.maxWidth - g, height + g, 1.0 + g);
            vecs[11] = new Vec3d((double)this.maxWidth - g, 0.0 - g, 1.0 + g);
            vecs[12] = new Vec3d(1.0 + g, 0.0 - g, 1.0 + g);
            vecs[13] = new Vec3d(1.0 + g, height + g, 1.0 + g);
            vecs[14] = new Vec3d(1.0 + g, height + g, 0.0 - g);
            vecs[15] = new Vec3d(1.0 + g, 0.0 - g, 0.0 - g);
        } else {
            vecs[0] = new Vec3d((double)this.maxWidth - g, 0.0 - g, 0.0 - g);
            vecs[1] = new Vec3d(1.0 + g, 0.0 - g, 0.0 - g);
            vecs[2] = new Vec3d(1.0 + g, 0.0 - g, 1.0 + g);
            vecs[3] = new Vec3d((double)this.minWidth - g, 0.0 - g, 1.0 + g);
            vecs[4] = new Vec3d((double)this.maxWidth - g, 0.0 - g, 0.0 - g);
            vecs[5] = new Vec3d((double)this.maxWidth - g, height + g, 0.0 - g);
            vecs[6] = new Vec3d(1.0 + g, height + g, 0.0 - g);
            vecs[7] = new Vec3d(1.0 + g, height + g, 1.0 + g);
            vecs[8] = new Vec3d((double)this.minWidth - g, height + g, 1.0 + g);
            vecs[9] = new Vec3d((double)this.maxWidth - g, height + g, 0.0 - g);
            vecs[10] = new Vec3d((double)this.minWidth - g, height + g, 1.0 + g);
            vecs[11] = new Vec3d((double)this.minWidth - g, 0.0 - g, 1.0 + g);
            vecs[12] = new Vec3d(1.0 + g, 0.0 - g, 1.0 + g);
            vecs[13] = new Vec3d(1.0 + g, height + g, 1.0 + g);
            vecs[14] = new Vec3d(1.0 + g, height + g, 0.0 - g);
            vecs[15] = new Vec3d(1.0 + g, 0.0 - g, 0.0 - g);
        }
        if (facing.equals((Object)EnumFacing.EAST)) {
            vecs = BoundingBoxDraw.getRotatedVecs(vecs, 270, new Vec3d(2.0, 0.0, 0.0));
        }
        if (facing.equals((Object)EnumFacing.SOUTH)) {
            vecs = BoundingBoxDraw.getRotatedVecs(vecs, 180, new Vec3d(2.0, 0.0, 2.0));
        }
        if (facing.equals((Object)EnumFacing.WEST)) {
            vecs = BoundingBoxDraw.getRotatedVecs(vecs, 90, new Vec3d(0.0, 0.0, 2.0));
        }
        return vecs;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        ArrayList<AxisAlignedBB> list = this.getBoxList(pos, world, state);
        for (int i = 0; i < list.size(); ++i) {
            RoadBlockDiagonal.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)list.get(i));
        }
    }

    public IBlockState getLeftBlock(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facingLeft = ((EnumFacing)state.func_177229_b(FACING)).equals((Object)EnumFacing.NORTH) ? EnumFacing.WEST : (((EnumFacing)state.func_177229_b(FACING)).equals((Object)EnumFacing.EAST) ? EnumFacing.NORTH : (((EnumFacing)state.func_177229_b(FACING)).equals((Object)EnumFacing.SOUTH) ? EnumFacing.EAST : EnumFacing.SOUTH));
        IBlockState stateLeft = world.func_180495_p(pos.func_177972_a(facingLeft));
        return stateLeft;
    }

    public IBlockState getRightBlock(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facingRight = ((EnumFacing)state.func_177229_b(FACING)).equals((Object)EnumFacing.NORTH) ? EnumFacing.EAST : (((EnumFacing)state.func_177229_b(FACING)).equals((Object)EnumFacing.EAST) ? EnumFacing.SOUTH : (((EnumFacing)state.func_177229_b(FACING)).equals((Object)EnumFacing.SOUTH) ? EnumFacing.WEST : EnumFacing.NORTH));
        IBlockState stateRight = world.func_180495_p(pos.func_177972_a(facingRight));
        return stateRight;
    }

    public double getBlockHeight(IBlockAccess world, IBlockState state, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block instanceof RoadBlockDiagonal || !block.func_149703_v()) {
            return 0.0;
        }
        return block.func_185496_a((IBlockState)state, (IBlockAccess)world, (BlockPos)pos).field_72337_e;
    }

    public IBlockState getRoad(IBlockAccess world, BlockPos pos) {
        return this.getBlockSide(world, pos, this.mirror);
    }

    public BlockPos getRoadPos(IBlockAccess world, BlockPos pos) {
        return this.getSidePos(pos, world.func_180495_p(pos), this.mirror);
    }

    public IBlockState getSidewalk(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.getBlockSide(world, pos, !this.mirror);
    }

    public IBlockState getBlockSide(IBlockAccess world, BlockPos pos, boolean left) {
        IBlockState thisState = world.func_180495_p(pos);
        return world.func_180495_p(this.getSidePos(pos, thisState, left));
    }

    public BlockPos getSidePos(BlockPos pos, IBlockState state, boolean left) {
        EnumFacing facing = (EnumFacing)state.func_177229_b(FACING);
        if (facing == EnumFacing.NORTH) {
            return left ? pos.func_177972_a(EnumFacing.WEST) : pos.func_177972_a(EnumFacing.EAST);
        }
        if (facing == EnumFacing.EAST) {
            return left ? pos.func_177972_a(EnumFacing.SOUTH) : pos.func_177972_a(EnumFacing.NORTH);
        }
        if (facing == EnumFacing.SOUTH) {
            return left ? pos.func_177972_a(EnumFacing.EAST) : pos.func_177972_a(EnumFacing.WEST);
        }
        return left ? pos.func_177972_a(EnumFacing.NORTH) : pos.func_177972_a(EnumFacing.SOUTH);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        StateMapperBase b = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation("furenikusroads:" + RoadBlockDiagonal.this.modelName);
            }
        };
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)b);
    }

    @SideOnly(value=Side.CLIENT)
    public void initItemModel() {
        Item itemBlock = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("furenikusroads", this.name));
        ModelResourceLocation itemModelResourceLocation = new ModelResourceLocation(this.getRegistryName(), "inventory");
        boolean DEFAULT_ITEM_SUBTYPE = false;
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(itemBlock, 0, itemModelResourceLocation);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        if (state != null && ((Boolean)state.func_177229_b((IProperty)TRANSPARENCY)).booleanValue()) {
            return BlockRenderLayer.TRANSLUCENT == layer;
        }
        return this.func_180664_k() == layer;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        Block block = world.func_180495_p(pos.func_177972_a(face)).func_177230_c();
        if (block.func_149688_o(world.func_180495_p(pos.func_177972_a(face))) == Material.field_151586_h) {
            return true;
        }
        if (block.func_180664_k() == BlockRenderLayer.TRANSLUCENT) {
            return true;
        }
        return super.doesSideBlockRendering(state, world, pos, face);
    }

    public float getSideHeight(IBlockState state, World world, BlockPos pos, HalfBlock.HalfBlockSide side) {
        EnumFacing facing = (EnumFacing)state.func_177229_b(FACING);
        BlockPos posSide = side == HalfBlock.HalfBlockSide.LEFT ? pos.func_177972_a(facing.func_176735_f()) : pos.func_177972_a(facing.func_176746_e());
        IBlockState stateSide = world.func_180495_p(posSide);
        if (stateSide.func_177230_c().isAir(stateSide, (IBlockAccess)world, posSide)) {
            return 0.0f;
        }
        return (float)stateSide.func_177230_c().func_185496_a((IBlockState)stateSide, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, (BlockPos)posSide).field_72337_e;
    }

    public HalfBlock getHalfBlock(IBlockState state, HalfBlock.HalfBlockSide side, BlockPos pos, EnumFacing facing, World world) {
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        return new HalfBlock(extendedState, side, pos, facing, world);
    }
}

