/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.catsdogs.common.tileentity;

import com.animania.addons.catsdogs.common.tileentity.handler.FluidHandlerPetBowl;
import com.animania.addons.catsdogs.common.tileentity.handler.ItemHandlerPetBowl;
import com.animania.api.interfaces.IFoodProviderTE;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.config.AnimaniaConfig;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityPetBowl
extends TileEntity
implements ITickable,
IFoodProviderTE {
    protected BowlContent type;
    public ItemHandlerPetBowl itemHandler = new ItemHandlerPetBowl();
    public FluidHandlerPetBowl fluidHandler = new FluidHandlerPetBowl(1000);
    private int oldItemCount = 0;
    private int oldFluidCount = 0;

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        if (this.field_145854_h != null && this.field_174879_c != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145854_h.func_176223_P(), this.field_145854_h.func_176223_P(), 1);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_189515_b(tagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_73660_a() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        FluidStack fluid = this.fluidHandler.getFluid();
        if (!stack.func_190926_b()) {
            int count = stack.func_190916_E();
            if (count != this.oldItemCount) {
                this.func_70296_d();
                this.oldItemCount = count;
            }
            if (count == 0 && fluid == null && this.type != BowlContent.EMPTY) {
                this.setTroughType(BowlContent.EMPTY);
            } else if (count >= 1 && this.type != BowlContent.FOOD) {
                this.setTroughType(BowlContent.FOOD);
            }
        } else if (fluid != null) {
            if (this.type != BowlContent.LIQUID) {
                this.setTroughType(BowlContent.LIQUID);
            }
            if (fluid.amount != this.oldFluidCount) {
                this.func_70296_d();
                this.oldFluidCount = fluid.amount;
            }
        } else if (this.type != BowlContent.EMPTY) {
            this.setTroughType(BowlContent.EMPTY);
        }
    }

    public void setTroughType(BowlContent type) {
        this.type = type;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
    }

    public BowlContent getBowlContent() {
        return this.type;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tag = super.func_189515_b(compound);
        NBTTagCompound items = this.itemHandler.serializeNBT();
        NBTTagCompound fluid = new NBTTagCompound();
        fluid = this.fluidHandler.writeToNBT(fluid);
        tag.func_74782_a("items", (NBTBase)items);
        tag.func_74782_a("fluid", (NBTBase)fluid);
        return tag;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.itemHandler = new ItemHandlerPetBowl();
        this.fluidHandler = new FluidHandlerPetBowl(1000);
        this.fluidHandler.readFromNBT(compound.func_74775_l("fluid"));
        this.itemHandler.deserializeNBT(compound.func_74775_l("items"));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (AnimaniaConfig.gameRules.allowTroughAutomation) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.fluidHandler.getFluid() == null) {
                return true;
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.itemHandler.getStackInSlot(0).func_190926_b()) {
                return true;
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (AnimaniaConfig.gameRules.allowTroughAutomation) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)((Object)this.itemHandler);
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)((Object)this.fluidHandler);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        super.func_70296_d();
        AnimaniaHelper.sendTileEntityUpdate((TileEntity)this);
    }

    @Override
    public boolean canConsume(@Nullable Set<ItemStack> fooditems, @Nullable Fluid[] fluid) {
        if (fluid == null) {
            return this.canConsume(null, fooditems);
        }
        boolean canConsumeAny = false;
        for (Fluid f : fluid) {
            boolean consume = this.canConsume(new FluidStack(f, 0), fooditems);
            if (!consume) continue;
            canConsumeAny = true;
        }
        return canConsumeAny;
    }

    @Override
    public boolean canConsume(@Nullable FluidStack fluid, @Nullable Set<ItemStack> fooditems) {
        if (fooditems != null && !this.itemHandler.getStackInSlot(0).func_190926_b()) {
            ItemStack stack = this.itemHandler.getStackInSlot(0);
            return AnimaniaHelper.containsItemStack(fooditems, (ItemStack)stack);
        }
        if (fluid != null && this.fluidHandler.getFluid() != null && fluid.getFluid() == this.fluidHandler.getFluid().getFluid()) {
            FluidStack fluidstack = this.fluidHandler.getFluid();
            return fluidstack.getFluid() == fluid.getFluid() && fluidstack.amount >= fluid.amount;
        }
        return false;
    }

    @Override
    public void consumeSolidOrLiquid(int liquidAmount, int itemAmount) {
        if (!this.itemHandler.getStackInSlot(0).func_190926_b()) {
            this.consumeSolid(itemAmount);
            return;
        }
        if (this.fluidHandler.getFluid() != null) {
            this.consumeLiquid(liquidAmount);
            return;
        }
    }

    @Override
    public void consumeSolid(int amount) {
        this.itemHandler.getStackInSlot(0).func_190918_g(amount);
    }

    @Override
    public void consumeLiquid(int amount) {
        this.fluidHandler.drain(amount, true);
    }

    public static enum BowlContent {
        EMPTY,
        LIQUID,
        FOOD;

    }
}

