/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.catsdogs.common.block;

import com.animania.addons.catsdogs.common.tileentity.TileEntityPetBowl;
import com.animania.addons.catsdogs.config.CatsDogsConfig;
import com.animania.api.interfaces.IFoodProviderBlock;
import com.animania.common.blocks.AnimaniaContainer;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.compat.top.providers.TOPInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockPetBowl
extends AnimaniaContainer
implements IFoodProviderBlock,
TOPInfoProvider {
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.25, 0.75);

    public BlockPetBowl() {
        super("pet_bowl", Material.field_151575_d, MapColor.field_151650_B);
        this.func_149711_c(1.2f);
        this.func_149752_b(1.5f);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPetBowl();
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileEntityPetBowl te = (TileEntityPetBowl)worldIn.func_175625_s(pos);
        if (entityIn != null && entityIn instanceof EntityItem && !worldIn.field_72995_K) {
            EntityItem entityitem = (EntityItem)entityIn;
            ItemStack stack = entityitem.func_92059_d();
            if (!stack.func_190926_b() && BlockPetBowl.isFoodItem(stack)) {
                ItemStack held;
                ItemStack remaining;
                if ((!te.itemHandler.getStackInSlot(0).func_190926_b() && te.itemHandler.getStackInSlot(0).func_190916_E() < 3 || te.itemHandler.getStackInSlot(0).func_190926_b() && te.fluidHandler.getFluid() == null) && !ItemStack.func_77989_b((ItemStack)(remaining = te.itemHandler.insertItem(0, held = stack.func_77946_l().func_77979_a(1), false)), (ItemStack)held)) {
                    stack.func_190918_g(1);
                }
            } else if (AnimaniaHelper.hasFluid((ItemStack)stack, (Fluid)FluidRegistry.WATER) && te.itemHandler.getStackInSlot(0).func_190926_b() && te.fluidHandler.getFluid() == null) {
                te.fluidHandler.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187624_K, SoundCategory.BLOCKS, 0.6f, 0.8f);
                IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
                handler.drain(1000, true);
                ItemStack newStack = handler.getContainer();
                entityitem.func_92058_a(newStack);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        TileEntityPetBowl te = (TileEntityPetBowl)worldIn.func_175625_s(pos);
        if (!heldItem.func_190926_b() && BlockPetBowl.isFoodItem(heldItem)) {
            if (!te.itemHandler.getStackInSlot(0).func_190926_b() && te.itemHandler.getStackInSlot(0).func_190916_E() < 3 || te.itemHandler.getStackInSlot(0).func_190926_b() && te.fluidHandler.getFluid() == null) {
                ItemStack held = heldItem.func_77946_l().func_77979_a(1);
                ItemStack remaining = te.itemHandler.insertItem(0, held, false);
                if (!playerIn.func_184812_l_() && !ItemStack.func_77989_b((ItemStack)remaining, (ItemStack)held)) {
                    heldItem.func_190918_g(1);
                }
                return true;
            }
        } else {
            if (AnimaniaHelper.hasFluid((ItemStack)heldItem, (Fluid)FluidRegistry.WATER) && te.itemHandler.getStackInSlot(0).func_190926_b() && (te.fluidHandler.getFluid() == null || te.fluidHandler.getFluid().getFluid() == FluidRegistry.WATER && te.fluidHandler.getFluid().amount < 1000)) {
                te.fluidHandler.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187624_K, SoundCategory.PLAYERS, 0.6f, 0.8f);
                if (!playerIn.func_184812_l_()) {
                    IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)heldItem);
                    handler.drain(1000, true);
                    ItemStack newStack = handler.getContainer();
                    playerIn.func_184611_a(hand, newStack);
                }
                return true;
            }
            if (playerIn.func_184592_cb().func_190926_b() && playerIn.func_184614_ca().func_190926_b() && !te.itemHandler.getStackInSlot(0).func_190926_b()) {
                ItemStack extract = te.itemHandler.extractItem(0, 1, false);
                playerIn.field_71071_by.func_70441_a(extract);
                return true;
            }
            if (!heldItem.func_190926_b() && FluidUtil.getFluidHandler((ItemStack)heldItem) != null && FluidUtil.getFluidContained((ItemStack)heldItem) == null && te.fluidHandler.getFluid() != null && te.fluidHandler.getFluid().amount >= 1000) {
                FluidStack fluidStack = te.fluidHandler.drain(1000, true);
                if (!playerIn.func_184812_l_() && heldItem.func_190916_E() >= 1) {
                    ItemStack heldItem1 = heldItem.func_77946_l();
                    heldItem1.func_190920_e(1);
                    IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)heldItem1);
                    handler.fill(fluidStack, true);
                    ItemStack newstack = handler.getContainer();
                    if (heldItem.func_190916_E() > 1) {
                        heldItem.func_190918_g(1);
                        playerIn.field_71071_by.func_70441_a(newstack);
                    } else {
                        playerIn.func_184611_a(hand, newstack);
                    }
                    return true;
                }
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187630_M, SoundCategory.PLAYERS, 0.6f, 0.8f);
                return true;
            }
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityPetBowl te = (TileEntityPetBowl)worldIn.func_175625_s(pos);
        if (te != null) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)te.itemHandler.getStackInSlot(0));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntityPetBowl te = (TileEntityPetBowl)worldIn.func_175625_s(pos);
        if (!te.itemHandler.getStackInSlot(0).func_190926_b()) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)te.itemHandler);
        }
        if (te.fluidHandler.getFluid() != null) {
            int fluid = te.fluidHandler.getFluidAmount();
            return fluid / 66;
        }
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static boolean isFoodItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        String[] foods = CatsDogsConfig.catsdogs.petBowlFood;
        ItemStack[] items = AnimaniaHelper.getItemStackArray((String[])foods);
        for (int i = 0; i < items.length; ++i) {
            if (!ItemStack.func_179545_c((ItemStack)items[i], (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TileEntityPetBowl) {
            TileEntityPetBowl bowl = (TileEntityPetBowl)te;
            ItemStack stack = bowl.itemHandler.getStackInSlot(0);
            FluidStack fluid = bowl.fluidHandler.getFluid();
            if (mode == ProbeMode.NORMAL) {
                if (!stack.func_190926_b()) {
                    probeInfo.horizontal();
                    probeInfo.item(stack);
                }
                if (fluid != null) {
                    ItemStack bucket = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)fluid.getFluid());
                    probeInfo.horizontal().item(bucket).text(fluid.getLocalizedName() + ", " + fluid.amount + "mB");
                }
            }
        }
    }
}

