/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.command;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import net.gegy1000.terrarium.Terrarium;
import net.gegy1000.terrarium.server.util.ThreadedProfiler;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public final class TerrariumCommand
extends CommandBase {
    private static final Path DEBUG_ROOT = Paths.get("mods/terrarium/debug", new String[0]);
    private static final long PROFILE_TIME_SECONDS = 60L;

    public String func_71517_b() {
        return "terrarium";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "terrarium profile";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String subCommand;
        if (args.length >= 1 && (subCommand = args[0]).equals("profile")) {
            this.profile(server, sender);
            return;
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    private void profile(MinecraftServer server, ICommandSender sender) {
        ThreadedProfiler.start();
        sender.func_145747_a((ITextComponent)new TextComponentString("Profiling Terrarium for 60 seconds"));
        Thread thread = new Thread(() -> {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                Terrarium.LOGGER.warn("Interrupted while waiting for profiler", (Throwable)e);
            }
            server.func_152344_a(() -> {
                List<ThreadedProfiler.Node> roots = ThreadedProfiler.stop();
                try {
                    this.writeResults(roots);
                    sender.func_145747_a((ITextComponent)new TextComponentString("Wrote profiler results to file"));
                }
                catch (IOException e) {
                    Terrarium.LOGGER.error("Failed to write profiler results", (Throwable)e);
                }
            });
        });
        thread.setDaemon(true);
        thread.start();
    }

    private void writeResults(List<ThreadedProfiler.Node> roots) throws IOException {
        Path path = DEBUG_ROOT.resolve("profiler.txt");
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
            this.writeResults(writer::println, roots);
        }
    }

    private void writeResults(Consumer<String> writer, List<ThreadedProfiler.Node> roots) {
        writer.accept("Profile results over 60 seconds:");
        for (ThreadedProfiler.Node root : roots) {
            this.writeNode(writer, root, 0);
            writer.accept("");
        }
    }

    private void writeNode(Consumer<String> writer, ThreadedProfiler.Node node, int depth) {
        long timeMs = node.time / 1000000L;
        if (timeMs == 0L) {
            return;
        }
        String indent = Strings.repeat((String)"  ", (int)depth);
        writer.accept(indent + node.name + ": " + timeMs + "ms");
        for (ThreadedProfiler.Node child : node.children.values()) {
            this.writeNode(writer, child, depth + 1);
        }
    }
}

