/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.justnow.executor;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.gegy1000.justnow.executor.Task;

public final class TaskQueue
implements AutoCloseable {
    private final ArrayDeque<Task<?>> tasks = new ArrayDeque();
    private final Object lock = new Object();
    private volatile boolean open = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.tasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Task<?> task) {
        if (task.isInvalid()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.tasks.add(task);
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Task<?> task) {
        Object object = this.lock;
        synchronized (object) {
            return this.tasks.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Task<?> take() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            Task<?> task;
            while ((task = this.tasks.poll()) == null) {
                if (!this.open) {
                    return null;
                }
                this.lock.wait();
            }
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainTo(Collection<Task<?>> target) {
        Object object = this.lock;
        synchronized (object) {
            while (!this.tasks.isEmpty()) {
                target.add(this.tasks.remove());
            }
        }
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    public Waker waker(Task task) {
        return new Waker(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.open = false;
            this.tasks.clear();
            this.lock.notify();
        }
    }

    public class Waker
    implements net.gegy1000.justnow.Waker {
        static final int READY = 0;
        static final int POLLING = 1;
        static final int AWOKEN = 2;
        private final Task<?> task;
        final AtomicInteger state = new AtomicInteger(2);

        private Waker(Task<?> task) {
            this.task = task;
        }

        @Override
        public void wake() {
            if (this.state.compareAndSet(1, 2)) {
                return;
            }
            if (this.state.compareAndSet(0, 2)) {
                TaskQueue.this.enqueue(this.task);
            }
        }

        void polling() {
            this.state.set(1);
        }

        void ready() {
            if (!this.state.compareAndSet(1, 0)) {
                TaskQueue.this.enqueue(this.task);
            }
        }
    }
}

