/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world;

import net.gegy1000.earth.server.util.zoom.ForZoom;
import net.gegy1000.earth.server.world.EarthProperties;
import net.gegy1000.earth.server.world.data.source.StdSource;
import net.gegy1000.earth.server.world.data.source.WorldClimateRaster;
import net.gegy1000.terrarium.server.world.coordinate.CoordinateReference;
import net.gegy1000.terrarium.server.world.generator.customization.GenerationSettings;

public final class EarthInitContext {
    public final GenerationSettings settings;
    public final CoordinateReference lngLatCrs;
    public final CoordinateReference climateRasterCrs;
    public final ForZoom<CoordinateReference> stdRasterCrs;

    private EarthInitContext(GenerationSettings settings) {
        this.settings = settings;
        double worldScale = this.settings.getDouble(EarthProperties.WORLD_SCALE);
        double metersPerDegree = 111319.49166666667;
        this.lngLatCrs = CoordinateReference.lngLat(metersPerDegree / worldScale);
        this.climateRasterCrs = WorldClimateRaster.crs(worldScale);
        this.stdRasterCrs = zoom -> StdSource.crs(worldScale, zoom);
    }

    public static EarthInitContext from(GenerationSettings settings) {
        return new EarthInitContext(settings);
    }
}

