/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.command;

import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import net.gegy1000.earth.TerrariumEarth;
import net.gegy1000.earth.server.capability.EarthWorld;
import net.gegy1000.earth.server.command.ContainerUi;
import net.gegy1000.earth.server.command.DeferredTranslator;
import net.gegy1000.earth.server.command.debugger.DebugGeoProfile;
import net.gegy1000.earth.server.command.debugger.GeoDebugger;
import net.gegy1000.earth.server.world.EarthData;
import net.gegy1000.earth.server.world.cover.Cover;
import net.gegy1000.earth.server.world.ecology.GrowthPredictors;
import net.gegy1000.earth.server.world.ecology.soil.SoilSuborder;
import net.gegy1000.earth.server.world.ecology.vegetation.Trees;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.EnumRaster;
import net.gegy1000.terrarium.server.world.data.raster.UByteRaster;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class GeoDebugCommand
extends CommandBase {
    private static final Path DEBUG = Paths.get("mods/terrarium/debug", new String[0]);
    private static final int RASTER_RADIUS = 128;
    private static final int RASTER_SIZE = 257;

    public String func_71517_b() {
        return "geodebug";
    }

    public int func_82362_a() {
        return 3;
    }

    public String func_71518_a(ICommandSender sender) {
        return DeferredTranslator.translateStringOrKey(sender, "commands.earth.geodebug.usage");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = CommandBase.func_71521_c((ICommandSender)sender);
        EarthWorld earth = (EarthWorld)player.field_70170_p.getCapability(TerrariumEarth.worldCap(), null);
        if (earth == null) {
            throw DeferredTranslator.createException((ICommandSender)player, "commands.earth.wrong_world", new Object[0]);
        }
        GeoDebugger debug = GeoDebugger.from(player.field_70170_p);
        ContainerUi.Builder builder = ContainerUi.builder(player).setTitle(DeferredTranslator.translate((ICommandSender)player, (ITextComponent)new TextComponentTranslation("container.earth.geodebug.name", new Object[0])));
        builder.addElement((Item)Items.field_151098_aY, "Make Rasters", () -> this.openRasterUi(player, debug));
        builder.addElement(Items.field_151099_bA, "Take Profile Here", () -> {
            DebugGeoProfile profile = debug.takeProfile("Current Location", player.field_70165_t, player.field_70161_v);
            profile.sendTo(player);
        });
        builder.addElement(Items.field_151079_bi, "Export Test Profiles", () -> this.writeProfiles(debug.takeTestProfiles()));
        ContainerUi ui = builder.build();
        player.func_71007_a((IInventory)ui.createInventory());
    }

    private void openRasterUi(EntityPlayerMP player, GeoDebugger debug) {
        ContainerUi.Builder builder = ContainerUi.builder(player).setTitle(DeferredTranslator.translate((ICommandSender)player, (ITextComponent)new TextComponentTranslation("container.earth.geodebug.name", new Object[0])));
        builder.addElement(Item.func_150898_a((Block)Blocks.field_150345_g), "Vegetation Suitability Index", () -> {
            this.writeRaster(player, debug.vegetation("acacia", Trees.ACACIA));
            this.writeRaster(player, debug.vegetation("birch", Trees.BIRCH));
            this.writeRaster(player, debug.vegetation("oak", Trees.OAK));
            this.writeRaster(player, debug.vegetation("jungle", Trees.JUNGLE));
            this.writeRaster(player, debug.vegetation("spruce", Trees.SPRUCE));
            this.writeRaster(player, debug.vegetation("pine", Trees.PINE));
        });
        builder.addElement(Items.field_151119_aD, "Soil", () -> {
            this.writeRaster(player, debug.scaledHeatmap("clay_content", UByteRaster.sampler(EarthData.CLAY_CONTENT)));
            this.writeRaster(player, debug.scaledHeatmap("silt_content", UByteRaster.sampler(EarthData.SILT_CONTENT)));
            this.writeRaster(player, debug.scaledHeatmap("sand_content", UByteRaster.sampler(EarthData.SAND_CONTENT)));
            EnumRaster.Sampler<SoilSuborder> sampler = EnumRaster.sampler(EarthData.SOIL_SUBORDER, SoilSuborder.NO);
            this.writeRaster(player, debug.soilSuborder("soil", sampler));
        });
        builder.addElement((Item)Items.field_151098_aY, "Cover", () -> {
            EnumRaster.Sampler<Cover> sampler = EnumRaster.sampler(EarthData.COVER, Cover.NO);
            this.writeRaster(player, debug.cover("cover", sampler));
            this.writeRaster(player, debug.biomes("biomes", GrowthPredictors.sampler()));
        });
        ContainerUi ui = builder.build();
        player.func_71007_a((IInventory)ui.createInventory());
    }

    private void writeRaster(EntityPlayerMP player, GeoDebugger.RasterSampler sampler) {
        TerrariumWorld terrarium = TerrariumWorld.get(player.field_70170_p);
        Preconditions.checkNotNull((Object)terrarium, (Object)"terrarium world was null");
        ColumnDataCache dataCache = terrarium.getDataCache();
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        int z = MathHelper.func_76128_c((double)player.field_70161_v);
        DataView view = DataView.of(x - 128, z - 128, 257, 257);
        BufferedImage image = sampler.sample(dataCache, view);
        try {
            if (!Files.exists(DEBUG, new LinkOption[0])) {
                Files.createDirectories(DEBUG, new FileAttribute[0]);
            }
            ImageIO.write((RenderedImage)image, "png", DEBUG.resolve(sampler.name + ".png").toFile());
        }
        catch (IOException e) {
            TerrariumEarth.LOGGER.warn("Failed to write raster {}", (Object)sampler.name, (Object)e);
        }
    }

    private void writeProfiles(DebugGeoProfile[] profiles) {
        try {
            if (!Files.exists(DEBUG, new LinkOption[0])) {
                Files.createDirectories(DEBUG, new FileAttribute[0]);
            }
            Path path = DEBUG.resolve("debug_profiles.csv");
            try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
                writer.println("Name,Latitude,Longitude,Surface Elevation,Cover,Mean Temperature,Min Temperature,Annual Rainfall,Soil Suborder,Silt Content,Sand Content,Clay Content,Organic Carbon Content,Cation Exchange Capacity,Soil pH");
                for (DebugGeoProfile profile : profiles) {
                    writer.print(profile.name + "," + profile.latitude + "," + profile.longitude + ",");
                    writer.print(profile.surfaceElevation + "," + profile.cover + ",");
                    writer.print(profile.meanTemperature + "," + profile.minTemperature + "," + profile.annualRainfall + ",");
                    writer.print((Object)((Object)profile.soilSuborder) + ",");
                    writer.print(profile.siltContent + "," + profile.sandContent + "," + profile.clayContent + ",");
                    writer.print(profile.organicCarbonContent + "," + profile.cationExchangeCapacity + "," + profile.soilPh + ",");
                    writer.println();
                }
            }
        }
        catch (IOException e) {
            TerrariumEarth.LOGGER.warn("Failed to write profiles", (Throwable)e);
        }
    }
}

