/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.gengen.api;

import com.google.common.base.Preconditions;
import dev.gegy.gengen.api.HeightFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class Heightmap
implements HeightFunction {
    public static final int SIZE = 16;
    private final int[] buffer;

    private Heightmap(int[] buffer) {
        this.buffer = buffer;
    }

    public static Heightmap wrap(int[] buffer) {
        Preconditions.checkArgument((buffer.length == 256 ? 1 : 0) != 0, (Object)"invalid buffer size");
        return new Heightmap(buffer);
    }

    public static Heightmap create(Init init) {
        int[] buffer = new int[256];
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                buffer[Heightmap.indexUnchecked((int)x, (int)z)] = init.get(x, z);
            }
        }
        return new Heightmap(buffer);
    }

    public int get(int x, int z) {
        return this.buffer[Heightmap.index(x, z)];
    }

    public int getUnchecked(int x, int z) {
        return this.buffer[Heightmap.indexUnchecked(x, z)];
    }

    private static int index(int x, int z) {
        if (x < 0 || z < 0 || x >= 16 || z >= 16) {
            throw new IndexOutOfBoundsException();
        }
        return x + z * 16;
    }

    private static int indexUnchecked(int x, int z) {
        return x + z * 16;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    @Override
    public int apply(int x, int z) {
        return this.get(x, z);
    }

    public static interface Init {
        public int get(int var1, int var2);
    }
}

