/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.playerrevive.server;

import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.playerrevive.CapaReviveProvider;
import com.creativemd.playerrevive.PlayerRevive;
import com.creativemd.playerrevive.api.DamageBledToDeath;
import com.creativemd.playerrevive.api.IRevival;
import com.creativemd.playerrevive.server.PlayerReviveServer;
import com.mojang.authlib.GameProfile;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.fml.server.FMLServerHandler;

public class ReviveEventServer {
    private static Boolean isClient = null;

    public static boolean isClient() {
        if (isClient == null) {
            try {
                isClient = Class.forName("net.minecraft.client.Minecraft") != null;
            }
            catch (ClassNotFoundException e) {
                isClient = false;
            }
        }
        return isClient;
    }

    public static boolean isReviveActive() {
        if (ReviveEventServer.isClient()) {
            return !ReviveEventServer.isSinglePlayer();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean isSinglePlayer() {
        return Minecraft.func_71410_x().func_71356_B() && !Minecraft.func_71410_x().func_71401_C().func_71344_c();
    }

    public static MinecraftServer getMinecraftServer() {
        if (ReviveEventServer.isClient()) {
            return ReviveEventServer.getMinecraftServerClient();
        }
        return FMLServerHandler.instance().getServer();
    }

    @SideOnly(value=Side.CLIENT)
    private static MinecraftServer getMinecraftServerClient() {
        return Minecraft.func_71410_x().func_71401_C();
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == Side.SERVER && ReviveEventServer.isReviveActive()) {
            EntityPlayer player = event.player;
            if (player.field_70128_L) {
                return;
            }
            IRevival revive = PlayerReviveServer.getRevival(player);
            if (!revive.isHealty()) {
                revive.tick();
                if (revive.getTimeLeft() % 20 == 0) {
                    PlayerReviveServer.sendUpdatePacket(player);
                }
                player.func_71024_bL().func_75114_a(PlayerRevive.CONFIG.playerFoodAfter);
                player.func_70606_j((float)PlayerRevive.CONFIG.playerHealthAfter);
                player.field_71075_bZ.field_75102_a = true;
                player.func_184224_h(true);
                if (revive.isRevived()) {
                    PlayerReviveServer.revive(player);
                } else if (revive.isDead()) {
                    PlayerReviveServer.kill(player);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        IRevival revive = PlayerReviveServer.getRevival(event.player);
        if (!revive.isHealty()) {
            PlayerReviveServer.kill(event.player);
        }
        if (!event.player.field_70170_p.field_72995_K) {
            PlayerReviveServer.removePlayerAsHelper(event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void playerInteract(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player;
        IRevival revive;
        if (!PlayerReviveServer.isPlayerBleeding(event.getEntityPlayer()) && event.getTarget() instanceof EntityPlayer && !event.getEntityLiving().field_70170_p.field_72995_K && !(revive = PlayerReviveServer.getRevival(player = (EntityPlayer)event.getTarget())).isHealty()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("uuid", EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString());
            revive.getRevivingPlayers().add(event.getEntityPlayer());
            GuiHandler.openGui((String)"plreviver", (NBTTagCompound)nbt, (EntityPlayer)event.getEntityPlayer());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerDamage(LivingHurtEvent event) {
        EntityPlayer player;
        IRevival revive;
        if (event.getEntityLiving() instanceof EntityPlayer && !(revive = PlayerReviveServer.getRevival(player = (EntityPlayer)event.getEntityLiving())).isHealty() && (event.getSource() != DamageBledToDeath.bledToDeath && !PlayerRevive.CONFIG.bypassDamageSources.contains(event.getSource().field_76373_n) || revive.isDead())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerDied(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && ReviveEventServer.isReviveActive() && !event.getEntityLiving().field_70170_p.field_72995_K && event.getSource() != DamageBledToDeath.bledToDeath && !PlayerRevive.CONFIG.bypassDamageSources.contains(event.getSource().field_76373_n)) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IRevival revive = PlayerReviveServer.getRevival(player);
            if (revive.isDead()) {
                revive.stopBleeding();
                return;
            }
            PlayerReviveServer.startBleeding(player, event.getSource());
            player.field_71075_bZ.field_75102_a = true;
            player.func_184224_h(true);
            if (player.func_184218_aH()) {
                player.func_184210_p();
            }
            event.setCanceled(true);
            player.func_70606_j(0.5f);
            player.func_71024_bL().func_75114_a(1);
            if (!PlayerRevive.CONFIG.disableBleedingMessage) {
                player.func_184102_h().func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("playerrevive.chat.bleeding", new Object[]{player.getDisplayNameString()}));
            }
        }
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("playerrevive", "revive"), (ICapabilityProvider)new CapaReviveProvider());
        }
    }
}

