/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.bt.nodes;

import CoroUtil.bt.Behavior;
import CoroUtil.bt.BlackboardBase;
import CoroUtil.bt.EnumBehaviorState;
import CoroUtil.bt.IBTAgent;
import CoroUtil.bt.selector.Selector;
import CoroUtil.util.Vec3;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;

public class Flee
extends Selector {
    public IBTAgent entInt;
    public EntityLiving ent;
    public BlackboardBase blackboard;

    public Flee(Behavior parParent, IBTAgent parEnt, BlackboardBase parBB) {
        super(parParent);
        this.blackboard = parBB;
        this.entInt = parEnt;
        this.ent = (EntityLiving)parEnt;
    }

    @Override
    public EnumBehaviorState tick() {
        float fleeRangeOverride = 6.0f;
        float distToFleePref = 32.0f;
        boolean fleeFromTarget = false;
        if (this.blackboard.lastFleeTarget != null) {
            if (this.blackboard.fleeToCoords != null) {
                if (!this.ent.field_70122_E || !(this.ent.func_70011_f((double)this.blackboard.fleeToCoords.posX, (double)this.blackboard.fleeToCoords.posY, (double)this.blackboard.fleeToCoords.posZ) > (double)distToFleePref)) {
                    fleeFromTarget = true;
                }
            } else {
                fleeFromTarget = true;
            }
            if (this.ent.func_70032_d(this.blackboard.lastFleeTarget) < fleeRangeOverride || fleeFromTarget) {
                Vec3 vec = this.getTargetVector(this.blackboard.lastFleeTarget);
                double dist = 3.0;
                Vec3 dest = new Vec3(this.ent.field_70165_t - vec.xCoord * dist, this.ent.field_70163_u, this.ent.field_70161_v - vec.zCoord * dist);
                this.blackboard.setMoveAndPathTo(dest);
                this.entInt.getAIBTAgent().setMoveTo(dest.xCoord, dest.yCoord, dest.zCoord);
                if (!this.ent.field_70122_E) {
                    this.ent.field_70159_w += -vec.xCoord * (double)0.05f;
                    this.ent.field_70179_y += -vec.zCoord * (double)0.05f;
                }
            } else if (this.blackboard.fleeToCoords != null) {
                this.blackboard.setMoveTo(new Vec3(this.blackboard.fleeToCoords.posX, this.blackboard.fleeToCoords.posY, this.blackboard.fleeToCoords.posZ));
            }
        }
        return super.tick();
    }

    public Vec3 getTargetVector(Entity target) {
        double vecX = target.field_70165_t - this.ent.field_70165_t;
        double vecY = target.field_70163_u - this.ent.field_70163_u;
        double vecZ = target.field_70161_v - this.ent.field_70161_v;
        double dist = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        Vec3 vec3 = new Vec3(vecX / dist, vecY / dist, vecZ / dist);
        return vec3;
    }
}

