/*
 * Decompiled with CFR 0.152.
 */
package com.leviathanstudio.craftstudio.server.animation;

import com.leviathanstudio.craftstudio.common.animation.AnimationHandler;
import com.leviathanstudio.craftstudio.common.animation.Channel;
import com.leviathanstudio.craftstudio.common.animation.CustomChannel;
import com.leviathanstudio.craftstudio.common.animation.IAnimated;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.SERVER)
public class ServerAnimationHandler<T extends IAnimated>
extends AnimationHandler<T> {
    private Map<String, Channel> animChannels = new HashMap<String, Channel>();
    private Map<T, Map<String, AnimationHandler.AnimInfo>> currentAnimInfo = new WeakHashMap<T, Map<String, AnimationHandler.AnimInfo>>();
    private Map<T, Map<String, Float>> startingAnimations = new WeakHashMap<T, Map<String, Float>>();

    @Override
    public void addAnim(String modid, String animNameIn, String modelNameIn, boolean looped) {
        super.addAnim(modid, animNameIn, modelNameIn, looped);
        ResourceLocation anim = new ResourceLocation(modid, animNameIn);
        this.animChannels.put(anim.toString(), new Channel(anim.toString(), 60.0f, looped));
    }

    @Override
    public void addAnim(String modid, String animNameIn, CustomChannel customChannelIn) {
        super.addAnim(modid, animNameIn, customChannelIn);
        ResourceLocation anim = new ResourceLocation(modid, animNameIn);
        this.animChannels.put(anim.toString(), new Channel(anim.toString(), 60.0f, false));
    }

    @Override
    public void addAnim(String modid, String invertedAnimationName, String animationToInvert) {
        super.addAnim(modid, invertedAnimationName, animationToInvert);
        ResourceLocation anim = new ResourceLocation(modid, invertedAnimationName);
        ResourceLocation inverted = new ResourceLocation(modid, animationToInvert);
        boolean looped = this.animChannels.get((Object)inverted.toString()).looped;
        this.animChannels.put(anim.toString(), new Channel(anim.toString(), 60.0f, looped));
    }

    @Override
    public boolean clientStartAnimation(String res, float startingFrame, T animatedElement) {
        return false;
    }

    @Override
    protected boolean serverInitAnimation(String res, float startingFrame, T animatedElement) {
        if (!this.animChannels.containsKey(res)) {
            return false;
        }
        Map<String, Float> startingAnimMap = this.startingAnimations.get(animatedElement);
        if (startingAnimMap == null) {
            startingAnimMap = new HashMap<String, Float>();
            this.startingAnimations.put(animatedElement, startingAnimMap);
        }
        startingAnimMap.put(res, Float.valueOf(startingFrame));
        return true;
    }

    @Override
    protected boolean serverStartAnimation(String res, float endingFrame, T animatedElement) {
        if (!this.animChannels.containsKey(res)) {
            return false;
        }
        Map<String, Float> startingAnimMap = this.startingAnimations.get(animatedElement);
        if (startingAnimMap == null) {
            return false;
        }
        if (!startingAnimMap.containsKey(res)) {
            return false;
        }
        Map<String, AnimationHandler.AnimInfo> animInfoMap = this.currentAnimInfo.get(animatedElement);
        if (animInfoMap == null) {
            animInfoMap = new HashMap<String, AnimationHandler.AnimInfo>();
            this.currentAnimInfo.put(animatedElement, animInfoMap);
        }
        Channel anim = this.animChannels.get(res);
        anim.totalFrames = (int)endingFrame;
        animInfoMap.remove(res);
        animInfoMap.put(res, new AnimationHandler.AnimInfo(System.nanoTime(), startingAnimMap.get(res).floatValue()));
        startingAnimMap.remove(res);
        return true;
    }

    @Override
    public boolean clientStopAnimation(String res, T animatedElement) {
        return false;
    }

    @Override
    protected boolean serverStopAnimation(String res, T animatedElement) {
        Map<String, AnimationHandler.AnimInfo> animInfoMap = this.currentAnimInfo.get(animatedElement);
        if (animInfoMap == null) {
            return false;
        }
        animInfoMap.remove(res);
        return true;
    }

    @Override
    public void animationsUpdate(T animatedElement) {
        Map<String, AnimationHandler.AnimInfo> animInfoMap = this.currentAnimInfo.get(animatedElement);
        if (animInfoMap == null) {
            return;
        }
        Iterator<Map.Entry<String, AnimationHandler.AnimInfo>> it = animInfoMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, AnimationHandler.AnimInfo> animInfo = it.next();
            boolean animStatus = this.canUpdateAnimation(this.animChannels.get(animInfo.getKey()), animatedElement);
            if (animStatus) continue;
            it.remove();
        }
    }

    @Override
    public boolean isAnimationActive(String name, T animatedElement) {
        Map<String, AnimationHandler.AnimInfo> animInfoMap = this.currentAnimInfo.get(animatedElement);
        if (animInfoMap == null) {
            return false;
        }
        for (Map.Entry<String, AnimationHandler.AnimInfo> animInfo : animInfoMap.entrySet()) {
            if (!animInfo.getKey().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHoldAnimationActive(String name, T animatedElement) {
        return this.isAnimationActive(name, animatedElement);
    }

    @Override
    public boolean canUpdateAnimation(Channel channel, T animatedElement) {
        Map<String, AnimationHandler.AnimInfo> animInfoMap = this.currentAnimInfo.get(animatedElement);
        if (animInfoMap == null) {
            return false;
        }
        AnimationHandler.AnimInfo animInfo = animInfoMap.get(channel.name);
        if (animInfo == null) {
            return false;
        }
        long currentTime = System.nanoTime();
        double deltaTime = (double)(currentTime - animInfo.prevTime) / 1.0E9;
        float numberOfSkippedFrames = (float)(deltaTime * (double)channel.fps);
        float currentFrame = animInfo.currentFrame + numberOfSkippedFrames;
        if (currentFrame < (float)(channel.totalFrames - 1)) {
            animInfo.prevTime = currentTime;
            animInfo.currentFrame = currentFrame;
            return true;
        }
        if (channel.looped) {
            animInfo.prevTime = currentTime;
            animInfo.currentFrame = 0.0f;
            return true;
        }
        return false;
    }
}

