/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.detail;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Logger;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.detail.BlockCategories;
import wile.engineersdecor.detail.ModAuxiliaries;
import wile.engineersdecor.detail.ModConfig;

public class TreeCutting {
    private static Logger LOGGER = ModEngineersDecor.logger;
    private static int max_log_tracing_steps = 128;
    private static int max_cutting_height = 128;
    private static int max_cutting_radius = 12;
    private static final List<Vec3i> hoffsets = ImmutableList.of((Object)new Vec3i(1, 0, 0), (Object)new Vec3i(1, 0, 1), (Object)new Vec3i(0, 0, 1), (Object)new Vec3i(-1, 0, 1), (Object)new Vec3i(-1, 0, 0), (Object)new Vec3i(-1, 0, -1), (Object)new Vec3i(0, 0, -1), (Object)new Vec3i(1, 0, -1));

    public static void reload() {
        Compat.reload();
        max_log_tracing_steps = 128;
        max_cutting_height = 128;
        max_cutting_radius = 12;
    }

    private static List<BlockPos> findBlocksAround(World world, BlockPos centerPos, IBlockState leaf_type_state, Set<BlockPos> checked, int recursion_left) {
        ArrayList<BlockPos> to_decay = new ArrayList<BlockPos>();
        for (int y = -1; y <= 1; ++y) {
            BlockPos layer = centerPos.func_177982_a(0, y, 0);
            for (Vec3i v : hoffsets) {
                BlockPos pos = layer.func_177971_a(v);
                if (checked.contains(pos) || !BlockCategories.isSameLeaves(leaf_type_state, world.func_180495_p(pos))) continue;
                checked.add(pos);
                to_decay.add(pos);
                if (recursion_left <= 0) continue;
                to_decay.addAll(TreeCutting.findBlocksAround(world, pos, leaf_type_state, checked, recursion_left - 1));
            }
        }
        return to_decay;
    }

    private static boolean too_far(BlockPos start, BlockPos pos) {
        int dy = pos.func_177956_o() - start.func_177956_o();
        if (dy < 0 || dy > max_cutting_height) {
            return true;
        }
        int dx = Math.abs(pos.func_177958_n() - start.func_177958_n());
        int dz = Math.abs(pos.func_177952_p() - start.func_177952_p());
        if (dy > max_cutting_radius) {
            dy = max_cutting_radius;
        }
        return dx >= dy + 4 || dz >= dy + 4;
    }

    public static boolean canChop(IBlockState state) {
        return BlockCategories.isLog(state) || Compat.canChop(state);
    }

    public static int chopTree(World world, IBlockState broken_state, BlockPos startPos, int max_blocks_to_break, boolean without_target_block) {
        IBlockState state;
        if (Compat.canChop(broken_state)) {
            return Compat.chop(world, broken_state, startPos, max_blocks_to_break, without_target_block);
        }
        if (!BlockCategories.isLog(broken_state)) {
            return 0;
        }
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        ArrayList<BlockPos> to_break = new ArrayList<BlockPos>();
        ArrayList<BlockPos> to_decay = new ArrayList<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(startPos);
        int steps_left = max_log_tracing_steps;
        IBlockState tracked_leaves_state = null;
        while (!queue.isEmpty() && --steps_left >= 0 && to_break.size() < max_blocks_to_break) {
            BlockPos pos = (BlockPos)queue.removeFirst();
            if (checked.contains(pos)) continue;
            checked.add(pos);
            if (TreeCutting.too_far(startPos, pos)) continue;
            BlockPos uppos = pos.func_177984_a();
            IBlockState upstate = world.func_180495_p(uppos);
            if (BlockCategories.isSameLog(upstate, broken_state)) {
                queue.add(uppos);
                to_break.add(uppos);
                steps_left = max_log_tracing_steps;
            } else {
                boolean isleaf = BlockCategories.isLeaves(upstate);
                if (isleaf || world.func_175623_d(uppos) || upstate.func_177230_c() instanceof BlockVine) {
                    if (isleaf) {
                        if (tracked_leaves_state == null) {
                            tracked_leaves_state = upstate;
                            to_decay.add(uppos);
                            queue.add(uppos);
                        } else if (BlockCategories.isSameLeaves(upstate, tracked_leaves_state)) {
                            to_decay.add(uppos);
                            queue.add(uppos);
                        } else {
                            checked.add(uppos);
                        }
                    } else {
                        checked.add(uppos);
                    }
                    for (Vec3i v : hoffsets) {
                        BlockPos p = uppos.func_177971_a(v);
                        IBlockState st = world.func_180495_p(p);
                        if (BlockCategories.isSameLog(st, broken_state)) {
                            queue.add(p);
                            to_break.add(p);
                            continue;
                        }
                        if (BlockCategories.isLeaves(st)) {
                            if (tracked_leaves_state == null) {
                                tracked_leaves_state = st;
                                to_decay.add(p);
                                continue;
                            }
                            if (BlockCategories.isSameLeaves(st, tracked_leaves_state)) {
                                to_decay.add(p);
                                continue;
                            }
                            checked.add(uppos);
                            continue;
                        }
                        checked.add(uppos);
                    }
                }
            }
            for (Vec3i v : hoffsets) {
                BlockPos p = pos.func_177971_a(v);
                if (checked.contains(p)) continue;
                IBlockState st = world.func_180495_p(p);
                if (BlockCategories.isSameLog(st, broken_state)) {
                    queue.add(p);
                    to_break.add(p);
                    continue;
                }
                if (BlockCategories.isLeaves(st)) {
                    if (tracked_leaves_state == null || BlockCategories.isSameLeaves(st, tracked_leaves_state)) {
                        to_decay.add(p);
                        continue;
                    }
                    checked.add(p);
                    continue;
                }
                checked.add(p);
            }
        }
        for (BlockPos pos : to_decay) {
            int distance = 2;
            to_break.addAll(TreeCutting.findBlocksAround(world, pos, broken_state, checked, distance));
        }
        if (!to_decay.isEmpty()) {
            IBlockState leaf_type_state = world.func_180495_p((BlockPos)to_decay.get(0));
            ArrayList<BlockPos> leafs = to_decay;
            to_decay = new ArrayList();
            for (BlockPos pos : leafs) {
                int dist = 3;
                to_decay.add(pos);
                to_decay.addAll(TreeCutting.findBlocksAround(world, pos, leaf_type_state, checked, dist));
            }
        }
        if (without_target_block) {
            checked.remove(startPos);
        } else {
            to_break.add(startPos);
        }
        int num_broken = 0;
        Collections.reverse(to_break);
        for (BlockPos pos : to_break) {
            if (++num_broken > max_blocks_to_break) break;
            state = world.func_180495_p(pos);
            world.func_175698_g(pos);
            state.func_177230_c().func_176226_b(world, pos, state, 0);
        }
        for (BlockPos pos : to_decay) {
            if (++num_broken > max_blocks_to_break) break;
            state = world.func_180495_p(pos);
            world.func_175698_g(pos);
            state.func_177230_c().func_176226_b(world, pos, state, 0);
        }
        return MathHelper.func_76125_a((int)(to_break.size() * 6 / 5 + to_decay.size() / 10 - 1), (int)1, (int)65535);
    }

    private static class Compat {
        private static final HashMap<IBlockState, ChoppingMethod> choppable_states = new HashMap();
        public static long num_breaking_exceptions = 0L;

        private Compat() {
        }

        static void reload() {
            try {
                choppable_states.clear();
                if (ModAuxiliaries.isModLoaded("dynamictrees")) {
                    ForgeRegistries.BLOCKS.getKeys().forEach(regname -> {
                        if (!regname.func_110623_a().contains("branch")) {
                            return;
                        }
                        try {
                            Block block = (Block)ForgeRegistries.BLOCKS.getValue(regname);
                            IBlockState state = block.func_176223_P();
                            for (IProperty vaprop : state.func_177228_b().keySet()) {
                                IProperty prop;
                                Integer max;
                                if (!"radius".equals(vaprop.func_177701_a()) || vaprop.func_177699_b() != Integer.class || (max = (prop = vaprop).func_177700_c().stream().max(Integer::compare).orElse(0)) < 7) continue;
                                for (int r = 7; r <= max; ++r) {
                                    choppable_states.put(state.func_177226_a(prop, (Comparable)Integer.valueOf(r)), ChoppingMethod.RootBlockBreaking);
                                }
                            }
                        }
                        catch (Throwable e) {
                            LOGGER.warn("Failed to register chopping for " + regname.toString());
                            return;
                        }
                    });
                }
                LOGGER.info("Dynamic Trees chopping compat: " + choppable_states.size() + " choppable states found.");
                if (ModConfig.zmisc.with_experimental) {
                    for (IBlockState b : choppable_states.keySet()) {
                        ModEngineersDecor.logger.info(" - dynamic tree state: " + b);
                    }
                }
            }
            catch (Throwable e) {
                choppable_states.clear();
                LOGGER.warn("Failed to determine choppings for dynamic trees compat, skipping that:" + e);
            }
        }

        private static boolean canChop(IBlockState state) {
            return choppable_states.containsKey(state);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static int chop(World world, IBlockState state, BlockPos pos, int max_blocks_to_break, boolean without_target_block) {
            int default_expense = 5;
            switch (choppable_states.getOrDefault(state, ChoppingMethod.None)) {
                case None: {
                    return 0;
                }
                case RootBlockBreaking: {
                    if (num_breaking_exceptions >= 16L) return 5;
                    try {
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 1);
                        state.func_177230_c().func_180663_b(world, pos, state);
                        return 5;
                    }
                    catch (Throwable e) {
                        if (++num_breaking_exceptions == 1L) {
                            LOGGER.warn("Tree Chopper: There was an exception while trying to break a tree trunk (" + state.func_177230_c().getRegistryName() + "): " + e);
                        }
                        if (num_breaking_exceptions != 16L) return 5;
                        LOGGER.warn("Tree Chopper: There were 16 exceptions in total trying to chop modded trees. Feature has been disabled.");
                    }
                    return 5;
                }
            }
            return 0;
        }

        static enum ChoppingMethod {
            None,
            RootBlockBreaking;

        }
    }
}

