/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.particle;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.particle.IParticle;
import thut.core.client.render.particle.ParticleBase;
import thut.core.client.render.particle.ParticleNoGravity;
import thut.core.client.render.particle.ParticleOrientable;
import thut.core.common.ThutCore;

public class ParticleFactory {
    static final Map<Integer, IParticleFactory> particleTypes = (Map)ReflectionHelper.getPrivateValue(ParticleManager.class, (Object)Minecraft.func_71410_x().field_71452_i, (String[])new String[]{"field_178932_g", "particleTypes"});
    static final Object lock = ReflectionHelper.getPrivateValue(ParticleManager.class, (Object)Minecraft.func_71410_x().field_71452_i, (String[])new String[]{"field_187241_h", "queue"});
    private static final Map<String, IParticleFactory> factories = Maps.newHashMap();

    public static void initVanillaParticles() {
        for (Integer i : particleTypes.keySet()) {
            EnumParticleTypes vanilla = EnumParticleTypes.func_179342_a((int)i);
            if (vanilla == null) continue;
            factories.put(vanilla.func_179346_b(), particleTypes.get(i));
        }
    }

    public static void initDefaultParticles() {
    }

    public static void registerFactory(String name, IParticleFactory factory) {
        factories.put(name, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IParticle makeParticle(String name, Vector3 location, Vector3 velocity, int ... args) {
        int[][] textures;
        ParticleBase particle;
        IParticleFactory fact = factories.get(name);
        if (fact != null) {
            Particle par;
            int id = 0;
            EnumParticleTypes vanilla = null;
            vanilla = EnumParticleTypes.func_186831_a((String)name);
            if (vanilla == null && name.contains("smoke")) {
                EnumParticleTypes enumParticleTypes = vanilla = name.contains("large") ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL;
            }
            if (vanilla != null) {
                id = vanilla.func_179348_c();
            }
            if ((par = fact.func_178902_a(id, ThutCore.proxy.getWorld(), location.x, location.y, location.z, velocity.x, velocity.y, velocity.z, args)) != null) {
                if (args.length > 1) {
                    par.func_187114_a(Math.max(2, args[1]));
                }
                Object object = lock;
                synchronized (object) {
                    Minecraft.func_71410_x().field_71452_i.func_78873_a(par);
                }
                return null;
            }
        }
        ParticleBase ret = null;
        if (name.equalsIgnoreCase("string")) {
            particle = new ParticleNoGravity(8, 5);
            particle.setVelocity(velocity);
            ret = particle;
        } else if (name.equalsIgnoreCase("aurora")) {
            particle = new ParticleNoGravity(0, 0);
            particle.setVelocity(velocity);
            textures = new int[2][2];
            textures[0][0] = 2;
            textures[0][1] = 4;
            textures[1][0] = 1;
            textures[1][1] = 4;
            particle.setTex(textures);
            ((ParticleNoGravity)particle).name = "aurora";
            int life = 32;
            if (args.length > 1) {
                life = args[1];
            }
            particle.setStartTime((int)(ThutCore.proxy.getWorld().func_72820_D() % 1000L));
            particle.setAnimSpeed(1);
            particle.setLifetime(life);
            particle.setSize(0.1f);
            ret = particle;
        } else if (name.equalsIgnoreCase("misc")) {
            particle = new ParticleNoGravity(0, 0);
            particle.setVelocity(velocity);
            textures = new int[2][2];
            textures[0][0] = 2;
            textures[0][1] = 4;
            textures[1][0] = 1;
            textures[1][1] = 4;
            particle.setTex(textures);
            ((ParticleNoGravity)particle).name = "misc";
            int life = 32;
            if (args.length > 0) {
                particle.setColour(args[0]);
            }
            if (args.length > 1) {
                life = args[1];
            }
            particle.setLifetime(life);
            particle.setSize(0.15f);
            ret = particle;
        } else if (name.equalsIgnoreCase("powder")) {
            particle = new ParticleNoGravity(0, 0);
            particle.setVelocity(velocity);
            textures = new int[7][2];
            textures[0][0] = 0;
            textures[0][1] = 0;
            textures[1][0] = 1;
            textures[1][1] = 0;
            textures[2][0] = 2;
            textures[2][1] = 0;
            textures[3][0] = 3;
            textures[3][1] = 0;
            textures[4][0] = 4;
            textures[4][1] = 0;
            textures[5][0] = 5;
            textures[5][1] = 0;
            textures[6][0] = 6;
            textures[6][1] = 0;
            particle.setTex(textures);
            particle.setSize(0.125f);
            ((ParticleNoGravity)particle).name = "powder";
            int life = 32;
            if (args.length > 0) {
                particle.setColour(args[0]);
            }
            if (args.length > 1) {
                life = args[1];
            }
            particle.setLifetime(life);
            ret = particle;
        } else if (name.equalsIgnoreCase("leaf")) {
            particle = new ParticleOrientable(2, 2);
            particle.setLifetime(20);
            ((ParticleOrientable)particle).setVelocity(velocity);
            ((ParticleOrientable)particle).size = 0.25;
            if (velocity != null) {
                Vector3 normal = velocity.normalize().copy();
                Vector4 v3 = new Vector4(0.0, 1.0, 0.0, (float)(90.0 - normal.toSpherical().z * 180.0 / Math.PI));
                Vector4 v2 = new Vector4(1.0, 0.0, 0.0, (float)(90.0 + normal.y * 180.0 / Math.PI));
                ((ParticleOrientable)particle).setOrientation(v3.addAngles(v2));
            }
            ret = particle;
        } else {
            particle = new ParticleNoGravity(0, 0);
            particle.setVelocity(velocity);
            ret = particle;
        }
        return ret;
    }
}

