/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.tabula.components.Animation;
import thut.core.client.render.tabula.components.AnimationComponent;

public class AnimationHelper {
    private static final Map<UUID, Holder> holderMap = Maps.newHashMap();

    public static CapabilityAnimation.IAnimationHolder getHolder(Entity mob) {
        if (mob.hasCapability(CapabilityAnimation.CAPABILITY, null)) {
            return (CapabilityAnimation.IAnimationHolder)mob.getCapability(CapabilityAnimation.CAPABILITY, null);
        }
        if (holderMap.containsKey(mob.func_110124_au())) {
            return holderMap.get(holderMap.get(mob.func_110124_au()));
        }
        Holder holder = new Holder();
        holderMap.put(mob.func_110124_au(), holder);
        return holder;
    }

    public static boolean doAnimation(List<Animation> list, Entity entity, String partName, IExtendedModelPart part, float partialTick, float limbSwing) {
        boolean animate = false;
        CapabilityAnimation.IAnimationHolder holder = AnimationHelper.getHolder(entity);
        if (holder != null) {
            for (Animation animation : list) {
                animate = AnimationHelper.animate(animation, holder, partName, part, partialTick, limbSwing, entity.field_70173_aa) || animate;
            }
        }
        return animate;
    }

    public static boolean animate(Animation animation, CapabilityAnimation.IAnimationHolder animate, String partName, IExtendedModelPart part, float partialTick, float limbSwing, int tick) {
        ArrayList<AnimationComponent> components = animation.getComponents(partName);
        boolean animated = false;
        Vector3 temp = Vector3.getNewVector();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float sx = 1.0f;
        float sy = 1.0f;
        float sz = 1.0f;
        int aniTick = animate.getStep(animation);
        if (aniTick == 0) {
            aniTick = tick;
        }
        float time1 = aniTick;
        float time2 = 0.0f;
        int animationLength = animation.getLength();
        float limbSpeedFactor = 1.0f;
        time1 = (time1 + partialTick) % (float)animationLength;
        time2 = limbSwing * limbSpeedFactor % (float)animationLength;
        animate.setStep(animation, tick);
        if (components != null) {
            for (AnimationComponent component : components) {
                float f = component.limbBased ? time2 : time1;
                float time = f;
                if (!(time >= (float)component.startKey)) continue;
                animated = true;
                float componentTimer = time - (float)component.startKey;
                if (componentTimer > (float)component.length) {
                    componentTimer = component.length;
                }
                temp.addTo(component.posChange[0] / (double)component.length * (double)componentTimer + component.posOffset[0], component.posChange[1] / (double)component.length * (double)componentTimer + component.posOffset[1], component.posChange[2] / (double)component.length * (double)componentTimer + component.posOffset[2]);
                x += (float)(component.rotChange[0] / (double)component.length * (double)componentTimer + component.rotOffset[0]);
                y += (float)(component.rotChange[1] / (double)component.length * (double)componentTimer + component.rotOffset[1]);
                z += (float)(component.rotChange[2] / (double)component.length * (double)componentTimer + component.rotOffset[2]);
                sx += (float)(component.scaleChange[0] / (double)component.length * (double)componentTimer + component.scaleOffset[0]);
                sy += (float)(component.scaleChange[1] / (double)component.length * (double)componentTimer + component.scaleOffset[1]);
                sz += (float)(component.scaleChange[2] / (double)component.length * (double)componentTimer + component.scaleOffset[2]);
                part.setHidden(component.hidden);
            }
        }
        if (animated) {
            part.setPreTranslations(temp);
            part.setPreScale(temp.set(sx, sy, sz));
            Vector4 angle = null;
            if (z != 0.0f) {
                angle = new Vector4(0.0, 0.0, 1.0, z);
            }
            if (x != 0.0f) {
                angle = angle != null ? angle.addAngles(new Vector4(1.0, 0.0, 0.0, x)) : new Vector4(1.0, 0.0, 0.0, x);
            }
            if (y != 0.0f) {
                angle = angle != null ? angle.addAngles(new Vector4(0.0, 1.0, 0.0, y)) : new Vector4(0.0, 1.0, 0.0, y);
            }
            if (angle != null) {
                part.setPreRotations(angle);
            }
        }
        return animated;
    }

    private static class Holder
    implements CapabilityAnimation.IAnimationHolder {
        Map<UUID, Integer> stepsMap = Maps.newHashMap();
        Set<Animation> playing = Sets.newHashSet();
        private String pending = "idle";
        private String current = "idle";

        private Holder() {
        }

        @Override
        public int getStep(Animation animation) {
            if (this.stepsMap.containsKey(animation.id)) {
                return this.stepsMap.get(animation.id);
            }
            return 0;
        }

        @Override
        public void setStep(Animation animation, int step) {
            this.stepsMap.put(animation.id, step);
        }

        @Override
        public void clean() {
            this.stepsMap.clear();
            this.current = "idle";
            this.pending = "idle";
            this.playing.clear();
        }

        @Override
        public void setPendingAnimation(String name) {
            this.pending = name;
        }

        @Override
        public String getPendingAnimation() {
            return this.pending;
        }

        @Override
        public Set<Animation> getPlaying() {
            return this.playing;
        }

        @Override
        public void setCurrentAnimation(String name) {
            this.current = name;
        }

        @Override
        public String getCurrentAnimation() {
            return this.current;
        }
    }
}

