/*
 * Decompiled with CFR 0.152.
 */
package thut.api.world.utils;

public interface Vector<T extends Number>
extends Comparable<Vector<T>> {
    public T[] getVector();

    public int getDim();

    public void subtract(Vector<T> var1);

    public void add(Vector<T> var1);

    default public double dot(Vector<T> other) {
        if (other.getDim() != this.getDim()) {
            throw new IllegalArgumentException("must be same dimensionality to dot.");
        }
        double l = 0.0;
        Number[] others = other.getVector();
        Number[] ours = this.getVector();
        for (int i = 0; i < ours.length; ++i) {
            double val1 = others[i].doubleValue();
            double val2 = ours[i].doubleValue();
            l += val1 * val2;
        }
        return l;
    }

    default public double normSq() {
        return this.dot(this);
    }

    default public double norm() {
        return Math.sqrt(this.normSq());
    }

    default public Vector<T> setValue(int index, T value) {
        this.getVector()[index] = value;
        return this;
    }

    default public T getValue(int index) {
        return (T)this.getVector()[index];
    }
}

