/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.CapabilityExtendedHealthSystem;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.common.damagesystem.distribution.DamageDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.HealthDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.RandomDamageDistribution;
import ichttt.mods.firstaid.common.network.MessageApplyAbsorption;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DataManagerWrapper
extends EntityDataManager {
    private final EntityPlayer player;
    private final EntityDataManager parent;
    private boolean track = true;

    public DataManagerWrapper(EntityPlayer player, EntityDataManager parent) {
        super((Entity)player);
        this.player = player;
        this.parent = parent;
    }

    @Nonnull
    public <T> T func_187225_a(@Nonnull DataParameter<T> key) {
        if (key == EntityPlayer.field_184829_a) {
            this.parent.func_187227_b(key, (Object)((AbstractPlayerDamageModel)Objects.requireNonNull(this.player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null))).getAbsorption());
        }
        return (T)this.parent.func_187225_a(key);
    }

    public <T> void set_impl(@Nonnull DataParameter<T> key, @Nonnull T value) {
        this.parent.func_187227_b(key, value);
    }

    public <T> void func_187227_b(@Nonnull DataParameter<T> key, @Nonnull T value) {
        if (!this.track) {
            if (key != EntityLivingBase.field_184632_c) {
                this.set_impl(key, value);
            }
            return;
        }
        if (key == EntityPlayer.field_184829_a) {
            float floatValue = ((Float)value).floatValue();
            if (this.player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)this.player;
                if (playerMP.field_71135_a != null) {
                    FirstAid.NETWORKING.sendTo((IMessage)new MessageApplyAbsorption(floatValue), playerMP);
                }
            }
            ((AbstractPlayerDamageModel)Objects.requireNonNull(this.player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null))).setAbsorption(floatValue);
        } else if (key == EntityLivingBase.field_184632_c && value instanceof Float && !this.player.field_70170_p.field_72995_K) {
            float aFloat = ((Float)value).floatValue();
            if (aFloat > this.player.func_110138_aP()) {
                ((AbstractPlayerDamageModel)Objects.requireNonNull(this.player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null))).forEach(damageablePart -> {
                    damageablePart.currentHealth = damageablePart.getMaxHealth();
                });
            } else {
                float orig;
                AbstractPlayerDamageModel damageModel = (AbstractPlayerDamageModel)this.player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null);
                if (damageModel != null && damageModel.isWaitingForHelp()) {
                    if (FirstAidConfig.debug) {
                        CommonUtils.debugLogStacktrace("SetHealth falltrough");
                    }
                } else if (FirstAidConfig.watchSetHealth && !Float.isInfinite(aFloat) && !Float.isNaN(aFloat) && aFloat > 0.0f && this.player instanceof EntityPlayerMP && ((EntityPlayerMP)this.player).field_71135_a != null && (orig = ((Float)this.func_187225_a(EntityLivingBase.field_184632_c)).floatValue()) > 0.0f && !Float.isNaN(orig) && !Float.isInfinite(orig)) {
                    float healed;
                    if (FirstAidConfig.scaleMaxHealth) {
                        orig = Math.min(orig, (float)this.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e());
                    }
                    if ((double)Math.abs(healed = aFloat - orig) > 0.001) {
                        if (healed < 0.0f) {
                            if (FirstAidConfig.debug) {
                                CommonUtils.debugLogStacktrace("DAMAGING: " + -healed);
                            }
                            DamageDistribution.handleDamageTaken(RandomDamageDistribution.getDefault(), (AbstractPlayerDamageModel)this.player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null), -healed, this.player, DamageSource.field_76376_m, true, true);
                        } else {
                            if (FirstAidConfig.debug) {
                                CommonUtils.debugLogStacktrace("HEALING: " + healed);
                            }
                            HealthDistribution.addRandomHealth(healed, this.player, true);
                        }
                    }
                    return;
                }
            }
        }
        this.set_impl(key, value);
    }

    public void toggleTracking(boolean status) {
        if (FirstAidConfig.debug) {
            CommonUtils.debugLogStacktrace("Tracking status change from " + this.track + " to " + status);
        }
        this.track = status;
    }

    public <T> void func_187214_a(DataParameter<T> key, @Nonnull T value) {
        this.parent.func_187214_a(key, value);
    }

    public <T> void func_187217_b(@Nonnull DataParameter<T> key) {
        this.parent.func_187217_b(key);
    }

    public boolean func_187223_a() {
        return this.parent.func_187223_a();
    }

    @Nullable
    public List<EntityDataManager.DataEntry<?>> func_187221_b() {
        return this.parent.func_187221_b();
    }

    public void func_187216_a(PacketBuffer buf) throws IOException {
        this.parent.func_187216_a(buf);
    }

    @Nullable
    public List<EntityDataManager.DataEntry<?>> func_187231_c() {
        return this.parent.func_187231_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_187218_a(List<EntityDataManager.DataEntry<?>> entriesIn) {
        this.parent.func_187218_a(entriesIn);
    }

    @SideOnly(value=Side.CLIENT)
    public <T> void func_187224_a(EntityDataManager.DataEntry<T> target, EntityDataManager.DataEntry<?> source) {
        this.parent.func_187224_a(target, source);
    }

    public boolean func_187228_d() {
        return this.parent.func_187228_d();
    }

    public void func_187230_e() {
        this.parent.func_187230_e();
    }

    @Nonnull
    public <T> EntityDataManager.DataEntry<T> func_187219_c(DataParameter<T> key) {
        return this.parent.func_187219_c(key);
    }
}

