/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.api.enums;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.EntityEquipmentSlot;

public enum EnumPlayerPart {
    HEAD(EntityEquipmentSlot.HEAD),
    LEFT_ARM(EntityEquipmentSlot.CHEST),
    LEFT_LEG(EntityEquipmentSlot.LEGS),
    LEFT_FOOT(EntityEquipmentSlot.FEET),
    BODY(EntityEquipmentSlot.CHEST),
    RIGHT_ARM(EntityEquipmentSlot.CHEST),
    RIGHT_LEG(EntityEquipmentSlot.LEGS),
    RIGHT_FOOT(EntityEquipmentSlot.FEET);

    public static final EnumPlayerPart[] VALUES;
    public final byte id = (byte)(this.ordinal() + 1);
    private ImmutableList<EnumPlayerPart> neighbours;
    public final EntityEquipmentSlot slot;

    private EnumPlayerPart(EntityEquipmentSlot slot) {
        this.slot = slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<EnumPlayerPart> getNeighbours() {
        if (this.neighbours == null) {
            EnumPlayerPart enumPlayerPart = this;
            synchronized (enumPlayerPart) {
                if (this.neighbours == null) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.addAll(this.getNeighboursDown());
                    builder.addAll(this.getNeighboursUp());
                    builder.addAll(this.getNeighboursLeft());
                    builder.addAll(this.getNeighboursRight());
                    this.neighbours = builder.build();
                }
            }
        }
        return this.neighbours;
    }

    public static EnumPlayerPart fromID(int id) {
        switch (id) {
            case 1: {
                return HEAD;
            }
            case 2: {
                return LEFT_ARM;
            }
            case 3: {
                return LEFT_LEG;
            }
            case 4: {
                return LEFT_FOOT;
            }
            case 5: {
                return BODY;
            }
            case 6: {
                return RIGHT_ARM;
            }
            case 7: {
                return RIGHT_LEG;
            }
            case 8: {
                return RIGHT_FOOT;
            }
        }
        throw new IndexOutOfBoundsException("Invalid id " + id);
    }

    @Nonnull
    private List<EnumPlayerPart> getNeighboursUp() {
        switch (this) {
            case BODY: {
                return Collections.singletonList(HEAD);
            }
            case LEFT_LEG: 
            case RIGHT_LEG: {
                return Collections.singletonList(BODY);
            }
            case LEFT_FOOT: {
                return Collections.singletonList(LEFT_LEG);
            }
            case RIGHT_FOOT: {
                return Collections.singletonList(RIGHT_LEG);
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<EnumPlayerPart> getNeighboursDown() {
        switch (this) {
            case HEAD: {
                return Collections.singletonList(BODY);
            }
            case BODY: {
                return Arrays.asList(LEFT_LEG, RIGHT_LEG);
            }
            case LEFT_LEG: {
                return Collections.singletonList(LEFT_FOOT);
            }
            case RIGHT_LEG: {
                return Collections.singletonList(RIGHT_FOOT);
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<EnumPlayerPart> getNeighboursLeft() {
        switch (this) {
            case RIGHT_ARM: {
                return Collections.singletonList(BODY);
            }
            case RIGHT_LEG: {
                return Collections.singletonList(LEFT_LEG);
            }
            case RIGHT_FOOT: {
                return Collections.singletonList(LEFT_FOOT);
            }
            case BODY: {
                return Collections.singletonList(LEFT_ARM);
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<EnumPlayerPart> getNeighboursRight() {
        switch (this) {
            case LEFT_ARM: {
                return Collections.singletonList(BODY);
            }
            case LEFT_LEG: {
                return Collections.singletonList(RIGHT_LEG);
            }
            case LEFT_FOOT: {
                return Collections.singletonList(RIGHT_FOOT);
            }
            case BODY: {
                return Collections.singletonList(RIGHT_ARM);
            }
        }
        return Collections.emptyList();
    }

    @Deprecated
    public EnumPlayerPart getUp() {
        if (this.id == 5) {
            throw new IndexOutOfBoundsException("There is no part up from " + this.id);
        }
        return EnumPlayerPart.fromID(this.id - 1);
    }

    @Deprecated
    public EnumPlayerPart getDown() {
        if (this.id == 4) {
            throw new IndexOutOfBoundsException("There is no part down from " + this.id);
        }
        return EnumPlayerPart.fromID(this.id + 1);
    }

    @Deprecated
    public EnumPlayerPart getLeft() {
        return EnumPlayerPart.fromID(this.id - 4);
    }

    @Deprecated
    public EnumPlayerPart getRight() {
        return EnumPlayerPart.fromID(this.id + 4);
    }

    static {
        for (EnumPlayerPart value : VALUES = EnumPlayerPart.values()) {
            ImmutableList<EnumPlayerPart> neighbours = value.getNeighbours();
            if (neighbours.contains((Object)value)) {
                throw new RuntimeException((Object)((Object)value) + " contains itself as a neighbour!");
            }
            if (neighbours.isEmpty()) {
                throw new RuntimeException((Object)((Object)value) + " does not have any neighbours!");
            }
            if (EnumSet.copyOf(neighbours).size() != neighbours.size()) {
                throw new RuntimeException((Object)((Object)value) + " neighbours contain the same part multiple times!");
            }
            EnumSet<EnumPlayerPart> hopefullyAllParts = EnumSet.copyOf(neighbours);
            int oldSize = -1;
            while (oldSize != hopefullyAllParts.size()) {
                oldSize = hopefullyAllParts.size();
                EnumSet<EnumPlayerPart> neighboursOfNeighbours = EnumSet.noneOf(EnumPlayerPart.class);
                for (EnumPlayerPart part : hopefullyAllParts) {
                    neighboursOfNeighbours.addAll((Collection<EnumPlayerPart>)part.getNeighbours());
                }
                hopefullyAllParts.addAll(neighboursOfNeighbours);
            }
            if (hopefullyAllParts.size() == VALUES.length) continue;
            throw new RuntimeException((Object)((Object)value) + " could not read all player parts " + Arrays.toString((Object[])hopefullyAllParts.toArray(new EnumPlayerPart[0])));
        }
    }
}

