/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.item;

import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.render.ExpireableMap;
import cam72cam.immersiverailroading.render.rail.RailRender;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.PlacementInfo;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.render.GlobalRender;
import cam72cam.mod.render.ItemRender;
import cam72cam.mod.render.StandardModel;
import cam72cam.mod.render.opengl.BlendMode;
import cam72cam.mod.render.opengl.RenderState;
import cam72cam.mod.world.World;

public class TrackBlueprintItemModel
implements ItemRender.IItemModel {
    private static ExpireableMap<String, RailInfo> infoCache = new ExpireableMap();

    public StandardModel getModel(World world, ItemStack stack) {
        return new StandardModel().addCustom((state, pt) -> TrackBlueprintItemModel.render(stack, world, state));
    }

    public static void render(ItemStack stack, World world, RenderState state) {
        RailInfo info = new RailInfo(stack, new PlacementInfo(stack, 1.0f, new Vec3d(0.5, 0.5, 0.5)), null);
        info = info.withSettings(b -> {
            b.length = 10;
        });
        state.cull_face(false);
        state.lighting(false);
        if (info.settings.type == TrackItems.TURN || info.settings.type == TrackItems.SWITCH) {
            state.translate(0.0, 0.0, -0.1 * (double)(info.settings.degrees / 90.0f * 4.0f));
        }
        state.translate(0.5, 0.0, 0.5);
        state.rotate(-90.0, 1.0, 0.0, 0.0);
        double scale = 0.95 / (double)info.settings.length;
        if (info.settings.type == TrackItems.CROSSING) {
            scale = 0.31666666666666665;
        }
        if (info.settings.type == TrackItems.TURNTABLE) {
            scale *= 0.25;
        }
        state.scale(-scale, -scale * 2.0, scale);
        state.translate(0.5, 0.0, 0.5);
        RailRender.get(info).renderRailModel(state);
        state.translate(-0.5, 0.0, -0.5);
        RailRender.get(info).renderRailBase(state);
    }

    public static void renderMouseover(Player player, ItemStack stack, Vec3i pos, Vec3d vec, RenderState state, float partialTicks) {
        Vec3d hit = vec.subtract(pos);
        World world = player.getWorld();
        if (BlockUtil.canBeReplaced(world, (pos = pos.up()).down(), true) && (!BlockUtil.isIRRail(world, pos.down()) || (double)((TileRailBase)world.getBlockEntity(pos.down(), TileRailBase.class)).getRailHeight() < 0.5)) {
            pos = pos.down();
        }
        RailInfo info = new RailInfo(stack, new PlacementInfo(stack, player.getRotationYawHead(), hit.subtract(0.0, hit.y, 0.0)), null);
        String key = info.uniqueID + info.placementInfo.placementPosition;
        RailInfo cached = infoCache.get(key);
        if (cached != null) {
            info = cached;
        } else {
            infoCache.put(key, info);
        }
        state.blend(new BlendMode(32771, 1).constantColor(1.0f, 1.0f, 1.0f, 0.5f)).lightmap(1.0f, 1.0f);
        Vec3d cameraPos = GlobalRender.getCameraPos((float)partialTicks);
        Vec3d offPos = info.placementInfo.placementPosition.add(pos).subtract(cameraPos);
        state.translate(offPos.x, offPos.y, offPos.z);
        RailRender.render(info, world, pos, true, state);
    }
}

