/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.multiblock.Multiblock;
import cam72cam.immersiverailroading.multiblock.MultiblockRegistry;
import cam72cam.immersiverailroading.thirdparty.CompatLoader;
import cam72cam.immersiverailroading.util.IRFuzzy;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.CreativeTab;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Rotation;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.serialization.TagMapper;
import cam72cam.mod.text.PlayerMessage;
import cam72cam.mod.util.Facing;
import cam72cam.mod.world.World;
import java.util.Collections;
import java.util.List;

public class ItemManual
extends CustomItem {
    public ItemManual() {
        super("immersiverailroading", "item_manual");
        Fuzzy steel = Fuzzy.STEEL_INGOT;
        IRFuzzy.registerSteelRecipe(this, 3, steel, null, steel, steel, Fuzzy.BOOK, steel, steel, null, steel);
    }

    public int getStackSize() {
        return 1;
    }

    public List<CreativeTab> getCreativeTabs() {
        return Collections.singletonList(ItemTabs.MAIN_TAB);
    }

    public List<String> getTooltip(ItemStack stack) {
        Multiblock mb = new Data((ItemStack)stack).multiblock;
        if (mb == null) {
            return super.getTooltip(stack);
        }
        return Collections.singletonList(GuiText.SELECTOR_TYPE.toString(mb.getName()));
    }

    public void onClickAir(Player player, World world, Player.Hand hand) {
        if (player.isCrouching()) {
            if (world.isServer) {
                ItemStack item = player.getHeldItem(hand);
                Data data = new Data(item);
                List<Multiblock> keys = MultiblockRegistry.registered();
                data.multiblock = keys.get((keys.indexOf(data.multiblock) + 1) % keys.size());
                data.write();
                player.sendMessage(PlayerMessage.direct((String)("Placing: " + data.multiblock.getName())));
            }
        } else if (world.isClient && !CompatLoader.openWiki()) {
            player.sendMessage(PlayerMessage.url((String)"https://github.com/cam72cam/ImmersiveRailroading/wiki"));
        }
    }

    public ClickResult onClickBlock(Player player, World world, Vec3i pos, Player.Hand hand, Facing facing, Vec3d hit) {
        if (world.isServer) {
            ItemStack item = player.getHeldItem(hand);
            Multiblock current = new Data((ItemStack)item).multiblock;
            if (current == null) {
                return ClickResult.ACCEPTED;
            }
            Vec3i realPos = pos;
            if (facing == Facing.DOWN) {
                realPos = realPos.down();
            }
            if (facing == Facing.UP) {
                realPos = realPos.up();
            }
            current.place(world, player, realPos, Rotation.from((Facing)Facing.fromAngle((float)(player.getYawHead() + 180.0f))));
        }
        return ClickResult.ACCEPTED;
    }

    public static class Data
    extends CustomItem.ItemDataSerializer {
        @TagField(value="name", mapper=MBTagMapper.class)
        public Multiblock multiblock;

        public Data(ItemStack stack) {
            super(stack);
            if (this.multiblock == null) {
                this.multiblock = MultiblockRegistry.registered().isEmpty() ? null : MultiblockRegistry.registered().get(0);
            }
        }

        private static class MBTagMapper
        implements TagMapper<Multiblock> {
            private MBTagMapper() {
            }

            public TagMapper.TagAccessor<Multiblock> apply(Class<Multiblock> type, String fieldName, TagField tag) {
                return new TagMapper.TagAccessor((d, m) -> d.setString(fieldName, m != null ? m.getName() : null), d -> {
                    String name = d.getString(fieldName);
                    return name != null ? MultiblockRegistry.get(name) : null;
                });
            }
        }
    }
}

