/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity.physics;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.physics.Simulation;
import cam72cam.immersiverailroading.entity.physics.SimulationState;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.serialization.TagMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class Consist {
    static boolean debug = false;
    public List<UUID> ids;
    public List<Vec3i> positions;

    public static void iterate(Map<UUID, SimulationState> states, Map<UUID, SimulationState> nextStateMap, List<Vec3i> blocksAlreadyBroken) {
        debug = false;
        ArrayList particles = new ArrayList();
        ArrayList used = new ArrayList();
        if (!states.isEmpty() && debug) {
            System.out.println("=============BOUNDARY==========");
        }
        for (SimulationState state : states.values()) {
            if (used.contains(state)) continue;
            SimulationState current = state;
            boolean direction = true;
            ArrayList<SimulationState> visited = new ArrayList<SimulationState>();
            while (!visited.contains(current)) {
                SimulationState next;
                visited.add(current);
                UUID nextId = direction ? current.interactingFront : current.interactingRear;
                SimulationState simulationState = next = nextId != null ? states.get(nextId) : null;
                if (next == null) break;
                if (!current.config.id.equals(direction ? next.interactingRear : next.interactingFront)) {
                    direction = !direction;
                }
                current = next;
            }
            direction = !direction;
            ArrayList<Object> consist = new ArrayList<Object>();
            Particle prevParticle = null;
            visited.clear();
            while (!visited.contains(current)) {
                SimulationState simulationState;
                visited.add(current);
                Particle currParticle = new Particle(current, direction);
                consist.add(currParticle);
                if (prevParticle != null) {
                    Linkage link;
                    prevParticle.nextLink = link = new Linkage(prevParticle, currParticle);
                    currParticle.prevLink = link;
                }
                UUID nextId = direction ? current.interactingFront : current.interactingRear;
                SimulationState simulationState2 = simulationState = nextId != null ? states.get(nextId) : null;
                if (simulationState == null) break;
                if (!current.config.id.equals(direction ? simulationState.interactingRear : simulationState.interactingFront)) {
                    direction = !direction;
                }
                current = simulationState;
                prevParticle = currParticle;
            }
            for (Object particle : consist) {
                if (((Particle)particle).nextLink == null) continue;
                ((Particle)particle).nextLink.setup();
            }
            ArrayList<SimulationState> linked = new ArrayList<SimulationState>();
            for (Particle particle : consist) {
                linked.add(particle.state);
                if (particle.nextLink != null && particle.nextLink.coupled && particle.state.config.hasPressureBrake) continue;
                float desiredBrakePressure = (float)linked.stream().filter(s -> s.config.desiredBrakePressure != null).mapToDouble(s -> s.config.desiredBrakePressure).max().orElse(0.0);
                boolean needsBrakeEqualization = linked.stream().anyMatch(s -> s.config.hasPressureBrake && (double)Math.abs(s.brakePressure - desiredBrakePressure) > 0.01);
                if (needsBrakeEqualization) {
                    double d = 0.1 / (double)linked.stream().filter(s -> s.config.hasPressureBrake).count();
                    linked.forEach(p -> {
                        if (p.config.hasPressureBrake) {
                            p.brakePressure = Config.ImmersionConfig.instantBrakePressure ? desiredBrakePressure : ((double)p.brakePressure > (double)desiredBrakePressure + brakePressureDelta ? (float)((double)p.brakePressure - brakePressureDelta) : ((double)p.brakePressure < (double)desiredBrakePressure - brakePressureDelta ? (float)((double)p.brakePressure + brakePressureDelta) : desiredBrakePressure));
                        }
                    });
                }
                linked.clear();
            }
            boolean dirty = consist.stream().anyMatch(p -> p.state.dirty);
            boolean bl = consist.stream().allMatch(p -> p.state.atRest());
            boolean missingNextStates = consist.stream().anyMatch(p -> !nextStateMap.containsKey(p.state.config.id));
            if (dirty) {
                consist.forEach(p -> {
                    p.state.dirty = true;
                });
            }
            if (bl && !dirty) {
                for (Particle particle : consist) {
                    nextStateMap.put(particle.state.config.id, particle.state.next());
                }
                Simulation.restStates += consist.size();
            } else if (dirty || missingNextStates) {
                particles.addAll(consist);
                Simulation.calculatedStates += consist.size();
            } else {
                Simulation.keptStates += consist.size();
            }
            consist.forEach(p -> {
                p.state.atRest = atRest;
            });
            if (dirty) {
                Consist c = new Consist(consist.stream().map(x -> x.state.config.id).collect(Collectors.toList()), consist.stream().map(x -> new Vec3i(x.state.position)).collect(Collectors.toList()));
                consist.forEach(p -> {
                    p.state.consist = c;
                });
            }
            used.addAll(visited);
        }
        double ticksPerSecond = 20.0;
        double stepsPerTick = 40.0;
        double dt_S = 1.0 / (ticksPerSecond * stepsPerTick);
        int i = 0;
        while ((double)i < stepsPerTick) {
            particles.forEach(Particle::setup);
            if (debug) {
                String s2 = "";
                for (Particle particle : particles) {
                    s2 = s2 + String.format("[%s = %.3f]", particle.hashCode(), particle.velocity_M_S);
                    if (particle.nextLink != null) {
                        if (particle.nextLink.canPush) {
                            s2 = s2 + " >< ";
                            continue;
                        }
                        if (particle.nextLink.canPull) {
                            s2 = s2 + " <> ";
                            continue;
                        }
                        s2 = s2 + String.format(" %.2f ", particle.nextLink.currentDistance_M - particle.nextLink.minDistance_M);
                        continue;
                    }
                    ImmersiveRailroading.info((String)s2, (Object[])new Object[0]);
                    s2 = "";
                }
                if (!s2.isEmpty()) {
                    ImmersiveRailroading.info((String)s2, (Object[])new Object[0]);
                }
            }
            particles.forEach(p -> p.computeVelocity(dt_S));
            particles.forEach(p -> p.applyFriction(dt_S));
            particles.forEach(Particle::processCollisions);
            particles.forEach(p -> p.applyFriction(dt_S));
            particles.forEach(p -> p.computePosition(dt_S));
            ++i;
        }
        try {
            for (Particle particle : particles) {
                nextStateMap.put(particle.state.config.id, particle.applyToState(blocksAlreadyBroken));
            }
        }
        catch (Exception ex) {
            for (SimulationState state : states.values()) {
                ImmersiveRailroading.debug((String)"State: %s (%s, %s)", (Object[])new Object[]{state.config.id, state.interactingFront, state.interactingRear});
            }
            for (Particle particle : particles) {
                ImmersiveRailroading.debug((String)"Particle: %s (%s, %s)", (Object[])new Object[]{particle.state.config.id, particle.state.interactingFront, particle.state.interactingRear});
            }
            throw ex;
        }
    }

    public Consist(List<UUID> consistIDs, List<Vec3i> consistPositions) {
        this.ids = consistIDs;
        this.positions = consistPositions;
    }

    public static class TagMapper
    implements cam72cam.mod.serialization.TagMapper<Consist> {
        public TagMapper.TagAccessor<Consist> apply(Class<Consist> type, String fieldName, TagField tag) {
            return new TagMapper.TagAccessor<Consist>((d, o) -> {
                if (o != null) {
                    d.set(fieldName, new TagCompound().setList("ids", o.ids, u -> new TagCompound().setUUID("id", u)).setList("pos", o.positions, p -> new TagCompound().setVec3i("p", p)));
                }
            }, d -> d.hasKey(fieldName) ? new Consist(d.get(fieldName).getList("ids", t -> t.getUUID("id")), d.get(fieldName).getList("pos", t -> t.getVec3i("p"))) : new Consist(Collections.emptyList(), Collections.emptyList())){

                public boolean applyIfMissing() {
                    return true;
                }
            };
        }
    }

    public static class Linkage {
        private final Particle prevParticle;
        private final Particle nextParticle;
        public double minDistance_M;
        public double maxDistance_M;
        public boolean coupled;
        private double currentDistance_M;
        private boolean canPush;
        private boolean canPull;

        public Linkage(Particle prev, Particle next) {
            this.prevParticle = prev;
            this.nextParticle = next;
        }

        public void setup() {
            Particle prev = this.prevParticle;
            Particle next = this.nextParticle;
            boolean prevCouplerFront = next.state.config.id.equals(prev.state.interactingFront);
            boolean nextCouplerFront = prev.state.config.id.equals(next.state.interactingFront);
            double maxCouplerDistance = (prevCouplerFront ? prev.state.config.couplerSlackFront : prev.state.config.couplerSlackRear) + (nextCouplerFront ? next.state.config.couplerSlackFront : next.state.config.couplerSlackRear);
            boolean prevEngaged = prevCouplerFront ? prev.state.config.couplerEngagedFront : prev.state.config.couplerEngagedRear;
            boolean nextEngaged = nextCouplerFront ? next.state.config.couplerEngagedFront : next.state.config.couplerEngagedRear;
            Vec3d prevPos = prev.state.position;
            Vec3d nextPos = next.state.position;
            Vec3d prevCoupler = prevCouplerFront ? this.prevParticle.state.couplerPositionFront : this.prevParticle.state.couplerPositionRear;
            Vec3d nextCoupler = nextCouplerFront ? this.nextParticle.state.couplerPositionFront : this.nextParticle.state.couplerPositionRear;
            double prevLength = prevCoupler.distanceTo(prevPos);
            double nextLength = nextCoupler.distanceTo(nextPos);
            double couplerDistance = (prevPos.distanceTo(nextCoupler) - prevPos.distanceTo(prevCoupler) + (nextPos.distanceTo(prevCoupler) - nextPos.distanceTo(nextCoupler))) / 2.0;
            double totalLength = prevLength + nextLength + couplerDistance;
            this.nextParticle.initial_position_M = this.nextParticle.position_M = this.prevParticle.position_M + totalLength;
            this.minDistance_M = prevLength + nextLength - maxCouplerDistance;
            this.maxDistance_M = prevLength + nextLength + maxCouplerDistance;
            boolean bl = this.coupled = prevEngaged && nextEngaged;
            if (maxCouplerDistance == 0.0) {
                this.correctDistance();
            } else if (nextCouplerFront ? next.state.frontPushing : next.state.rearPushing) {
                double delta = this.nextParticle.position_M - (this.prevParticle.position_M + this.minDistance_M);
                if (Math.abs(delta) > 0.01 && debug) {
                    ImmersiveRailroading.info((String)"DELTA PUSH %s : %s + %s + %s = %s vs %s :: %s vs %s ?? %s %s", (Object[])new Object[]{delta, prevLength, nextLength, couplerDistance, totalLength, this.minDistance_M, prevCoupler, nextCoupler, prevPos.distanceTo(prevCoupler) - prevPos.distanceTo(nextCoupler), nextPos.distanceTo(prevCoupler) - nextPos.distanceTo(nextCoupler)});
                }
                this.nextParticle.position_M = this.prevParticle.position_M + this.minDistance_M;
            } else if (nextCouplerFront ? next.state.frontPulling : next.state.rearPulling) {
                double delta = this.nextParticle.position_M - (this.prevParticle.position_M + this.maxDistance_M);
                if (Math.abs(delta) > 0.01 && debug) {
                    ImmersiveRailroading.info((String)"DELTA PULL %s : %s + %s + %s = %s vs %s :: %s vs %s ?? %s %s", (Object[])new Object[]{delta, prevLength, nextLength, couplerDistance, totalLength, this.maxDistance_M, prevCoupler, nextCoupler, prevPos.distanceTo(prevCoupler) - prevPos.distanceTo(nextCoupler), nextPos.distanceTo(prevCoupler) - nextPos.distanceTo(nextCoupler)});
                }
                this.nextParticle.position_M = this.prevParticle.position_M + this.maxDistance_M;
            }
        }

        public void update() {
            double epsilon = 1.0E-6;
            this.currentDistance_M = this.nextParticle.position_M - this.prevParticle.position_M;
            this.canPush = this.currentDistance_M - this.minDistance_M <= epsilon || this.minDistance_M == this.maxDistance_M;
            boolean bl = this.canPull = this.coupled && (this.currentDistance_M - this.maxDistance_M >= -epsilon || this.minDistance_M == this.maxDistance_M);
            if (debug) {
                // empty if block
            }
        }

        public void correctDistance() {
            this.currentDistance_M = this.nextParticle.position_M - this.prevParticle.position_M;
            if (this.currentDistance_M - this.minDistance_M < -0.001) {
                if (debug) {
                    ImmersiveRailroading.info((String)"CORRECTION %s %s%n", (Object[])new Object[]{this.nextParticle.hashCode(), this.currentDistance_M - this.minDistance_M});
                }
                this.nextParticle.position_M = this.prevParticle.position_M + this.minDistance_M;
                if (this.nextParticle.velocity_M_S < this.prevParticle.velocity_M_S) {
                    // empty if block
                }
            }
            if (this.currentDistance_M - this.maxDistance_M > 0.001 && this.coupled) {
                if (debug) {
                    ImmersiveRailroading.info((String)"CORRECTION %s %s%n", (Object[])new Object[]{this.nextParticle.hashCode(), this.currentDistance_M - this.maxDistance_M});
                }
                this.nextParticle.position_M = this.prevParticle.position_M + this.maxDistance_M;
                if (this.nextParticle.velocity_M_S > this.prevParticle.velocity_M_S) {
                    // empty if block
                }
            }
        }

        public double slackPercent() {
            return this.maxDistance_M - this.minDistance_M > 0.0 ? (this.currentDistance_M - this.minDistance_M) / (this.maxDistance_M - this.minDistance_M) : 0.0;
        }
    }

    public static class Particle {
        public SimulationState state;
        public double mass_Kg;
        public double position_M;
        public double velocity_M_S;
        public double remainingFriction_KgM_S_S;
        public double initial_position_M;
        public double force_KgM_S_S;
        public double friction_KgM_S_S;
        public Linkage nextLink;
        public Linkage prevLink;
        public int direction;

        public Particle(SimulationState state, boolean same) {
            this.state = state;
            this.direction = same ? 1 : -1;
            this.mass_Kg = state.config.massKg;
            this.initial_position_M = 0.0;
            this.position_M = 0.0;
            this.velocity_M_S = Speed.fromMinecraft(state.velocity).metric() / 3.6 * (double)this.direction;
            this.force_KgM_S_S = state.forcesNewtons() * (double)this.direction;
            this.friction_KgM_S_S = state.frictionNewtons();
        }

        public void setup() {
            this.remainingFriction_KgM_S_S = this.friction_KgM_S_S;
            if (this.nextLink != null) {
                this.nextLink.update();
            }
        }

        public void computeVelocity(double dt_S) {
            double netForce_KgM_S_S = this.force_KgM_S_S;
            if (netForce_KgM_S_S == 0.0) {
                return;
            }
            List<Particle> particles = this.interactingParticles(netForce_KgM_S_S > 0.0);
            double totalFriction_KgM_S_S = 0.0;
            double netMass_Kg = 0.0;
            for (Particle particle : particles) {
                totalFriction_KgM_S_S += particle.remainingFriction_KgM_S_S;
                netMass_Kg += particle.mass_Kg;
            }
            double resistedForce_KgM_S_S = 0.0;
            if (Math.copySign(1.0, netForce_KgM_S_S) == Math.copySign(1.0, this.velocity_M_S)) {
                resistedForce_KgM_S_S = Math.copySign(Math.min(Math.abs(netForce_KgM_S_S), totalFriction_KgM_S_S), netForce_KgM_S_S);
                netForce_KgM_S_S -= resistedForce_KgM_S_S;
            }
            double dv_M_S = netForce_KgM_S_S * dt_S / netMass_Kg;
            if (debug) {
                ImmersiveRailroading.info((String)"Accelerating %d particles by %.7f M/S with force of %.7f KgM/S/S from starting force of %.7f KgM/S/S and friction %.7f KgM/S/S%n", (Object[])new Object[]{particles.size(), dv_M_S, netForce_KgM_S_S, this.force_KgM_S_S, totalFriction_KgM_S_S});
            }
            for (Particle particle : particles) {
                if (Math.abs(dv_M_S) > 0.0) {
                    particle.velocity_M_S += dv_M_S;
                }
                if (!(totalFriction_KgM_S_S > 0.0) || !(Math.abs(resistedForce_KgM_S_S) > 0.0)) continue;
                particle.remainingFriction_KgM_S_S -= Math.abs(resistedForce_KgM_S_S) * particle.remainingFriction_KgM_S_S / totalFriction_KgM_S_S;
            }
        }

        public void applyFriction(double dt_S) {
            if (this.remainingFriction_KgM_S_S == 0.0 || Math.abs(this.velocity_M_S) == 0.0) {
                return;
            }
            List<Particle> particles = this.interactingParticles(this.velocity_M_S < 0.0);
            double totalMass_Kg = 0.0;
            double totalVelocity_M_S = 0.0;
            for (Particle particle : particles) {
                totalMass_Kg += particle.mass_Kg;
                totalVelocity_M_S += particle.velocity_M_S;
            }
            double availableResistance_M_S = this.remainingFriction_KgM_S_S / totalMass_Kg * dt_S;
            double resistedVelocity_M_S = Math.copySign(Math.min(Math.abs(totalVelocity_M_S), availableResistance_M_S), totalVelocity_M_S);
            if (debug && Math.abs(resistedVelocity_M_S) > 1.0E-5) {
                ImmersiveRailroading.info((String)"DeltaV of %d particles totals %.7f M/S (%.7f M/S avg) from a starting velocity of %.7f M/S and resistance of %.7f M/S%n", (Object[])new Object[]{particles.size(), resistedVelocity_M_S, resistedVelocity_M_S / (double)particles.size(), totalVelocity_M_S, availableResistance_M_S});
            }
            for (Particle particle : particles) {
                particle.velocity_M_S -= resistedVelocity_M_S;
            }
            this.remainingFriction_KgM_S_S = (availableResistance_M_S - Math.abs(resistedVelocity_M_S)) * totalMass_Kg / dt_S;
        }

        public void computePosition(double dt) {
            this.position_M += this.velocity_M_S * dt;
            if (this.prevLink != null) {
                this.prevLink.correctDistance();
            }
        }

        public List<Particle> interactingParticles(boolean positive) {
            ArrayList<Particle> particles = new ArrayList<Particle>();
            particles.add(this);
            Linkage link = this.prevLink;
            while (link != null && (positive ? link.canPull : link.canPush)) {
                particles.add(link.prevParticle);
                link = ((Linkage)link).prevParticle.prevLink;
            }
            link = this.nextLink;
            while (link != null && (positive ? link.canPush : link.canPull)) {
                particles.add(link.nextParticle);
                link = ((Linkage)link).nextParticle.nextLink;
            }
            return particles;
        }

        public void processCollisions() {
            double relativeDifference;
            if (this.nextLink == null) {
                return;
            }
            Particle a = this;
            Particle b = this.nextLink.nextParticle;
            if (a.velocity_M_S > b.velocity_M_S ? !this.nextLink.canPush : !this.nextLink.canPull) {
                return;
            }
            double d = relativeDifference = Math.abs(a.velocity_M_S + b.velocity_M_S) < 0.01 ? 0.0 : Math.abs((a.velocity_M_S - b.velocity_M_S) / (a.velocity_M_S + b.velocity_M_S));
            if (relativeDifference < 1.0E-5) {
                return;
            }
            double a_j_KgM_S = a.mass_Kg * a.velocity_M_S;
            double b_j_KgM_S = b.mass_Kg * b.velocity_M_S;
            double total_m_Kg = a.mass_Kg + b.mass_Kg;
            double total_j_KgM_S = a_j_KgM_S + b_j_KgM_S;
            double a_dv_M_S = a.velocity_M_S - b.velocity_M_S;
            double b_dv_M_S = b.velocity_M_S - a.velocity_M_S;
            double a_dj_KgM_S = a.mass_Kg * a_dv_M_S;
            double b_dj_KgM_s = b.mass_Kg * b_dv_M_S;
            if (relativeDifference > 0.05) {
                double cr = 0.25;
                if (debug) {
                    ImmersiveRailroading.info((String)"Collision %s between %s and %s: %s and %s %n", (Object[])new Object[]{relativeDifference, a.state.config.id, b.state.config.id, a.velocity_M_S, b.velocity_M_S});
                }
                a.velocity_M_S = (b_dj_KgM_s * cr + total_j_KgM_S) / total_m_Kg;
                b.velocity_M_S = (a_dj_KgM_S * cr + total_j_KgM_S) / total_m_Kg;
                if (Math.abs(a.velocity_M_S + b.velocity_M_S) > 0.1) {
                    this.state.collided = Math.max(this.state.collided, relativeDifference);
                }
            } else {
                if (debug) {
                    ImmersiveRailroading.info((String)"Merge %s between %s and %s: %s and %s%n", (Object[])new Object[]{relativeDifference, a.state.config.id, b.state.config.id, a.velocity_M_S, b.velocity_M_S});
                }
                a.velocity_M_S = b.velocity_M_S = total_j_KgM_S / total_m_Kg;
            }
        }

        public SimulationState applyToState(List<Vec3i> blocksAlreadyBroken) {
            double velocityMPT = Speed.fromMetric(this.velocity_M_S * 3.6).minecraft();
            this.state.velocity = velocityMPT * (double)this.direction;
            SimulationState future = this.state.next((this.position_M - this.initial_position_M) * (double)this.direction, blocksAlreadyBroken);
            Linkage frontLink = null;
            Linkage rearLink = null;
            if (this.prevLink != null) {
                if (((Linkage)this.prevLink).prevParticle.state.config.id.equals(future.interactingFront)) {
                    frontLink = this.prevLink;
                } else if (((Linkage)this.prevLink).prevParticle.state.config.id.equals(future.interactingRear)) {
                    rearLink = this.prevLink;
                }
            }
            if (this.nextLink != null) {
                if (((Linkage)this.nextLink).nextParticle.state.config.id.equals(future.interactingFront)) {
                    frontLink = this.nextLink;
                } else if (((Linkage)this.nextLink).nextParticle.state.config.id.equals(future.interactingRear)) {
                    rearLink = this.nextLink;
                }
            }
            future.frontPushing = frontLink != null && frontLink.canPush;
            future.frontPulling = frontLink != null && frontLink.canPull;
            future.rearPushing = rearLink != null && rearLink.canPush;
            future.rearPulling = rearLink != null && rearLink.canPull;
            future.slackFrontPercent = frontLink != null ? (float)frontLink.slackPercent() : 0.0f;
            future.slackRearPercent = rearLink != null ? (float)rearLink.slackPercent() : 0.0f;
            return future;
        }
    }
}

