/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.tileentitys;

import com.google.common.collect.ImmutableMap;
import com.troblecodings.core.NBTWrapper;
import com.troblecodings.guilib.ecs.interfaces.ISyncable;
import com.troblecodings.linkableapi.ILinkableTile;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.RedstoneInput;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.core.LoadHolder;
import com.troblecodings.signals.core.SignalStateListener;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.core.StateLoadHolder;
import com.troblecodings.signals.enums.ChangedState;
import com.troblecodings.signals.enums.EnumMode;
import com.troblecodings.signals.enums.EnumState;
import com.troblecodings.signals.handler.SignalStateHandler;
import com.troblecodings.signals.handler.SignalStateInfo;
import com.troblecodings.signals.tileentitys.RedstoneIOTileEntity;
import com.troblecodings.signals.tileentitys.SyncableTileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class SignalControllerTileEntity
extends SyncableTileEntity
implements ISyncable,
ILinkableTile {
    private BlockPos linkedSignalPosition = null;
    private Signal linkedSignal = null;
    private int lastProfile = 0;
    private NBTWrapper copy;
    private EnumMode lastState;
    private BlockPos linkedRSInput = null;
    private Byte profileRSInput = -1;
    private final boolean[] currentStates = new boolean[EnumFacing.values().length];
    private final Map<Byte, Map<SEProperty, String>> allStates = new HashMap<Byte, Map<SEProperty, String>>();
    private final Map<EnumFacing, Map<EnumState, Byte>> enabledStates = new HashMap<EnumFacing, Map<EnumState, Byte>>();
    private final SignalStateListener listener = (_u, properties, state) -> {
        if (state.equals((Object)ChangedState.REMOVED_FROM_FILE)) {
            this.linkedSignalPosition = null;
            this.linkedSignal = null;
            this.allStates.clear();
            this.enabledStates.clear();
        }
    };
    public static final String SIGNAL_NAME = "signalname";
    private static final String BLOCK_POS_ID = "blockpos";
    private static final String PROFILE = "profile";
    private static final String PROPERITES = "properties";
    private static final String ALLSTATES = "allstates";
    private static final String LAST_PROFILE = "lastprofile";
    private static final String ENUM_MODE = "enummode";
    private static final String LINKED_RS_INPUT = "linkedrsinput";
    private static final String RS_INPUT_PROFILE = "rsinputprofile";

    public void setLastMode(EnumMode state) {
        this.lastState = state;
    }

    public EnumMode getLastMode() {
        if (this.lastState == null) {
            return EnumMode.MANUELL;
        }
        return this.lastState;
    }

    public int getProfile() {
        return this.lastProfile;
    }

    public void setProfile(int profile) {
        this.lastProfile = profile;
    }

    public void removePropertyFromProfile(Byte profile, SEProperty property) {
        Map<SEProperty, String> properties = this.allStates.get(profile);
        if (properties != null) {
            properties.remove(property);
        }
    }

    public void removeProfileFromDirection(EnumFacing direction, EnumState state) {
        Map<EnumState, Byte> properties = this.enabledStates.get(direction);
        if (properties != null) {
            properties.remove(state);
        }
    }

    public void updateRedstoneProfile(Byte profile, SEProperty property, String value) {
        this.allStates.computeIfAbsent(profile, _u -> new HashMap()).put(property, value);
    }

    public void updateEnabledStates(EnumFacing direction, EnumState state, int profile) {
        this.enabledStates.computeIfAbsent(direction, _u -> new HashMap()).put(state, (byte)profile);
    }

    public Map<Byte, Map<SEProperty, String>> getAllStates() {
        return ImmutableMap.copyOf(this.allStates);
    }

    public Map<EnumFacing, Map<EnumState, Byte>> getEnabledStates() {
        return ImmutableMap.copyOf(this.enabledStates);
    }

    public void setLinkedRSInput(BlockPos inputPos) {
        this.linkedRSInput = inputPos;
    }

    public BlockPos getLinkedRSInput() {
        return this.linkedRSInput;
    }

    public byte getProfileRSInput() {
        return this.profileRSInput;
    }

    public void setProfileRSInput(byte profileRSInput) {
        this.profileRSInput = profileRSInput;
    }

    @Override
    public void saveWrapper(NBTWrapper wrapper) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.linkedSignalPosition == null || this.linkedSignal == null) {
            return;
        }
        wrapper.putBlockPos(BLOCK_POS_ID, this.linkedSignalPosition);
        wrapper.putString(SIGNAL_NAME, this.linkedSignal.getSignalTypeName());
        wrapper.putInteger(LAST_PROFILE, this.lastProfile);
        if (this.lastState != null) {
            wrapper.putInteger(ENUM_MODE, this.lastState.ordinal());
        }
        for (EnumFacing direction : EnumFacing.values()) {
            if (!this.enabledStates.containsKey(direction)) continue;
            NBTWrapper comp = new NBTWrapper();
            this.enabledStates.get(direction).forEach((state, profile) -> comp.putInteger(state.getNameWrapper(), profile.byteValue()));
            wrapper.putWrapper(direction.func_176610_l(), comp);
        }
        ArrayList<NBTWrapper> list = new ArrayList<NBTWrapper>();
        this.allStates.forEach((profile, properties) -> {
            NBTWrapper comp = new NBTWrapper();
            comp.putInteger(PROFILE, profile.byteValue());
            NBTWrapper props = new NBTWrapper();
            properties.forEach((property, value) -> property.writeToNBT(props, (String)value));
            comp.putWrapper(PROPERITES, props);
            list.add(comp);
        });
        wrapper.putList(ALLSTATES, list);
        if (this.linkedRSInput != null) {
            wrapper.putBlockPos(LINKED_RS_INPUT, this.linkedRSInput);
            wrapper.putInteger(RS_INPUT_PROFILE, this.profileRSInput.byteValue());
        }
    }

    @Override
    public void loadWrapper(NBTWrapper wrapper) {
        if (wrapper.contains(BLOCK_POS_ID)) {
            this.linkedSignalPosition = wrapper.getBlockPos(BLOCK_POS_ID);
        }
        this.copy = wrapper.copy();
        if (this.field_145850_b == null) {
            return;
        }
        this.readFromWrapper(this.copy);
    }

    private void readFromWrapper(NBTWrapper wrapper) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || this.linkedSignalPosition == null) {
            return;
        }
        this.linkedSignal = Signal.SIGNALS.get(wrapper.getString(SIGNAL_NAME));
        this.lastProfile = wrapper.getInteger(LAST_PROFILE);
        this.lastState = EnumMode.values()[wrapper.getInteger(ENUM_MODE)];
        for (EnumFacing direction : EnumFacing.values()) {
            if (!wrapper.contains(direction.func_176610_l())) continue;
            NBTWrapper comp = wrapper.getWrapper(direction.func_176610_l());
            HashMap map = new HashMap();
            comp.keySet().stream().forEach(str -> {
                EnumState state = EnumState.of(str);
                map.put(state, (byte)comp.getInteger(state.getNameWrapper()));
            });
            this.enabledStates.put(direction, map);
        }
        List<NBTWrapper> list = wrapper.getList(ALLSTATES);
        List<Object> properites = this.linkedSignal == null ? new ArrayList() : this.linkedSignal.getProperties();
        list.forEach(compund -> {
            int profile = compund.getInteger(PROFILE);
            NBTWrapper comp = compund.getWrapper(PROPERITES);
            HashMap properties = new HashMap();
            properites.forEach(property -> {
                Optional<String> value = property.readFromNBT(comp);
                if (value.isPresent()) {
                    properties.put(property, value.get());
                }
            });
            this.allStates.put((byte)profile, properties);
        });
        if (wrapper.contains(LINKED_RS_INPUT)) {
            this.linkedRSInput = wrapper.getBlockPos(LINKED_RS_INPUT);
        }
        this.profileRSInput = (byte)(wrapper.contains(RS_INPUT_PROFILE) ? wrapper.getInteger(RS_INPUT_PROFILE) : -1);
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K && this.copy != null) {
            if (this.copy.contains(BLOCK_POS_ID)) {
                this.linkedSignalPosition = this.copy.getBlockPos(BLOCK_POS_ID);
            }
            this.readFromWrapper(this.copy);
            SignalStateInfo info = new SignalStateInfo(this.field_145850_b, this.linkedSignalPosition, this.linkedSignal);
            if (this.linkedSignalPosition != null && this.linkedSignal != null) {
                SignalStateHandler.loadSignal(new StateLoadHolder(info, new LoadHolder<StateInfo>(new StateInfo(this.field_145850_b, this.field_174879_c))));
                SignalStateHandler.addListener(info, this.listener);
            }
        }
    }

    public void unloadSignal() {
        if (this.linkedSignalPosition != null & this.linkedSignal != null) {
            SignalStateHandler.unloadSignal(new StateLoadHolder(new SignalStateInfo(this.field_145850_b, this.linkedSignalPosition, this.linkedSignal), new LoadHolder<StateInfo>(new StateInfo(this.field_145850_b, this.field_174879_c))));
        }
    }

    public BlockPos getLinkedPosition() {
        return this.linkedSignalPosition;
    }

    public Signal getLinkedSignal() {
        return this.linkedSignal;
    }

    @Override
    public boolean hasLink() {
        return this.linkedSignalPosition != null;
    }

    @Override
    public boolean link(BlockPos pos, NBTTagCompound tag) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("opensignals", tag.func_74779_i(pos.toString())));
        if (block != null && block instanceof Signal) {
            this.unlink();
            this.linkedSignalPosition = pos;
            this.linkedSignal = (Signal)block;
            SignalStateHandler.addListener(new SignalStateInfo(this.field_145850_b, pos, this.linkedSignal), this.listener);
            return true;
        }
        if (block instanceof RedstoneInput) {
            this.linkedRSInput = pos;
            this.loadChunkAndGetTile(RedstoneIOTileEntity.class, this.field_145850_b, pos, (tile, _u) -> tile.linkController(this.func_174877_v()));
            return true;
        }
        return false;
    }

    public void onChunkUnload() {
        this.unloadSignal();
    }

    @Override
    public boolean unlink() {
        SignalStateHandler.removeListener(new SignalStateInfo(this.field_145850_b, this.linkedSignalPosition, this.linkedSignal), this.listener);
        this.linkedSignalPosition = null;
        this.linkedSignal = null;
        this.allStates.clear();
        this.enabledStates.clear();
        return true;
    }

    public void redstoneUpdate() {
        if (this.field_145850_b.field_72995_K || this.linkedSignalPosition == null) {
            return;
        }
        for (EnumFacing face : EnumFacing.values()) {
            boolean old;
            boolean state;
            if (!this.enabledStates.containsKey(face) || (state = this.field_145850_b.func_175709_b(this.field_174879_c.func_177972_a(face), face)) == (old = this.currentStates[face.ordinal()])) continue;
            this.currentStates[face.ordinal()] = state;
            EnumState currenState = state ? EnumState.ONSTATE : EnumState.OFFSTATE;
            Byte profile = this.enabledStates.get(face).get(currenState);
            if (profile == null || !this.allStates.containsKey(profile)) continue;
            SignalStateInfo info = new SignalStateInfo(this.field_145850_b, this.linkedSignalPosition, this.linkedSignal);
            SignalStateHandler.runTaskWhenSignalLoaded(info, (stateInfo, _u1, _u2) -> SignalStateHandler.setStates(info, this.allStates.get(profile)));
        }
    }

    public void updateFromRSInput() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Map<SEProperty, String> properties = this.allStates.get(this.profileRSInput);
        if (properties != null) {
            SignalStateInfo info = new SignalStateInfo(this.field_145850_b, this.linkedSignalPosition, this.linkedSignal);
            SignalStateHandler.runTaskWhenSignalLoaded(info, (stateInfo, _u1, _u2) -> SignalStateHandler.setStates(info, properties));
        }
    }

    @Override
    public boolean isValid(EntityPlayer player) {
        return true;
    }
}

