/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.tileentitys;

import com.google.common.collect.ImmutableList;
import com.troblecodings.core.NBTWrapper;
import com.troblecodings.guilib.ecs.interfaces.ISyncable;
import com.troblecodings.signals.blocks.RedstoneIO;
import com.troblecodings.signals.blocks.RedstoneInput;
import com.troblecodings.signals.core.LinkingUpdates;
import com.troblecodings.signals.core.RedstoneUpdatePacket;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.handler.SignalBoxHandler;
import com.troblecodings.signals.signalbox.SignalBoxTileEntity;
import com.troblecodings.signals.tileentitys.SignalControllerTileEntity;
import com.troblecodings.signals.tileentitys.SyncableTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RedstoneIOTileEntity
extends SyncableTileEntity
implements ISyncable {
    private final List<BlockPos> linkedSignalController = new ArrayList<BlockPos>();
    public static final String NAME_NBT = "name";
    public static final String LINKED_LIST = "linkedList";
    public static final String LINKED_SIGNAL_CONTROLLER = "linkedSignalContrller";

    @Override
    public String getNameWrapper() {
        String name = super.getNameWrapper();
        return name == null || name.isEmpty() ? this.func_145838_q().getRegistryName().func_110623_a() : name;
    }

    @Override
    public void saveWrapper(NBTWrapper wrapper) {
        wrapper.putList(LINKED_LIST, this.linkedPositions.stream().map(NBTWrapper::getBlockPosWrapper).collect(Collectors.toList()));
        wrapper.putList(LINKED_SIGNAL_CONTROLLER, this.linkedSignalController.stream().map(NBTWrapper::getBlockPosWrapper).collect(Collectors.toList()));
    }

    @Override
    public void loadWrapper(NBTWrapper wrapper) {
        this.linkedPositions.clear();
        this.linkedSignalController.clear();
        wrapper.getList(LINKED_LIST).stream().map(NBTWrapper::getAsPos).forEach(this.linkedPositions::add);
        wrapper.getList(LINKED_SIGNAL_CONTROLLER).stream().map(NBTWrapper::getAsPos).forEach(this.linkedSignalController::add);
    }

    public void sendToAll() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean power = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)RedstoneIO.POWER);
        RedstoneUpdatePacket update = new RedstoneUpdatePacket(this.field_145850_b, this.field_174879_c, power, (RedstoneInput)this.func_145838_q());
        this.linkedPositions.forEach(pos -> this.loadChunkAndGetTile(SignalBoxTileEntity.class, this.field_145850_b, (BlockPos)pos, (tile, _u) -> tile.getSignalBoxGrid().updateInput(update)));
        this.linkedSignalController.forEach(pos -> this.loadChunkAndGetTile(SignalControllerTileEntity.class, this.field_145850_b, (BlockPos)pos, (tile, _u) -> tile.updateFromRSInput()));
    }

    public List<BlockPos> getLinkedController() {
        return ImmutableList.copyOf(this.linkedSignalController);
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        LinkingUpdates update = SignalBoxHandler.getPosUpdates(new StateInfo(this.field_145850_b, this.field_174879_c));
        if (update == null) {
            return;
        }
        update.getPosToRemove().forEach(pos -> this.unlink((BlockPos)pos));
        update.getPosToAdd().forEach(pos -> this.link((BlockPos)pos));
        if (SignalBoxHandler.containsOutputUpdates(new StateInfo(this.field_145850_b, this.field_174879_c))) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            state = state.func_177226_a((IProperty)RedstoneIO.POWER, (Comparable)Boolean.valueOf(SignalBoxHandler.getNewOutputState(new StateInfo(this.field_145850_b, this.field_174879_c))));
            this.field_145850_b.func_175656_a(this.field_174879_c, state);
        }
    }

    public void link(BlockPos pos) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.linkedPositions.contains(pos)) {
            this.linkedPositions.add(pos);
        }
    }

    public void unlink(BlockPos pos) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.linkedPositions.contains(pos)) {
            this.linkedPositions.remove(pos);
        }
    }

    public void linkController(BlockPos pos) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.linkedSignalController.contains(pos)) {
            this.linkedSignalController.add(pos);
        }
    }

    public void unlinkController(BlockPos pos) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.linkedSignalController.contains(pos)) {
            this.linkedSignalController.remove(pos);
        }
    }

    @Override
    public boolean isValid(EntityPlayer player) {
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return false;
    }
}

