/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.tileentitys;

import com.google.common.collect.Maps;
import com.troblecodings.core.NBTWrapper;
import com.troblecodings.linkableapi.ILinkableTile;
import com.troblecodings.signals.blocks.SignalBox;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.handler.SignalBoxHandler;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.SignalBoxGrid;
import com.troblecodings.signals.signalbox.SignalBoxTileEntity;
import com.troblecodings.signals.tileentitys.IChunkLoadable;
import com.troblecodings.signals.tileentitys.SyncableTileEntity;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PathwayRequesterTileEntity
extends SyncableTileEntity
implements ILinkableTile,
IChunkLoadable {
    private BlockPos linkedSignalBox;
    private Map.Entry<Point, Point> pathway = Maps.immutableEntry((Object)new Point(-1, -1), (Object)new Point(-1, -1));
    private static final String LINKED_SIGNALBOX = "linkedSignalBox";
    private static final String START_POINT = "startPoint";
    private static final String END_POINT = "endPoint";

    @Override
    public void loadWrapper(NBTWrapper wrapper) {
        this.linkedSignalBox = wrapper.getBlockPos(LINKED_SIGNALBOX);
        Point start = new Point();
        start.read(wrapper.getWrapper(START_POINT));
        Point end = new Point();
        end.read(wrapper.getWrapper(END_POINT));
        this.pathway = Maps.immutableEntry((Object)start, (Object)end);
    }

    @Override
    public void saveWrapper(NBTWrapper wrapper) {
        if (this.linkedSignalBox != null) {
            wrapper.putBlockPos(LINKED_SIGNALBOX, this.linkedSignalBox);
        }
        NBTWrapper startPoint = new NBTWrapper();
        this.pathway.getKey().write(startPoint);
        NBTWrapper endPoint = new NBTWrapper();
        this.pathway.getValue().write(endPoint);
        wrapper.putWrapper(START_POINT, startPoint);
        wrapper.putWrapper(END_POINT, endPoint);
    }

    public void requestPathway() {
        this.loadChunkAndGetTile(SignalBoxTileEntity.class, this.field_145850_b, this.linkedSignalBox, (tile, _u) -> {
            StateInfo identifier = new StateInfo(this.field_145850_b, this.linkedSignalBox);
            SignalBoxGrid grid = tile.getSignalBoxGrid();
            if (grid.getNode(this.pathway.getValue()).containsOutConnection()) {
                SignalBoxHandler.requesetInterSignalBoxPathway(identifier, this.pathway.getKey(), this.pathway.getValue());
            } else if (!grid.requestWay(this.pathway.getKey(), this.pathway.getValue())) {
                grid.addNextPathway(this.pathway.getKey(), this.pathway.getValue());
            }
        });
    }

    public void setNextPathway(Point start, Point end) {
        this.pathway = Maps.immutableEntry((Object)start, (Object)end);
    }

    @Override
    public boolean link(BlockPos pos, NBTTagCompound tag) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("opensignals", tag.func_74779_i(pos.toString())));
        if (block instanceof SignalBox) {
            this.linkedSignalBox = pos;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLink() {
        return this.linkedSignalBox != null;
    }

    @Override
    public boolean unlink() {
        this.linkedSignalBox = null;
        return true;
    }

    public BlockPos getLinkedSignalBox() {
        return this.linkedSignalBox;
    }

    public Map.Entry<Point, Point> getNextPathway() {
        return this.pathway;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return false;
    }
}

