/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox.entrys;

import com.troblecodings.core.NBTWrapper;
import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.guilib.ecs.interfaces.IIntegerable;
import com.troblecodings.signals.signalbox.entrys.IPathEntry;
import java.util.function.IntConsumer;

public class EnumEntry<T extends Enum<T>>
extends IPathEntry<T>
implements IIntegerable<T>,
IntConsumer {
    private T enumValue;
    private final Class<T> enumClass;

    public EnumEntry(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public void write(NBTWrapper tag) {
        tag.putString(this.getName(), ((Enum)this.enumValue).name());
    }

    @Override
    public void read(NBTWrapper tag) {
        this.enumValue = Enum.valueOf(this.enumClass, tag.getString(this.getName()));
    }

    @Override
    public T getValue() {
        return this.enumValue;
    }

    @Override
    public void setValue(T value) {
        this.enumValue = value;
    }

    @Override
    public T getObjFromID(int obj) {
        return (T)((Enum[])this.enumClass.getEnumConstants())[obj];
    }

    @Override
    public int count() {
        return ((Enum[])this.enumClass.getEnumConstants()).length;
    }

    @Override
    public void accept(int value) {
        this.setValue((T)this.getObjFromID(value));
    }

    @Override
    public void readNetwork(ReadBuffer buffer) {
        this.enumValue = this.getObjFromID(buffer.getInt());
    }

    @Override
    public void writeNetwork(WriteBuffer buffer) {
        buffer.putInt(((Enum)this.enumValue).ordinal());
    }
}

